/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import optas.SA.SensitivityAnalyzer;
import optas.core.AbstractFunction;
import optas.efficiencies.NashSutcliffe;
import optas.optimizer.management.SampleFactory;

public class SobolsMethod
extends SensitivityAnalyzer {
    Random rnd = new Random();
    Measure measure = Measure.FirstOrder;
    double[][] A = null;
    double[][] B = null;
    double[] yA = null;
    double[] yB = null;
    int Lh = 0;
    double EyA = 0.0;
    double VyA = 0.0;
    double EyAB;
    static final int indexUT1 = 0;
    static final int indexUT2 = 1;
    static final int indexXn = 2;
    static final int indexXslow = 0;
    static final int indexOutflow = 1;

    public SobolsMethod(Measure measure) {
        this.measure = measure;
    }

    @Override
    public void calculate() {
        int i;
        super.calculate();
        this.Lh = this.sampleSize / 2;
        this.A = new double[this.Lh][];
        this.B = new double[this.Lh][this.n];
        double[] x0A = new double[this.n];
        double[] x0B = new double[this.n];
        this.yA = new double[this.Lh];
        this.yB = new double[this.Lh];
        ArrayList<SampleFactory.Sample> x = this.getRandomSampling();
        this.EyAB = 0.0;
        this.VyA = 0.0;
        this.EyA = 0.0;
        for (i = 0; i < this.Lh; ++i) {
            for (int j = 0; j < this.n; ++j) {
                x0A[j] = x.get((int)i).x[j];
                x0B[j] = x.get((int)(i + this.Lh)).x[j];
            }
            this.A[i] = this.transformToUnitCube(x0A);
            this.yA[i] = x.get(i).F()[0];
            this.B[i] = this.transformToUnitCube(x0B);
            this.yB[i] = x.get(i + this.Lh).F()[0];
            this.EyA += this.yA[i];
            this.EyAB += this.yA[i] * this.yB[i];
        }
        this.EyA /= (double)this.Lh;
        this.EyAB /= (double)this.Lh;
        for (i = 0; i < this.Lh; ++i) {
            this.VyA += this.yA[i] * this.yA[i];
        }
        this.VyA = this.VyA / (double)this.Lh - this.EyA * this.EyA;
        this.VyA = this.VyA * (double)this.Lh / (double)(this.Lh - 1);
        for (int k = 0; k < this.n; ++k) {
            TreeSet<Integer> set = new TreeSet<Integer>();
            set.add(k);
            double[] r = this.getSensitivity(set);
            double Si = r[0];
            double ST = r[1];
            if (this.measure == Measure.FirstOrder) {
                this.sensitivityIndex[k] = Si;
                continue;
            }
            if (this.measure == Measure.Total) {
                this.sensitivityIndex[k] = ST;
                continue;
            }
            if (this.measure != Measure.Interaction) continue;
            this.sensitivityIndex[k] = ST - Si;
        }
    }

    public double[] getSensitivity(Set<Integer> indexSet) {
        double[] sensitivityIndex = new double[3];
        double[][] D = new double[this.Lh][this.n];
        double[] yD = new double[this.Lh];
        for (int i = 0; i < this.Lh; ++i) {
            for (int j = 0; j < this.n; ++j) {
                D[i][j] = indexSet.contains(j) ? this.B[i][j] : this.A[i][j];
            }
            yD[i] = this.evaluateModel(D[i]);
        }
        double Si = 0.0;
        double STi = 0.0;
        double colSum = 0.0;
        double colSum2 = 0.0;
        for (int i = 0; i < this.Lh; ++i) {
            colSum += this.yB[i] * yD[i];
            colSum2 += this.yA[i] * yD[i];
        }
        double VCE = colSum / (double)(this.Lh - 1) - this.EyAB;
        double VCEcomp = colSum2 / (double)(this.Lh - 1) - this.EyA * this.EyA;
        VCEcomp = 1.0 - VCEcomp / this.VyA;
        System.out.println("S/ST-" + indexSet.toString() + ":" + String.format(Locale.ENGLISH, "%.3f / %.3f", VCE /= this.VyA, VCEcomp) + "\t\t");
        sensitivityIndex[0] = VCE;
        sensitivityIndex[1] = VCEcomp;
        sensitivityIndex[2] = STi - Si;
        return sensitivityIndex;
    }

    public static double[] linres(double x_slow, double inflow, double outflow, double Rs) {
        double[] result = new double[2];
        x_slow = (1.0 - Rs) * x_slow + (1.0 - Rs) * inflow;
        result[1] = Rs / (1.0 - Rs) * x_slow;
        result[0] = x_slow;
        return result;
    }

    public static double[] excess(double x_loss, double cmax, double bexp, double Pval, double PETval) {
        double[] result = new double[3];
        double xn_prev = x_loss;
        double ct_prev = cmax * (1.0 - Math.pow(1.0 - (bexp + 1.0) * xn_prev / cmax, 1.0 / (bexp + 1.0)));
        result[0] = Math.max(Pval - cmax + ct_prev, 0.0);
        double dummy = Math.min((ct_prev + (Pval -= result[0])) / cmax, 1.0);
        double xn = cmax / (bexp + 1.0) * (1.0 - Math.pow(1.0 - dummy, bexp + 1.0));
        result[1] = Math.max(Pval - (xn - xn_prev), 0.0);
        double evap = Math.min(xn, PETval);
        result[2] = xn -= evap;
        return result;
    }

    public static void main(String[] args) {
        AbstractFunction f = new AbstractFunction(){

            /*
             * Opcode count of 19975 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
             */
            @Override
            public double[] evaluate(double[] z) {
                double cmax = z[0] * 300.0 + 200.0;
                double bexp = z[1] * 1.9 + 0.1;
                double alpha = z[2] * 0.49 + 0.5;
                double ks = z[3] * 0.1 + 1.0E-6;
                double kq = z[4] * 0.175 + 0.375;
                int nq = 3;
                int effStart = 67;
                double convFactor = 22.3;
                double x_loss = 0.0;
                double x_slow = 2.3503 / (ks * convFactor);
                double outflow = 0.0;
                double[] x_quick = new double[nq];
                for (int i = 0; i < nq; ++i) {
                    x_quick[i] = 0.0;
                }
                double[][] LeafRiver = new double[][]{{17.22, 6.8, 2.3503}, {6.49, 5.17, 2.3786}, {3.19, 4.28, 2.7184}, {2.46, 4.84, 3.0299}, {0.0, 2.55, 3.8228}, {0.0, 4.35, 3.4264}, {0.0, 4.14, 2.8317}, {4.77, 5.57, 2.6052}, {11.08, 6.13, 2.4636}, {9.55, 4.88, 3.2282}, {0.0, 5.18, 6.4563}, {3.26, 5.14, 4.021}, {3.18, 2.49, 3.7095}, {0.0, 4.17, 3.9644}, {1.68, 4.04, 3.3981}, {0.0, 2.79, 2.945}, {0.0, 3.32, 2.7751}, {1.28, 5.22, 2.7468}, {0.0, 4.91, 2.6901}, {0.0, 5.38, 2.4353}, {1.03, 6.63, 2.322}, {42.79, 4.96, 2.2937}, {0.0, 4.24, 3.0016}, {3.02, 4.63, 5.9466}, {0.0, 3.22, 3.7945}, {6.87, 5.3, 3.8228}, {1.12, 3.46, 3.3131}, {6.09, 3.0, 3.4264}, {0.0, 2.67, 3.2282}, {0.0, 4.28, 2.7751}, {0.0, 7.15, 2.5485}, {0.0, 6.65, 2.407}, {0.0, 6.08, 2.322}, {0.0, 5.66, 2.2087}, {0.0, 3.05, 2.1804}, {4.59, 2.57, 2.322}, {5.95, 2.95, 2.4919}, {0.0, 5.28, 2.2654}, {0.0, 6.29, 2.2371}, {0.0, 5.21, 2.2937}, {0.0, 5.06, 2.2654}, {0.0, 2.87, 2.1238}, {0.0, 4.68, 2.0672}, {0.0, 3.04, 2.0388}, {0.0, 5.57, 2.0105}, {0.42, 6.09, 1.9539}, {2.13, 2.3, 1.9822}, {6.85, 1.24, 2.0672}, {15.92, 0.81, 2.3503}, {0.0, 3.17, 2.8883}, {0.0, 5.8, 2.8883}, {0.06, 4.24, 2.6335}, {0.77, 0.64, 2.4353}, {0.0, 0.85, 2.3503}, {0.0, 1.26, 2.2937}, {0.0, 1.59, 2.2937}, {0.0, 6.07, 2.2654}, {0.0, 5.58, 2.2087}, {0.0, 2.23, 2.1238}, {0.0, 4.47, 2.0672}, {0.0, 5.7, 2.0105}, {0.0, 5.38, 2.0105}, {0.0, 5.28, 1.9822}, {0.0, 5.27, 1.9539}, {0.0, 4.95, 1.9539}, {0.0, 4.83, 1.9256}, {0.0, 5.44, 1.8972}, {0.0, 5.71, 1.8689}, {0.0, 4.88, 1.8406}, {0.0, 3.85, 1.8406}, {0.0, 2.96, 1.8406}, {0.0, 3.26, 1.8406}, {0.0, 4.63, 1.8406}, {0.0, 1.58, 1.8972}, {0.0, 4.14, 1.9539}, {0.0, 3.97, 1.9822}, {0.0, 3.99, 2.0105}, {0.0, 3.86, 2.0105}, {0.0, 2.81, 1.9822}, {0.0, 3.16, 1.9539}, {0.0, 4.07, 1.9256}, {0.0, 4.33, 1.9256}, {0.0, 4.72, 1.8972}, {0.0, 4.86, 1.8972}, {0.0, 5.13, 1.8689}, {0.0, 3.84, 1.8406}, {0.0, 2.6, 1.8406}, {0.0, 3.63, 1.8689}, {0.0, 3.99, 1.9256}, {0.0, 3.79, 1.9539}, {0.0, 3.72, 1.9822}, {0.0, 3.52, 2.0105}, {0.0, 4.23, 1.9822}, {0.0, 3.37, 1.9539}, {0.0, 1.32, 1.9539}, {0.0, 1.87, 2.0105}, {0.0, 2.17, 2.0672}, {0.0, 2.56, 2.1521}, {0.0, 2.07, 2.1804}, {0.0, 2.99, 2.2087}, {0.0, 1.7, 2.1804}, {0.0, 2.27, 2.1804}, {0.0, 3.48, 2.1804}, {0.0, 2.6, 2.2371}, {16.67, 1.0, 2.2654}, {7.43, 0.24, 2.7184}, {0.0, 1.94, 3.0016}, {0.0, 2.5, 3.0582}, {0.0, 2.22, 2.8883}, {0.0, 2.15, 2.7468}, {0.0, 2.91, 2.7184}, {0.0, 1.49, 2.6901}, {0.0, 1.11, 2.6901}, {29.82, 0.72, 2.8317}, {6.64, 2.87, 4.021}, {0.0, 2.53, 5.5785}, {0.0, 2.39, 4.4175}, {0.0, 2.04, 3.4547}, {0.34, 2.24, 3.0866}, {0.3, 1.43, 2.8883}, {13.13, 0.68, 2.8317}, {0.0, 1.49, 3.0582}, {0.05, 1.21, 3.2848}, {0.0, 1.62, 3.2848}, {17.55, 0.68, 3.1998}, {0.0, 0.44, 3.3981}, {5.49, 0.86, 3.5963}, {2.76, 0.39, 3.8511}, {2.55, 0.31, 3.9644}, {28.1, 0.71, 4.0777}, {0.0, 2.23, 5.3236}, {0.0, 1.92, 6.7395}, {0.0, 0.89, 5.7484}, {0.0, 0.83, 5.0971}, {20.39, 1.03, 4.3892}, {2.94, 2.87, 5.5502}, {0.0, 2.06, 8.3252}, {0.0, 1.75, 6.5129}, {0.0, 1.62, 5.4935}, {0.0, 1.46, 4.6157}, {0.0, 1.52, 4.1626}, {0.0, 1.6, 3.9078}, {0.0, 0.89, 3.6246}, {0.0, 1.3, 3.4547}, {18.53, 0.99, 3.4547}, {0.29, 1.99, 4.4741}, {0.0, 0.91, 5.3803}, {3.63, 1.06, 5.3236}, {0.0, 0.97, 5.0404}, {2.76, 0.31, 4.8422}, {0.24, 0.65, 4.6157}, {0.0, 0.73, 4.3892}, {0.0, 0.6, 4.1626}, {0.0, 1.38, 3.8511}, {1.01, 0.43, 3.7379}, {40.64, 0.33, 4.1626}, {0.72, 1.18, 13.2807}, {0.07, 1.2, 14.1019}, {8.71, 2.29, 12.3463}, {0.0, 2.11, 13.1958}, {0.0, 1.83, 11.9498}, {0.0, 2.11, 10.4207}, {0.0, 1.93, 9.0048}, {1.98, 0.9, 7.2209}, {14.37, 0.76, 6.5129}, {18.99, 0.84, 7.3908}, {0.06, 0.67, 15.6311}, {0.5, 2.07, 18.4061}, {0.0, 1.97, 21.8042}, {0.0, 1.31, 17.3018}, {0.0, 1.45, 11.5534}, {1.77, 1.22, 8.665}, {5.33, 1.48, 7.2775}, {37.53, 0.24, 8.4668}, {0.0, 1.97, 45.3074}, {0.0, 1.69, 63.7135}, {0.0, 1.65, 88.3494}, {0.0, 2.19, 84.385}, {4.81, 0.68, 54.3689}, {32.98, 1.15, 67.1116}, {0.0, 2.27, 75.8899}, {0.0, 2.42, 74.1909}, {0.0, 2.43, 70.7928}, {0.0, 1.08, 52.3867}, {1.44, 1.11, 28.8835}, {0.0, 2.68, 18.2079}, {0.0, 2.42, 14.6116}, {0.25, 1.26, 12.7144}, {0.0, 0.65, 11.3835}, {0.13, 0.84, 10.5057}, {0.37, 0.98, 9.7411}, {0.0, 1.81, 9.2597}, {0.0, 1.19, 8.6367}, {17.92, 0.48, 8.1836}, {0.0, 2.18, 9.1747}, {0.0, 2.83, 11.9781}, {0.0, 1.38, 21.521}, {0.0, 1.8, 16.1124}, {17.07, 2.03, 13.1958}, {4.58, 1.62, 17.6699}, {0.0, 2.19, 26.0517}, {40.0, 0.53, 36.8123}, {1.91, 2.84, 84.385}, {0.0, 1.62, 96.2782}, {0.0, 1.85, 104.207}, {0.0, 2.12, 104.207}, {17.65, 0.67, 65.6957}, {37.85, 1.37, 62.2977}, {4.01, 0.95, 110.1536}, {0.0, 1.17, 135.9222}, {10.54, 0.67, 155.7442}, {45.01, 0.19, 196.804}, {12.52, 0.17, 225.9707}, {0.83, 1.52, 240.1292}, {0.0, 3.2, 286.0029}, {0.0, 1.84, 223.139}, {0.0, 0.96, 126.0112}, {0.0, 1.64, 82.686}, {4.01, 1.73, 60.5986}, {0.0, 1.71, 45.3074}, {0.0, 3.0, 33.9805}, {0.0, 1.82, 27.7508}, {0.0, 1.63, 23.22}, {0.0, 4.0, 20.9547}, {0.0, 2.15, 18.7459}, {8.64, 0.69, 17.6699}, {17.37, 0.77, 20.9547}, {24.71, 0.91, 31.7152}, {0.0, 1.6, 90.6148}, {22.79, 0.98, 124.029}, {3.23, 2.38, 176.1325}, {0.0, 2.75, 147.8154}, {0.37, 2.61, 122.0468}, {11.23, 0.9, 100.2426}, {0.0, 2.04, 100.2426}, {0.13, 0.69, 84.385}, {0.0, 1.93, 62.2977}, {25.9, 2.75, 46.7233}, {0.48, 2.9, 66.5452}, {0.0, 4.44, 82.686}, {0.0, 5.24, 79.2879}, {0.0, 3.78, 62.2977}, {5.4, 1.63, 45.3074}, {0.0, 4.38, 32.5647}, {0.0, 4.86, 26.6181}, {0.0, 2.67, 23.7864}, {0.0, 1.33, 20.9547}, {0.08, 2.42, 18.2079}, {1.14, 0.75, 16.6221}, {0.0, 4.68, 15.1213}, {0.0, 4.72, 13.6489}, {0.0, 2.34, 12.2613}, {27.65, 0.75, 12.7144}, {0.0, 2.76, 23.7864}, {0.0, 2.42, 39.644}, {0.12, 1.11, 42.4757}, {6.68, 4.89, 39.644}, {1.68, 3.24, 27.1844}, {24.61, 2.05, 43.042}, {0.0, 5.25, 53.8025}, {0.0, 3.99, 43.8915}, {7.53, 3.52, 36.8123}, {0.79, 6.12, 28.8835}, {0.0, 3.87, 20.9547}, {9.23, 2.68, 18.2079}, {0.0, 5.51, 17.6699}, {0.0, 5.15, 15.6027}, {0.0, 5.52, 13.1958}, {0.0, 5.0, 11.3835}, {0.0, 3.62, 10.0809}, {57.2, 1.75, 10.0809}, {6.84, 4.13, 91.4643}, {0.0, 6.41, 116.1002}, {0.0, 4.97, 120.0646}, {0.0, 3.3, 120.0646}, {72.32, 1.29, 72.4918}, {0.0, 5.62, 187.4594}, {0.0, 1.58, 201.9011}, {11.43, 1.92, 240.1292}, {52.39, 2.54, 302.9932}, {35.9, 0.89, 365.2908}, {0.03, 0.94, 387.9446}, {2.61, 3.81, 342.6372}, {0.38, 6.09, 258.5352}, {0.0, 5.82, 151.7798}, {0.0, 3.83, 88.3494}, {0.0, 5.38, 60.5986}, {0.0, 5.46, 43.8915}, {0.0, 4.92, 28.8835}, {0.38, 0.96, 23.7864}, {17.93, 1.35, 21.521}, {23.2, 0.87, 36.8123}, {0.01, 2.61, 58.8996}, {55.87, 3.1, 70.7928}, {8.17, 1.09, 191.9901}, {2.69, 2.86, 277.2246}, {0.0, 4.94, 300.1614}, {0.0, 4.73, 252.3056}, {0.0, 4.91, 155.7442}, {0.0, 5.1, 92.3138}, {0.0, 5.02, 58.8996}, {0.0, 5.88, 43.8915}, {0.0, 6.7, 27.1844}, {0.0, 7.12, 20.9547}, {0.0, 7.85, 17.6699}, {0.0, 6.61, 15.1213}, {0.0, 5.89, 13.6489}, {0.0, 3.61, 12.2613}, {0.0, 6.34, 11.3835}, {0.0, 8.17, 10.4207}, {0.0, 7.23, 9.7411}, {0.4, 4.6, 9.1747}, {0.0, 3.13, 8.5518}, {0.0, 4.77, 8.3819}, {0.0, 5.11, 7.9571}, {0.0, 3.93, 7.589}, {13.36, 5.76, 7.1076}, {0.06, 6.24, 9.1747}, {7.19, 3.92, 10.4207}, {0.0, 3.62, 9.1747}, {0.0, 6.55, 7.589}, {1.22, 6.77, 6.6828}, {0.0, 5.6, 6.2015}, {0.0, 5.05, 5.9183}, {0.0, 6.98, 5.7201}, {0.0, 7.1, 5.4086}, {0.0, 7.21, 5.267}, {9.06, 6.17, 5.0971}, {1.73, 7.09, 7.6173}, {0.0, 3.26, 5.6068}, {0.0, 5.94, 4.9272}, {6.6, 4.43, 4.5591}, {4.51, 3.27, 4.4175}, {2.49, 3.55, 4.5874}, {4.84, 1.88, 4.5874}, {8.36, 0.88, 5.4086}, {2.4, 4.96, 5.3519}, {0.0, 5.8, 5.5502}, {0.87, 4.55, 5.5502}, {0.67, 5.74, 5.0121}, {0.0, 5.85, 4.5591}, {2.65, 6.15, 4.3042}, {0.0, 5.75, 3.9078}, {0.13, 6.54, 3.6529}, {20.95, 6.37, 3.5396}, {4.59, 5.09, 6.7395}, {21.18, 6.44, 10.9304}, {0.0, 4.87, 12.7144}, {0.0, 3.9, 7.9571}, {0.0, 4.28, 6.0315}, {0.0, 1.04, 4.9555}, {0.0, 1.01, 4.5024}, {19.92, 2.9, 4.5024}, {13.89, 0.82, 10.6756}, {1.93, 1.72, 12.7144}, {16.1, 4.21, 7.8722}, {10.98, 2.42, 9.0898}, {27.71, 0.93, 18.2079}, {20.46, 1.54, 21.521}, {23.74, 2.82, 50.9708}, {1.34, 1.4, 92.3138}, {6.95, 3.52, 77.5889}, {0.0, 4.12, 67.3948}, {0.0, 5.87, 48.1391}, {0.04, 7.61, 27.7508}, {1.38, 5.46, 15.1213}, {4.11, 6.14, 10.7605}, {3.7, 2.73, 9.2597}, {0.0, 2.73, 11.3835}, {0.4, 3.79, 10.2508}, {0.0, 4.01, 7.8722}, {0.0, 4.46, 6.7961}, {0.0, 5.22, 6.0315}, {0.0, 5.94, 5.5502}, {0.0, 6.02, 5.1537}, {0.0, 6.32, 4.8705}, {3.06, 6.53, 4.5874}, {0.0, 5.45, 4.5024}, {2.1, 6.81, 4.4175}, {0.0, 6.49, 4.4741}, {0.0, 5.46, 4.2476}, {0.0, 5.92, 4.0777}, {12.42, 5.88, 3.9927}, {3.08, 4.86, 5.267}, {0.7, 5.24, 5.3519}, {0.47, 3.49, 5.0121}, {3.9, 3.73, 4.7856}, {0.13, 3.46, 4.4175}, {0.37, 4.62, 4.3042}, {4.6, 0.94, 4.644}, {9.1, 0.91, 5.8616}, {0.15, 1.6, 7.3908}, {0.0, 1.82, 5.6634}, {0.0, 0.78, 4.9272}, {0.0, 1.09, 4.4741}, {15.55, 1.69, 4.2476}, {61.22, 1.95, 20.8414}, {47.56, 2.92, 67.3948}, {0.0, 2.59, 106.1892}, {0.0, 6.04, 69.0938}, {0.0, 5.21, 41.0598}, {0.0, 3.3, 23.7864}, {0.8, 3.64, 12.2613}, {4.69, 1.12, 8.9482}, {0.0, 4.23, 7.4474}, {0.0, 6.89, 6.428}, {0.0, 6.62, 5.7484}, {0.0, 6.41, 5.3519}, {0.0, 6.17, 4.9272}, {0.0, 6.12, 4.7006}, {0.0, 4.39, 4.4175}, {0.0, 3.53, 4.2476}, {0.0, 2.04, 4.0777}, {0.0, 2.37, 3.9927}, {0.02, 5.38, 3.8228}, {0.0, 5.23, 3.7945}, {0.0, 4.72, 3.6529}, {0.0, 4.4, 3.568}, {0.03, 5.02, 3.483}, {0.0, 5.36, 3.3981}, {0.0, 6.19, 3.3414}, {0.0, 6.77, 3.1998}, {0.0, 5.4, 3.1432}, {0.0, 1.71, 3.1432}, {0.0, 2.31, 3.1432}, {0.0, 4.44, 3.1432}, {0.0, 5.37, 3.1715}, {0.0, 5.51, 3.1432}, {0.0, 5.61, 3.0866}, {0.0, 4.95, 3.0016}, {0.0, 2.23, 2.945}, {0.0, 2.93, 2.945}, {0.0, 3.85, 2.9167}, {0.0, 4.49, 2.8883}, {0.0, 3.95, 2.8034}, {0.18, 3.97, 2.8034}, {0.0, 4.11, 2.7751}, {0.0, 4.42, 2.7468}, {0.0, 4.77, 2.7468}, {0.0, 4.55, 2.7468}, {0.0, 4.63, 2.7468}, {0.0, 2.03, 2.7468}, {0.0, 4.42, 2.7468}, {0.0, 4.31, 2.6901}, {0.0, 4.14, 2.6618}, {0.0, 4.29, 2.6335}, {0.0, 4.45, 2.6052}, {0.0, 4.3, 2.6052}, {0.0, 2.99, 2.6052}, {0.0, 4.09, 2.6052}, {0.0, 3.59, 2.6052}, {0.0, 2.8, 2.6052}, {0.0, 1.73, 2.6052}, {0.0, 1.4, 2.6052}, {0.0, 3.54, 2.6052}, {6.86, 0.76, 2.6052}, {0.0, 1.7, 2.6335}, {0.0, 3.71, 2.6901}, {0.0, 3.91, 2.7751}, {0.0, 1.53, 2.7468}, {0.0, 0.9, 2.6901}, {0.0, 1.02, 2.7468}, {0.0, 2.5, 2.7751}, {0.0, 1.56, 2.7751}, {0.86, 0.38, 2.8034}, {0.99, 2.95, 2.8317}, {0.0, 3.41, 2.8317}, {0.47, 1.18, 2.8317}, {0.05, 0.58, 2.8317}, {0.0, 3.26, 2.8317}, {0.0, 3.02, 2.8317}, {0.0, 2.66, 2.8317}, {0.0, 2.72, 2.8317}, {0.0, 2.65, 2.8883}, {0.0, 2.64, 2.8883}, {0.0, 1.12, 2.9167}, {0.0, 0.8, 2.9167}, {0.0, 1.62, 2.9167}, {0.0, 1.1, 2.9167}, {19.02, 0.4, 3.0299}, {1.75, 1.91, 4.3042}, {0.05, 0.9, 4.9555}, {29.01, 2.44, 5.1254}, {0.0, 1.97, 8.4951}, {4.81, 2.07, 7.0226}, {0.0, 2.79, 5.4086}, {0.0, 2.7, 4.644}, {0.0, 2.12, 4.1343}, {0.0, 1.44, 3.8228}, {12.45, 0.69, 4.1343}, {0.0, 0.58, 5.4086}, {0.0, 2.26, 5.6351}, {0.0, 0.79, 4.8139}, {50.58, 0.57, 7.9854}, {0.0, 0.92, 25.4854}, {5.95, 0.71, 22.0874}, {11.89, 2.37, 28.2039}, {0.0, 1.32, 28.8835}, {3.51, 0.55, 18.8026}, {37.02, 0.91, 33.9805}, {0.0, 1.25, 52.3867}, {29.82, 0.38, 48.1391}, {0.01, 0.3, 82.686}, {3.58, 0.26, 58.8996}, {0.01, 2.4, 48.1391}, {0.0, 1.77, 38.2281}, {0.0, 1.93, 26.6181}, {0.0, 1.48, 18.8026}, {0.0, 1.04, 14.8382}, {0.0, 0.68, 12.2047}, {6.79, 0.63, 11.7799}, {0.0, 1.18, 13.0542}, {10.39, 1.56, 29.733}, {0.0, 1.56, 26.0517}, {0.0, 1.84, 17.2451}, {0.0, 1.92, 13.0542}, {0.0, 1.53, 11.3835}, {3.47, 0.8, 10.2791}, {17.78, 0.24, 10.5906}, {11.45, 0.15, 21.521}, {2.71, 0.53, 41.0598}, {0.0, 1.8, 41.0598}, {0.0, 1.71, 33.9805}, {0.0, 1.07, 26.6181}, {0.0, 1.63, 19.3406}, {0.38, 0.6, 15.2912}, {0.0, 1.91, 13.479}, {0.0, 1.38, 12.2047}, {0.0, 1.92, 10.987}, {0.0, 1.69, 10.1942}, {0.55, 0.92, 9.6561}, {10.94, 0.3, 9.5712}, {0.0, 1.74, 11.3835}, {0.0, 0.74, 15.7726}, {0.0, 0.78, 17.7548}, {0.3, 1.14, 15.7726}, {28.61, 0.43, 13.479}, {0.0, 1.13, 55.5016}, {0.0, 0.63, 58.8996}, {0.0, 0.7, 57.2006}, {0.0, 1.12, 50.9708}, {1.4, 1.15, 41.0598}, {17.92, 0.83, 24.3527}, {3.32, 0.56, 24.9191}, {0.0, 0.2, 45.3074}, {0.0, 0.73, 55.5016}, {0.0, 0.78, 46.7233}, {0.0, 0.64, 32.5647}, {1.24, 0.77, 21.521}, {0.0, 2.03, 17.2451}, {2.03, 1.49, 15.2912}, {18.23, 0.69, 15.7726}, {0.0, 1.4, 29.4498}, {0.0, 2.46, 50.9708}, {0.0, 2.13, 50.9708}, {0.0, 3.28, 33.9805}, {0.0, 2.89, 21.521}, {0.0, 2.78, 16.254}, {0.0, 2.98, 13.479}, {0.0, 2.33, 12.2047}, {0.0, 2.3, 10.987}, {0.0, 3.15, 10.2791}, {0.25, 1.66, 9.8827}, {1.01, 2.25, 9.5712}, {0.0, 3.1, 9.1181}, {0.02, 2.16, 8.665}, {2.24, 1.64, 8.3536}, {0.22, 1.84, 8.3536}, {2.11, 2.32, 8.4951}, {0.0, 3.09, 9.3447}, {0.0, 2.16, 9.1747}, {2.65, 1.29, 8.665}, {20.27, 2.81, 14.3001}, {0.0, 3.32, 28.8835}, {0.0, 3.35, 28.3171}, {7.31, 1.24, 27.1844}, {0.0, 3.5, 19.8786}, {0.0, 3.73, 16.7354}, {0.0, 1.94, 15.2912}, {4.44, 1.92, 13.932}, {0.7, 2.88, 13.0542}, {0.4, 3.26, 15.2912}, {7.15, 1.83, 15.2912}, {0.62, 3.45, 13.0542}, {1.04, 2.93, 12.6294}, {0.38, 0.6, 12.2047}, {0.0, 1.93, 11.3835}, {0.0, 3.17, 10.5057}, {0.0, 0.97, 9.7977}, {0.0, 2.83, 9.0332}, {0.0, 3.79, 8.5801}, {0.0, 3.46, 8.2686}, {0.0, 2.01, 7.9005}, {0.58, 1.18, 7.6173}, {0.0, 4.04, 7.2492}, {0.0, 3.46, 6.9094}, {0.0, 3.2, 6.5413}, {0.0, 1.77, 6.2864}, {1.74, 1.2, 6.1448}, {30.07, 2.46, 12.6294}, {0.0, 3.43, 31.1488}, {0.0, 3.64, 36.8123}, {0.0, 3.69, 32.5647}, {0.0, 1.58, 22.6537}, {0.0, 1.67, 14.8382}, {9.36, 0.79, 11.7799}, {4.04, 0.82, 12.6294}, {63.6, 0.66, 41.6262}, {0.0, 0.68, 149.7976}, {0.17, 1.18, 158.0096}, {0.0, 2.11, 204.4496}, {0.13, 3.7, 151.7798}, {0.0, 4.71, 77.5889}, {0.0, 2.55, 50.9708}, {0.0, 2.93, 35.3964}, {0.0, 2.51, 22.0874}, {0.0, 4.24, 17.7548}, {0.0, 2.31, 14.8382}, {0.0, 4.3, 13.0542}, {2.09, 1.55, 12.2047}, {0.4, 1.78, 11.3835}, {0.3, 2.66, 10.5906}, {2.76, 2.68, 9.8827}, {5.1, 3.49, 9.7977}, {0.0, 4.87, 10.5057}, {0.0, 4.17, 9.8827}, {47.73, 1.44, 9.1181}, {30.63, 1.53, 46.4401}, {0.0, 5.59, 86.3672}, {0.0, 5.7, 100.2426}, {0.0, 4.18, 114.118}, {0.0, 4.08, 65.6957}, {2.17, 4.68, 36.8123}, {0.52, 2.49, 23.7864}, {3.21, 1.87, 16.7354}, {0.04, 3.52, 13.479}, {0.58, 3.75, 12.6294}, {0.0, 3.9, 13.0542}, {0.0, 3.53, 11.3835}, {2.45, 2.98, 10.1092}, {0.15, 4.11, 9.2597}, {0.05, 4.11, 8.2686}, {4.6, 4.46, 7.3908}, {28.84, 4.07, 6.8244}, {10.31, 0.78, 14.6116}, {0.0, 5.82, 31.1488}, {0.0, 5.85, 41.0598}, {0.0, 6.12, 39.644}, {0.0, 3.74, 26.6181}, {0.04, 6.01, 13.932}, {10.23, 3.14, 9.9676}, {10.5, 2.83, 9.2597}, {25.52, 3.87, 27.7225}, {15.77, 1.0, 53.8025}, {0.32, 0.96, 104.207}, {2.92, 4.92, 92.3138}, {0.0, 5.06, 84.385}, {0.0, 4.58, 63.9967}, {0.0, 3.82, 38.2281}, {2.5, 4.87, 21.521}, {0.43, 2.69, 14.8382}, {0.0, 6.77, 11.7799}, {0.0, 6.42, 10.1942}, {0.0, 6.3, 8.8066}, {0.0, 3.18, 7.9005}, {0.0, 4.8, 7.2492}, {0.0, 1.68, 6.6262}, {0.97, 0.81, 6.2015}, {17.22, 2.64, 5.9466}, {0.0, 4.17, 9.0332}, {0.0, 4.63, 7.3908}, {0.0, 4.46, 7.9005}, {0.0, 4.93, 7.0226}, {0.0, 5.64, 6.2864}, {0.0, 5.17, 5.6351}, {5.1, 4.89, 5.182}, {0.0, 7.6, 4.8139}, {0.0, 5.04, 4.5024}, {0.0, 5.99, 4.3042}, {0.0, 4.89, 4.2759}, {0.0, 5.11, 4.0777}, {0.0, 5.41, 4.0493}, {0.27, 6.28, 3.8511}, {0.0, 6.47, 3.7379}, {0.21, 7.07, 3.568}, {4.01, 6.17, 3.568}, {0.13, 4.56, 3.3981}, {2.48, 3.63, 3.7945}, {0.0, 2.57, 3.7379}, {6.05, 4.46, 3.9644}, {5.22, 2.88, 4.4458}, {0.29, 3.68, 5.0688}, {0.0, 5.24, 4.2759}, {27.74, 4.29, 3.6812}, {0.0, 4.77, 3.7379}, {3.43, 4.09, 3.7945}, {0.5, 5.87, 3.9644}, {0.0, 5.91, 3.8228}, {0.0, 6.8, 3.8511}, {1.95, 2.52, 3.4547}, {0.21, 6.33, 3.4547}, {0.39, 7.07, 3.8228}, {0.02, 8.16, 3.1715}, {0.49, 2.87, 3.0016}, {0.0, 3.35, 2.945}, {4.05, 3.99, 2.8317}, {1.75, 3.66, 2.8317}, {10.03, 2.4, 3.3414}, {3.54, 3.69, 4.0777}, {0.0, 2.35, 4.3042}, {25.09, 4.65, 3.6529}, {23.29, 3.78, 14.3851}, {0.0, 5.1, 19.8786}, {6.71, 3.03, 17.7548}, {0.0, 7.14, 26.0517}, {0.0, 4.6, 18.4628}, {0.0, 5.53, 7.3058}, {0.0, 5.11, 5.2953}, {19.05, 6.23, 4.3042}, {0.42, 3.15, 6.4846}, {4.21, 3.72, 5.0121}, {4.93, 3.75, 7.2492}, {0.0, 3.58, 5.4086}, {0.0, 3.75, 4.9555}, {0.0, 5.91, 4.644}, {0.65, 6.11, 3.9078}, {11.76, 3.48, 3.4547}, {0.19, 4.18, 3.1998}, {0.54, 5.04, 4.0777}, {2.2, 2.48, 4.9555}, {0.74, 2.02, 3.8511}, {6.03, 0.79, 3.483}, {0.0, 2.6, 3.6529}, {0.0, 5.4, 3.6246}, {0.0, 6.51, 3.2848}, {0.0, 6.05, 3.0582}, {1.05, 5.53, 2.9167}, {0.54, 4.28, 2.8034}, {0.0, 5.63, 2.8034}, {0.0, 5.23, 2.6901}, {0.21, 5.51, 2.6335}, {0.0, 2.73, 2.6052}, {1.18, 5.47, 2.6052}, {0.0, 3.14, 2.6052}, {0.0, 7.25, 2.4353}, {0.0, 7.13, 2.3503}, {0.0, 6.64, 2.2654}, {0.0, 5.81, 2.1804}, {0.0, 4.8, 2.1521}, {0.0, 5.63, 2.1521}, {0.0, 4.75, 2.1238}, {0.0, 4.06, 2.1238}, {0.92, 3.44, 2.0955}, {8.35, 3.68, 2.0672}, {0.0, 4.67, 2.0672}, {1.98, 3.71, 2.0388}, {3.74, 2.18, 2.0672}, {0.0, 3.99, 2.1238}, {0.0, 4.65, 2.1238}, {0.0, 4.17, 2.0955}, {0.0, 3.04, 2.0672}, {0.63, 3.58, 2.0105}, {0.0, 6.09, 1.9822}, {0.0, 7.08, 1.8972}, {0.0, 6.38, 1.8689}, {0.0, 7.04, 1.8406}, {0.0, 6.62, 1.8406}, {0.0, 6.46, 1.8123}, {0.0, 6.09, 1.8123}, {0.0, 3.44, 1.8123}, {0.0, 1.85, 1.8123}, {0.06, 4.82, 1.8406}, {5.25, 4.84, 1.9256}, {0.0, 5.21, 2.1238}, {0.97, 5.46, 1.9822}, {0.0, 5.3, 1.8972}, {0.0, 6.4, 1.8406}, {0.0, 6.07, 1.8123}, {0.0, 4.6, 1.784}, {0.0, 3.34, 1.784}, {3.27, 0.76, 1.784}, {17.04, 1.74, 2.1804}, {0.0, 4.23, 2.4636}, {0.0, 4.39, 2.4919}, {0.0, 4.67, 2.2937}, {0.78, 3.72, 2.1238}, {0.0, 6.13, 2.0388}, {0.0, 6.0, 2.0105}, {0.0, 4.17, 1.9822}, {0.0, 4.44, 1.9822}, {0.0, 3.53, 1.9256}, {0.0, 4.35, 1.8972}, {0.0, 2.62, 1.8972}, {1.79, 3.52, 1.8972}, {1.59, 3.66, 1.9256}, {0.0, 2.41, 1.9822}, {0.0, 4.73, 1.9822}, {6.94, 3.37, 1.9822}, {1.95, 4.32, 2.0388}, {0.0, 4.41, 2.0388}, {0.38, 4.35, 2.0672}, {0.0, 2.72, 1.9256}, {0.0, 1.98, 1.8972}, {0.0, 2.83, 1.8972}, {0.0, 3.0, 1.8689}, {0.0, 3.16, 1.8406}, {37.53, 1.35, 2.0388}, {6.94, 0.86, 3.0299}, {0.5, 3.26, 3.483}, {0.0, 5.16, 2.8883}, {0.0, 3.96, 2.4636}, {0.0, 3.68, 2.1804}, {0.0, 3.72, 2.0955}, {0.0, 4.13, 2.0388}, {0.0, 3.94, 2.0105}, {0.0, 3.14, 1.9822}, {0.0, 2.61, 1.9822}, {0.0, 2.49, 2.0105}, {0.0, 3.16, 2.0105}, {0.0, 3.52, 2.0388}, {0.0, 2.0, 2.0672}, {4.78, 2.36, 2.0672}, {2.86, 0.59, 2.0955}, {0.0, 3.0, 2.2937}, {0.0, 1.4, 2.322}, {0.0, 2.95, 2.2654}, {0.0, 2.7, 2.1804}, {0.0, 2.64, 2.1521}, {0.22, 2.47, 2.1238}, {23.66, 0.41, 2.4636}, {0.0, 1.86, 2.9167}, {0.0, 2.49, 3.0582}, {0.0, 2.64, 2.7751}, {0.0, 2.55, 2.5769}, {0.0, 1.45, 2.4636}, {0.0, 1.67, 2.4353}, {0.0, 1.18, 2.407}, {0.0, 2.85, 2.322}, {0.0, 2.67, 2.322}, {0.0, 0.92, 2.322}, {23.82, 0.29, 2.4636}, {8.55, 0.95, 2.945}, {0.0, 2.02, 3.1715}, {0.04, 1.71, 3.2848}, {0.37, 3.0, 3.1432}, {0.0, 2.68, 2.945}, {0.0, 2.5, 2.8317}, {0.0, 2.16, 2.7468}, {0.05, 2.28, 2.6335}, {0.0, 2.99, 2.6052}, {0.0, 2.38, 2.5202}, {0.0, 2.52, 2.4919}, {3.67, 1.21, 2.5202}, {4.76, 2.29, 2.6618}, {0.0, 3.17, 2.6335}, {0.0, 1.88, 2.6052}, {0.75, 2.02, 2.6052}, {0.0, 0.78, 2.5769}, {0.0, 0.96, 2.6335}, {0.0, 1.27, 2.6052}, {0.0, 2.4, 2.6052}, {0.0, 2.82, 2.5202}, {0.0, 1.89, 2.4919}, {1.61, 1.49, 2.5202}, {2.77, 2.8, 2.6618}, {0.0, 2.18, 2.6901}, {0.0, 2.02, 2.6901}, {19.59, 0.43, 2.945}, {0.0, 0.61, 3.9078}, {0.0, 1.6, 4.1343}, {0.0, 2.22, 3.6529}, {0.0, 1.97, 3.3414}, {17.52, 0.59, 3.3981}, {0.21, 2.25, 3.9927}, {0.0, 1.93, 4.3042}, {0.0, 1.3, 3.6529}, {0.0, 1.71, 3.3414}, {0.0, 2.04, 3.1998}, {0.0, 1.27, 3.1432}, {0.0, 0.73, 3.0582}, {0.0, 1.98, 3.0016}, {0.0, 0.55, 2.9167}, {14.81, 0.5, 3.0016}, {65.1, 0.63, 6.7112}, {16.33, 1.72, 60.5986}, {0.0, 1.49, 42.1925}, {6.15, 0.42, 26.3349}, {4.55, 0.3, 17.9814}, {0.13, 0.27, 13.1391}, {0.0, 0.46, 9.7977}, {0.27, 0.82, 7.6739}, {0.0, 1.58, 6.5413}, {0.18, 1.14, 5.7767}, {0.0, 1.31, 5.2387}, {0.15, 1.0, 4.8989}, {9.43, 0.68, 4.644}, {16.42, 0.84, 5.6634}, {0.0, 1.27, 10.5906}, {0.0, 0.6, 8.4102}, {0.0, 2.51, 10.5057}, {0.0, 1.35, 7.8155}, {29.39, 0.35, 6.966}, {6.6, 0.1, 16.3673}, {0.0, 0.38, 23.22}, {26.11, 0.66, 28.2605}, {0.0, 1.18, 45.0242}, {0.0, 1.38, 40.7767}, {10.34, 0.33, 39.3608}, {0.0, 1.1, 30.8657}, {0.04, 0.36, 21.9741}, {0.0, 1.8, 17.9814}, {0.0, 2.11, 14.9798}, {0.0, 1.69, 11.8366}, {4.83, 0.42, 9.7977}, {0.0, 1.68, 8.9482}, {0.0, 2.2, 8.1836}, {0.0, 1.9, 7.3058}, {0.0, 1.39, 6.6262}, {0.46, 1.52, 6.0882}, {0.0, 1.51, 5.8333}, {0.0, 1.09, 5.4652}, {0.69, 0.85, 5.2387}, {66.72, 0.35, 7.9854}, {24.76, 0.57, 101.3753}, {0.0, 1.41, 141.0193}, {0.0, 2.53, 165.372}, {0.0, 2.46, 225.6875}, {2.45, 1.85, 119.4983}, {0.0, 2.8, 67.1116}, {0.0, 2.46, 48.1391}, {0.0, 2.38, 33.9805}, {0.0, 2.06, 21.9741}, {0.05, 2.65, 17.9814}, {3.85, 2.07, 15.4612}, {0.0, 1.7, 14.4984}, {0.0, 0.42, 13.1391}, {0.0, 0.75, 12.2613}, {8.13, 0.79, 11.4118}, {39.36, 0.24, 13.5639}, {4.85, 0.24, 65.4126}, {0.0, 1.57, 90.3316}, {0.0, 1.47, 112.9853}, {0.0, 2.96, 100.5258}, {0.0, 1.4, 68.8106}, {0.0, 1.98, 48.1391}, {0.0, 1.71, 33.4142}, {0.0, 1.46, 20.7848}, {0.0, 2.49, 16.4239}, {0.0, 2.22, 14.4984}, {0.0, 2.0, 12.6861}, {0.0, 3.04, 11.4118}, {1.6, 2.49, 10.4207}, {0.0, 2.25, 9.6561}, {0.0, 3.67, 9.0332}, {0.0, 2.04, 8.4951}, {0.0, 2.58, 8.127}, {0.0, 3.84, 7.7589}, {0.0, 4.17, 7.3908}, {0.0, 2.59, 7.1076}, {0.81, 2.96, 6.7678}, {0.0, 3.7, 6.6828}, {0.0, 3.19, 6.428}, {0.0, 3.31, 6.2864}, {0.23, 3.07, 6.0315}, {19.67, 2.36, 26.6747}, {3.28, 3.32, 33.4142}, {10.48, 2.51, 15.4612}, {0.0, 2.81, 15.4612}, {0.0, 3.14, 12.6861}, {0.0, 3.69, 10.5057}, {0.72, 3.9, 8.9482}, {0.0, 2.11, 7.6173}, {0.0, 2.97, 6.966}, {0.0, 2.18, 6.4846}, {0.0, 2.91, 6.1448}, {0.0, 3.74, 5.9466}, {0.0, 3.83, 5.6351}, {14.38, 0.85, 5.8333}, {0.0, 4.98, 11.4118}, {0.0, 4.98, 10.987}, {0.0, 1.23, 9.6561}, {2.07, 4.38, 8.2686}, {0.0, 4.15, 6.9094}, {0.8, 1.66, 8.9765}, {0.0, 1.76, 11.4118}, {20.87, 0.48, 11.4118}, {35.32, 0.34, 22.6537}, {0.02, 3.62, 65.4126}, {63.06, 1.67, 72.2087}, {30.12, 3.53, 219.4577}, {0.0, 5.62, 286.0029}, {0.0, 4.61, 348.3005}, {0.0, 2.92, 348.3005}, {0.0, 4.77, 125.728}, {0.0, 3.85, 65.4126}, {0.0, 2.11, 46.4401}, {0.0, 2.57, 27.6092}, {5.1, 3.35, 20.1901}, {0.0, 4.77, 16.9336}, {0.0, 2.6, 14.4984}, {0.0, 5.05, 12.6861}, {0.0, 6.03, 10.987}, {0.0, 3.98, 9.5712}, {0.0, 3.28, 8.5801}, {0.0, 4.86, 7.9005}, {0.0, 4.25, 7.2492}, {0.0, 6.24, 6.7678}, {0.0, 5.54, 6.2015}, {0.0, 6.41, 5.7201}, {0.0, 5.79, 5.4652}, {0.0, 5.6, 5.1254}, {0.0, 5.67, 4.8422}, {1.05, 4.88, 4.644}, {0.0, 4.36, 4.4458}, {0.0, 4.24, 4.2193}, {0.0, 3.84, 4.1343}, {0.0, 3.56, 3.9927}, {0.0, 2.68, 3.8228}, {0.2, 2.04, 3.6812}, {0.0, 3.56, 3.6246}, {2.75, 5.06, 3.5396}, {4.49, 4.41, 3.4547}, {2.31, 2.06, 3.568}, {2.45, 1.91, 4.7856}, {2.99, 2.61, 4.5591}, {7.02, 2.07, 3.6246}, {26.38, 3.69, 5.3236}, {6.31, 5.16, 8.127}, {0.0, 6.56, 7.6173}, {37.93, 2.24, 6.1448}, {6.2, 4.61, 11.1853}, {0.0, 5.8, 27.6092}, {0.0, 5.43, 23.843}, {0.0, 4.83, 26.3349}, {1.18, 5.42, 26.3349}, {11.28, 3.73, 13.4506}, {0.0, 6.98, 10.5906}, {0.0, 5.59, 8.3536}, {0.0, 7.24, 6.4846}, {0.0, 6.48, 5.6917}, {0.0, 5.11, 5.0688}, {0.0, 5.28, 4.6157}, {11.26, 4.04, 4.3325}, {11.13, 2.48, 4.3325}, {0.0, 5.74, 4.729}, {0.0, 3.68, 7.4474}, {5.44, 2.6, 7.2775}, {16.48, 1.66, 6.0599}, {0.0, 6.21, 6.0032}, {0.0, 6.82, 6.2581}, {0.0, 6.91, 5.7201}, {0.0, 4.38, 5.3803}, {11.55, 3.82, 5.5218}, {0.0, 4.79, 6.9377}, {0.0, 6.4, 6.9377}, {0.0, 7.42, 6.2581}, {0.0, 7.31, 4.8705}, {0.0, 7.48, 4.1626}, {0.71, 6.95, 3.8511}, {10.61, 6.33, 3.568}, {0.0, 4.77, 3.5113}, {0.0, 5.04, 3.4264}, {0.0, 4.3, 3.2848}, {17.19, 4.85, 3.3414}, {0.0, 3.53, 3.4264}, {0.0, 3.38, 3.2848}, {3.84, 3.11, 3.3414}, {0.0, 3.34, 3.1432}, {0.0, 3.65, 3.0299}, {0.0, 4.75, 2.945}, {2.77, 4.01, 2.9167}, {8.56, 4.42, 2.945}, {2.99, 5.45, 2.9733}, {8.54, 6.08, 3.4264}, {3.62, 6.17, 3.9361}, {0.0, 5.09, 5.7201}, {1.11, 4.15, 4.6157}, {0.64, 2.69, 4.5874}, {1.33, 3.75, 4.729}, {1.23, 1.82, 3.7095}, {8.82, 1.22, 3.7379}, {23.3, 1.91, 4.2759}, {0.59, 2.07, 5.0688}, {12.7, 2.16, 5.5785}, {21.1, 2.89, 11.2136}, {1.01, 2.92, 10.0526}, {0.34, 4.64, 9.5429}, {17.81, 4.98, 10.5906}, {0.0, 2.58, 26.9579}, {5.55, 2.17, 30.8657}, {1.91, 3.88, 35.3964}, {0.26, 4.48, 24.8907}, {0.0, 5.57, 11.5534}, {1.29, 4.24, 8.0421}, {15.15, 1.21, 6.8244}, {3.74, 4.63, 25.7119}, {19.25, 3.8, 12.1764}, {9.7, 2.19, 26.8729}, {0.32, 5.18, 37.9449}, {4.42, 1.14, 22.4555}, {23.36, 0.97, 26.7597}, {0.0, 1.67, 36.5291}, {7.39, 5.93, 25.089}, {0.15, 3.62, 18.661}, {0.0, 4.21, 13.0259}, {0.0, 4.28, 9.0332}, {3.58, 3.75, 7.2775}, {0.0, 2.48, 10.987}, {4.44, 5.86, 6.9377}, {3.04, 6.08, 6.6545}, {0.0, 3.83, 6.5979}, {0.0, 4.09, 5.4369}, {0.0, 4.68, 5.3236}, {0.0, 4.26, 4.7573}, {0.0, 6.16, 4.2476}, {0.0, 6.95, 3.8511}, {0.0, 6.37, 3.6246}, {0.0, 6.78, 3.4264}, {0.0, 6.67, 3.2565}, {0.0, 6.63, 3.0866}, {0.0, 6.72, 3.0299}, {6.32, 5.7, 2.945}, {0.0, 3.07, 2.9167}, {0.0, 5.69, 3.5963}, {0.7, 1.64, 7.504}, {2.37, 1.29, 5.267}, {0.79, 2.89, 3.9644}, {0.0, 4.03, 3.5396}, {7.95, 4.82, 3.4547}, {0.0, 2.38, 4.729}, {0.17, 1.58, 4.0493}, {0.0, 3.5, 3.3414}, {0.0, 4.46, 3.1432}, {0.0, 1.31, 2.9733}, {0.0, 0.62, 2.8317}, {0.0, 1.2, 2.8034}, {0.0, 3.45, 2.7751}, {0.0, 5.14, 2.6901}, {0.0, 4.6, 2.5769}, {0.0, 3.57, 2.4919}, {0.0, 4.69, 2.407}, {0.0, 1.5, 2.3786}, {0.0, 1.38, 2.3503}, {0.0, 1.46, 2.322}, {0.0, 3.64, 2.2937}, {0.0, 2.93, 2.322}, {0.0, 2.77, 2.322}, {0.0, 4.02, 2.2937}, {0.0, 5.22, 2.2654}, {0.0, 5.39, 2.2371}, {0.0, 4.39, 2.1804}, {0.0, 2.55, 2.1521}, {16.87, 2.01, 2.2087}, {0.0, 3.09, 3.0582}, {0.0, 3.76, 2.6335}, {0.0, 4.91, 2.407}, {7.84, 4.14, 2.3503}, {2.43, 4.27, 2.2937}, {0.0, 3.91, 2.2937}, {0.79, 4.58, 2.3503}};
                int n = LeafRiver.length;
                double[] obsQ = new double[n - effStart];
                double[] simQ = new double[n - effStart];
                for (int j = 0; j < n; ++j) {
                    double precip = LeafRiver[j][0];
                    double pet = LeafRiver[j][1];
                    double runoff = LeafRiver[j][2];
                    double[] tmp1 = SobolsMethod.excess(x_loss, cmax, bexp, precip, pet);
                    double UT1 = tmp1[0];
                    double UT2 = tmp1[1];
                    x_loss = tmp1[2];
                    double UQ = alpha * UT2 + UT1;
                    double US = (1.0 - alpha) * UT2;
                    double[] tmp2 = SobolsMethod.linres(x_slow, US, outflow, ks);
                    x_slow = tmp2[0];
                    double QS = outflow = tmp2[1];
                    double inflow = UQ;
                    for (int i = 0; i < nq; ++i) {
                        double[] tmp3 = SobolsMethod.linres(x_quick[i], inflow, outflow, kq);
                        x_quick[i] = tmp3[0];
                        inflow = outflow = tmp3[1];
                    }
                    double out = (QS + outflow) * convFactor;
                    double xqVolume = 0.0;
                    double xsVolume = 0.0;
                    for (int k = 0; k < nq; ++k) {
                        xqVolume += x_quick[k];
                    }
                    xsVolume += x_slow;
                    double xq = xqVolume;
                    if (j <= effStart) continue;
                    simQ[j - effStart] = out;
                    obsQ[j - effStart] = runoff;
                }
                NashSutcliffe nash = new NashSutcliffe(2.0);
                double d = nash.calc(obsQ, simQ);
                return new double[]{d};
            }

            @Override
            public int getInputDimension() {
                return 5;
            }

            @Override
            public int getOutputDimension() {
                return 1;
            }

            @Override
            public double[][] getRange() {
                return new double[][]{{0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}, {0.0, 1.0}};
            }

            @Override
            public void log(String msg) {
                System.out.println(msg);
            }
        };
        int n = 5;
        double[][] result = new double[n][3];
        ArrayList<double[]> statistics = new ArrayList<double[]>();
        double[] mean = new double[n];
        double[] sigma = new double[n];
        double currentMaxError = 1000.0;
        double maxAcceptedError = 0.015;
        double[] min = new double[n];
        double[] max = new double[n];
        for (int i = 0; i < n; ++i) {
            min[i] = Double.MAX_VALUE;
            max[i] = Double.MIN_VALUE;
        }
        double z = 1.96;
        int i = 0;
        while (currentMaxError > maxAcceptedError || i++ < 5) {
            int j;
            SobolsMethod sobol = new SobolsMethod(Measure.Total);
            sobol.setModel(f);
            sobol.setSampleSize(100000);
            double[] sensitivityIndex = new double[n];
            for (j = 0; j < n; ++j) {
                sensitivityIndex[j] = sobol.getSensitivity(j);
            }
            statistics.add(Arrays.copyOf(sensitivityIndex, n));
            for (j = 0; j < n; ++j) {
                int n2 = j;
                mean[n2] = mean[n2] + sensitivityIndex[j];
                sigma[j] = 0.0;
                min[j] = Math.min(min[j], sensitivityIndex[j]);
                max[j] = Math.max(max[j], sensitivityIndex[j]);
            }
            double K = statistics.size();
            int k = 0;
            while ((double)k < K) {
                int j2 = 0;
                while (j2 < n) {
                    double v = ((double[])statistics.get(k))[j2] - mean[j2] / K;
                    int n3 = j2++;
                    sigma[n3] = sigma[n3] + v * v;
                }
                ++k;
            }
            currentMaxError = 0.0;
            for (int j3 = 0; j3 < n; ++j3) {
                int n4 = j3;
                sigma[n4] = sigma[n4] / (K - 1.0);
                sigma[j3] = Math.sqrt(sigma[j3]);
                double error_mean = z * sigma[j3] / Math.sqrt(K);
                currentMaxError = Math.max(error_mean, currentMaxError);
            }
            System.out.println("current error:" + currentMaxError);
        }
        int j = 0;
        while (j < n) {
            int n5 = j++;
            mean[n5] = mean[n5] / (double)statistics.size();
        }
        System.out.println("******************************************");
        System.out.println("Uncertainty calculation finished");
        System.out.println("id\tmu\tsigma\tmin\tmax");
        for (j = 0; j < n; ++j) {
            System.out.println(j + 1 + "\t" + String.format(Locale.ENGLISH, "%.3f", mean[j]) + "\t" + String.format(Locale.ENGLISH, "%.4f", sigma[j]) + "\t" + String.format(Locale.ENGLISH, "%.3f", min[j]) + "\t" + String.format(Locale.ENGLISH, "%.3f", max[j]));
        }
        System.out.println("******************************************");
        for (j = 0; j < n; ++j) {
            result[j] = new double[]{mean[j] - 1.96 * sigma[j], mean[j], mean[j] + 1.96 * sigma[j]};
        }
    }

    public static enum Measure {
        FirstOrder,
        Total,
        Interaction;

    }
}

