/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.util.ArrayList;
import optas.core.AbstractDataSerie;
import optas.core.AbstractFunction;
import optas.core.AbstractModel;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.management.SampleFactory;
import optas.sampler.LatinHyperCubeSampler;
import optas.sampler.RandomSampler;
import optas.sampler.SobolsSequence;

public abstract class SensitivityAnalyzer {
    protected int n;
    protected int m;
    protected int sampleSize = 1000;
    private AbstractModel model = null;
    private double[][] range = null;
    double[] sensitivityIndex;
    double[] sensitivityVariance;
    boolean isVarianceCalulated = false;
    SamplingMethod sm = SamplingMethod.URS;

    private double[][] getParameterRange() {
        return this.range;
    }

    public void setModel(AbstractModel model) {
        this.model = model;
        this.range = (double[][])model.getRange().clone();
        this.n = model.getInputDimension();
        this.m = model.getOutputDimension();
        this.range = this.getParameterRange();
        this.sensitivityIndex = null;
        this.sensitivityVariance = null;
    }

    public AbstractModel getModel() {
        return this.model;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
        this.sensitivityIndex = null;
        this.sensitivityVariance = null;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSamplingMethod(SamplingMethod sm) {
        this.sm = sm;
    }

    protected ArrayList<SampleFactory.Sample> getRandomSampling() {
        if (this.model instanceof AbstractFunction) {
            Optimizer sampler = null;
            switch (this.sm) {
                case Sobol: {
                    sampler = new SobolsSequence();
                    break;
                }
                case URS: {
                    sampler = new RandomSampler();
                    break;
                }
                case URSStatic: {
                    sampler = new RandomSampler();
                    break;
                }
                case LatinHyperCube: {
                    sampler = new LatinHyperCubeSampler();
                    break;
                }
                case Default: {
                    sampler = new RandomSampler();
                    break;
                }
                default: {
                    sampler = new RandomSampler();
                }
            }
            sampler.setFunction((AbstractFunction)this.model);
            sampler.setVerbose(false);
            if (this.sm == SamplingMethod.URSStatic) {
                sampler.setDebugMode(true);
            } else {
                sampler.setDebugMode(false);
            }
            sampler.setMaxn(this.sampleSize);
            sampler.optimize();
            return sampler.getSamples();
        }
        if (this.model instanceof AbstractDataSerie) {
            AbstractDataSerie staticModel = (AbstractDataSerie)this.model;
            staticModel.reset();
            SampleFactory.Sample s = null;
            ArrayList<SampleFactory.Sample> result = new ArrayList<SampleFactory.Sample>();
            while ((s = staticModel.getNext()) != null && result.size() < this.sampleSize) {
                result.add(s);
            }
            return result;
        }
        return null;
    }

    void calculate() {
        this.sensitivityIndex = new double[this.n];
        this.sensitivityVariance = new double[this.n];
    }

    public double getSensitivity(int parameter) {
        if (this.sensitivityIndex == null) {
            this.calculate();
        }
        return this.sensitivityIndex[parameter];
    }

    protected double[] transformFromUnitCube(double[] x) {
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            y[i] = this.range[i][0] + x[i] * (this.range[i][1] - this.range[i][0]);
        }
        return y;
    }

    protected double[] transformToUnitCube(double[] x) {
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            y[i] = (x[i] - this.range[i][0]) / (this.range[i][1] - this.range[i][0]);
        }
        return y;
    }

    protected double evaluateModel(double[] x) {
        if (this.model instanceof AbstractFunction) {
            try {
                return ((AbstractFunction)this.model).evaluate(this.transformFromUnitCube(x))[0];
            }
            catch (SampleLimitException sle) {
                return 0.0;
            }
            catch (ObjectiveAchievedException oae) {
                return 0.0;
            }
        }
        throw new UnsupportedOperationException("Not supported by Model!");
    }

    public static enum SamplingMethod {
        Sobol,
        URS,
        URSStatic,
        LatinHyperCube,
        Default;

    }
}

