/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import java.util.Random;
import optas.SA.SensitivityAnalyzer;

public class FAST
extends SensitivityAnalyzer {
    Random rnd = new Random();
    Measure measure = Measure.FirstOrder;
    int[] omega = new int[]{191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291};

    public FAST(Measure measure) {
        this.measure = measure;
    }

    @Override
    public void calculate() {
        super.calculate();
        if (this.measure == Measure.FirstOrder) {
            this.calcFirstOrderSensitivity();
        } else {
            this.calcTotalVariance();
        }
    }

    private double[] X(double s) {
        double[] y = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            y[j] = Math.IEEEremainder((double)this.omega[j] * s, Math.PI * 2) / 2.0 * Math.PI;
        }
        return y;
    }

    private void calcFirstOrderSensitivity() {
        int j;
        int N = 2;
        int q = 2 * N * this.omega[this.n] + 1;
        double sum = 0.0;
        for (j = 0; j < this.n; ++j) {
            double[] Aj = new double[N + 1];
            double[] Bj = new double[N + 1];
            for (int m = 1; m <= N; ++m) {
                Aj[m] = 0.0;
                Bj[m] = 0.0;
                for (int k = -q; k <= q; ++k) {
                    double sk = Math.PI * (double)k / (double)(2 * q + 1);
                    double[] Xsk = this.X(sk);
                    double y = this.evaluateModel(Xsk);
                    int n = m;
                    Aj[n] = Aj[n] + y * Math.cos((double)(this.omega[j] * m) * sk);
                    int n2 = m;
                    Bj[n2] = Bj[n2] + y * Math.sin((double)(this.omega[j] * m) * sk);
                }
            }
            this.sensitivityIndex[j] = 2.0 * Aj[2] * Aj[2] + Bj[1] * Bj[1];
            sum += this.sensitivityIndex[j];
        }
        j = 0;
        while (j < this.n) {
            int n = j++;
            this.sensitivityIndex[n] = this.sensitivityIndex[n] / sum;
        }
    }

    private void calcTotalVariance() {
        int j;
        int N = 2;
        int q = 2 * N * this.omega[this.n] + 1;
        double sum = 0.0;
        for (j = 0; j < this.n; ++j) {
            double[] Aj = new double[N + 1];
            double[] Bj = new double[N + 1];
            for (int m = 0; m <= N; ++m) {
                Aj[m] = 0.0;
                Bj[m] = 0.0;
                for (int k = -q; k <= q; ++k) {
                    double sk = Math.PI * (double)k / (double)(2 * q + 1);
                    double[] Xsk = this.X(sk);
                    double y = this.evaluateModel(Xsk);
                    int n = m;
                    Aj[n] = Aj[n] + y * y * Math.cos((double)(this.omega[j] * m) * sk);
                    int n2 = m;
                    Bj[n2] = Bj[n2] + y * Math.cos((double)(this.omega[j] * m) * sk);
                }
            }
            this.sensitivityIndex[j] = Aj[0] - Bj[0] * Bj[0];
            sum += this.sensitivityIndex[j];
        }
        j = 0;
        while (j < this.n) {
            int n = j++;
            this.sensitivityIndex[n] = this.sensitivityIndex[n] / sum;
        }
    }

    public static enum Measure {
        FirstOrder,
        Total;

    }
}

