/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFDeflateCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4GRImage
extends ScalarDS {
    private static final long serialVersionUID = 1029672744963360976L;
    private List attributeList;
    private int grid;
    private int ncomp;
    private int datatypeID = -1;
    private int nAttributes = -1;

    public H4GRImage(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    public H4GRImage(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
        this.palette = null;
        this.isImageDisplay = true;
        this.isImage = true;
        this.unsignedConverted = false;
        this.grid = ((H4File)this.getFileFormat()).getGRAccessID();
    }

    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            this.grid = ((H4File)this.getFileFormat()).getGRAccessID();
            int id = this.open();
            String[] objName = new String[]{""};
            int[] grInfo = new int[4];
            int[] idims = new int[2];
            try {
                HDFLibrary.GRgetiminfo((int)id, (String[])objName, (int[])grInfo, (int[])idims);
                this.nAttributes = grInfo[3];
            }
            catch (Exception ex) {
                this.nAttributes = 0;
            }
            this.close(id);
        }
        return this.nAttributes > 0;
    }

    public Dataset copy(Group pgroup, String dname, long[] dims, Object buff) throws Exception {
        H4GRImage dataset = null;
        int srcdid = -1;
        int dstdid = -1;
        String path = null;
        int[] count = null;
        if (pgroup == null) {
            return null;
        }
        path = pgroup.isRoot() ? "/" : pgroup.getPath() + pgroup.getName() + "/";
        srcdid = this.open();
        if (srcdid < 0) {
            return null;
        }
        if (dims != null) {
            count = new int[]{(int)dims[0], (int)dims[1]};
        }
        int[] grInfo = new int[4];
        try {
            String[] tmpName = new String[]{""};
            int[] tmpDims = new int[2];
            HDFLibrary.GRgetiminfo((int)srcdid, (String[])tmpName, (int[])grInfo, (int[])tmpDims);
            if (count == null) {
                count = tmpDims;
            }
        }
        catch (HDFException ex) {
            // empty catch block
        }
        int ncomp = grInfo[0];
        int tid = grInfo[1];
        int interlace = grInfo[2];
        int numberOfAttributes = grInfo[3];
        dstdid = HDFLibrary.GRcreate((int)((H4File)pgroup.getFileFormat()).getGRAccessID(), (String)dname, (int)ncomp, (int)tid, (int)interlace, (int[])count);
        if (dstdid < 0) {
            return null;
        }
        short ref = HDFLibrary.GRidtoref((int)dstdid);
        if (!pgroup.isRoot()) {
            int vgid = pgroup.open();
            HDFLibrary.Vaddtagref((int)vgid, (int)306, (int)ref);
            pgroup.close(vgid);
        }
        int[] start = new int[]{0, 0};
        if (buff == null) {
            buff = new byte[count[0] * count[1] * HDFLibrary.DFKNTsize((int)tid)];
            HDFLibrary.GRreadimage((int)srcdid, (int[])start, null, (int[])count, (Object)buff);
        }
        HDFLibrary.GRwriteimage((int)dstdid, (int[])start, null, (int[])count, (Object)buff);
        int pid = HDFLibrary.GRgetlutid((int)srcdid, (int)0);
        int[] palInfo = new int[4];
        HDFLibrary.GRgetlutinfo((int)pid, (int[])palInfo);
        palInfo[1] = 21;
        int palSize = palInfo[0] * palInfo[3];
        byte[] palBuff = new byte[palSize];
        HDFLibrary.GRreadlut((int)pid, (byte[])palBuff);
        pid = HDFLibrary.GRgetlutid((int)dstdid, (int)0);
        HDFLibrary.GRwritelut((int)pid, (int)palInfo[0], (int)palInfo[1], (int)palInfo[2], (int)palInfo[3], (byte[])palBuff);
        this.copyAttribute(srcdid, dstdid, numberOfAttributes);
        long[] oid = new long[]{306L, ref};
        dataset = new H4GRImage(pgroup.getFileFormat(), dname, path, oid);
        pgroup.addToMemberList((HObject)dataset);
        this.close(srcdid);
        try {
            HDFLibrary.GRendaccess((int)dstdid);
        }
        catch (HDFException ex) {
            // empty catch block
        }
        return dataset;
    }

    public byte[][] readPalette(int idx) {
        return null;
    }

    public byte[] getPaletteRefs() {
        return null;
    }

    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(this.datatypeID);
        }
        return this.datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws HDFException {
        int id;
        byte[] theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((id = this.open()) < 0) {
            return null;
        }
        try {
            HDFLibrary.GRreqimageil((int)id, (int)this.interlace);
            int datasize = this.getWidth() * this.getHeight() * this.ncomp;
            int size = HDFLibrary.DFKNTsize((int)this.datatypeID) * datasize;
            theData = new byte[size];
            int[] start = new int[]{(int)this.startDims[0], (int)this.startDims[1]};
            int[] select = new int[]{(int)this.selectedDims[0], (int)this.selectedDims[1]};
            int[] stride = null;
            if (this.selectedStride != null) {
                stride = new int[this.rank];
                for (int i = 0; i < this.rank; ++i) {
                    stride[i] = (int)this.selectedStride[i];
                }
            }
            HDFLibrary.GRreadimage((int)id, (int[])start, (int[])stride, (int[])select, (byte[])theData);
        }
        finally {
            this.close(id);
        }
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read() throws HDFException {
        int id;
        Object theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((id = this.open()) < 0) {
            return null;
        }
        try {
            HDFLibrary.GRreqimageil((int)id, (int)this.interlace);
            int datasize = this.getWidth() * this.getHeight() * this.ncomp;
            theData = H4Datatype.allocateArray(this.datatypeID, datasize);
            if (theData != null) {
                HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
                int[] start = new int[]{(int)this.startDims[0], (int)this.startDims[1]};
                int[] select = new int[]{(int)this.selectedDims[0], (int)this.selectedDims[1]};
                int[] stride = null;
                if (this.selectedStride != null) {
                    stride = new int[this.rank];
                    for (int i = 0; i < this.rank; ++i) {
                        stride[i] = (int)this.selectedStride[i];
                    }
                }
                HDFLibrary.GRreadimage((int)id, (int[])start, (int[])stride, (int[])select, (Object)theData);
            }
        }
        finally {
            this.close(id);
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[1] <= this.selectedIndex[0];
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object buf) throws HDFException {
        if (buf == null) {
            return;
        }
        int id = this.open();
        if (id < 0) {
            return;
        }
        int[] select = new int[this.rank];
        int[] start = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            select[i] = (int)this.selectedDims[i];
            start[i] = (int)this.startDims[i];
        }
        int[] stride = null;
        if (this.selectedStride != null) {
            stride = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                stride[i] = (int)this.selectedStride[i];
            }
        }
        Object tmpData = buf;
        try {
            if (this.isUnsigned && this.unsignedConverted) {
                tmpData = H4GRImage.convertToUnsignedC((Object)buf);
            }
            HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
            HDFLibrary.GRwriteimage((int)id, (int[])start, (int[])stride, (int[])select, (Object)tmpData);
        }
        finally {
            tmpData = null;
            this.close(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int id = this.open();
        String[] objName = new String[]{""};
        int[] grInfo = new int[4];
        int[] idims = new int[2];
        try {
            HDFLibrary.GRgetiminfo((int)id, (String[])objName, (int[])grInfo, (int[])idims);
            grInfo[1] = grInfo[1] & 0xFFFFBFFF;
            int n = grInfo[3];
            if (this.attributeList == null && n > 0) {
                this.attributeList = new Vector(n, 5);
            }
            boolean b = false;
            String[] attrName = new String[1];
            int[] attrInfo = new int[]{0, 0};
            for (int i = 0; i < n; ++i) {
                attrName[0] = "";
                try {
                    b = HDFLibrary.GRattrinfo((int)id, (int)i, (String[])attrName, (int[])attrInfo);
                    attrInfo[0] = attrInfo[0] & 0xFFFFBFFF;
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                long[] attrDims = new long[]{attrInfo[1]};
                Attribute attr = new Attribute(attrName[0], (Datatype)new H4Datatype(attrInfo[0]), attrDims);
                this.attributeList.add(attr);
                String[] buf = H4Datatype.allocateArray(attrInfo[0], attrInfo[1]);
                try {
                    HDFLibrary.GRgetattr((int)id, (int)i, (Object)buf);
                }
                catch (HDFException ex) {
                    buf = null;
                }
                if (buf == null) continue;
                if (attrInfo[0] == 4 || attrInfo[0] == 3) {
                    buf = Dataset.byteToString((byte[])((byte[])buf), (int)attrInfo[1]);
                }
                attr.setValue((Object)buf);
            }
        }
        finally {
            this.close(id);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute((HObject)this, (Attribute)info, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(info);
    }

    public void removeMetadata(Object info) throws HDFException {
    }

    public int open() {
        int id = -1;
        try {
            int index = HDFLibrary.GRreftoindex((int)this.grid, (short)((short)this.oid[1]));
            id = HDFLibrary.GRselect((int)this.grid, (int)index);
        }
        catch (HDFException ex) {
            id = -1;
        }
        return id;
    }

    public void close(int grid) {
        try {
            HDFLibrary.GRendaccess((int)grid);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int id = this.open();
        String[] objName = new String[]{""};
        int[] grInfo = new int[4];
        int[] idims = new int[2];
        try {
            HDFLibrary.GRgetiminfo((int)id, (String[])objName, (int[])grInfo, (int[])idims);
            grInfo[1] = grInfo[1] & 0xFFFFBFFF;
            this.datatypeID = grInfo[1];
            try {
                HDFCompInfo compInfo = new HDFCompInfo();
                boolean status = HDFLibrary.GRgetcompress((int)id, (HDFCompInfo)compInfo);
                if (compInfo.ctype == 4) {
                    this.compression = "GZIP";
                } else if (compInfo.ctype == 5) {
                    this.compression = "SZIP";
                } else if (compInfo.ctype == 7) {
                    this.compression = "JPEG";
                } else if (compInfo.ctype == 3) {
                    this.compression = "SKPHUFF";
                } else if (compInfo.ctype == 1) {
                    this.compression = "RLE";
                } else if (compInfo.ctype == 2) {
                    this.compression = "NBIT";
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                HDFChunkInfo chunkInfo = new HDFChunkInfo();
                int[] cflag = new int[]{0};
                boolean status = HDFLibrary.GRgetchunkinfo((int)id, (HDFChunkInfo)chunkInfo, (int[])cflag);
                if (cflag[0] == 0) {
                    this.chunkSize = null;
                } else {
                    this.chunkSize = new long[this.rank];
                    for (int i = 0; i < this.rank; ++i) {
                        this.chunkSize[i] = chunkInfo.chunk_lengths[i];
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        catch (HDFException ex) {
        }
        finally {
            this.close(id);
        }
        this.isUnsigned = H4Datatype.isUnsigned(this.datatypeID);
        if (idims == null) {
            return;
        }
        this.ncomp = grInfo[0];
        this.isTrueColor = this.ncomp >= 3;
        this.interlace = grInfo[2];
        this.rank = 2;
        this.selectedIndex[0] = 1;
        this.selectedIndex[1] = 0;
        this.dims = new long[this.rank];
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = idims[i];
            this.dims[i] = idims[i];
        }
    }

    public byte[][] getPalette() {
        if (this.palette != null) {
            return this.palette;
        }
        int id = this.open();
        if (id < 0) {
            return null;
        }
        int lutid = -1;
        int[] lutInfo = new int[4];
        try {
            lutid = HDFLibrary.GRgetlutid((int)id, (int)0);
            HDFLibrary.GRgetlutinfo((int)lutid, (int[])lutInfo);
        }
        catch (HDFException ex) {
            this.close(id);
            return null;
        }
        if (lutInfo[0] != 3 || lutInfo[2] < 0 | lutInfo[3] != 256) {
            this.close(id);
            return null;
        }
        boolean b = false;
        byte[] pal = new byte[768];
        try {
            HDFLibrary.GRreqlutil((int)id, (int)lutInfo[2]);
            b = HDFLibrary.GRreadlut((int)lutid, (byte[])pal);
        }
        catch (HDFException ex) {
            b = false;
        }
        if (!b) {
            this.close(id);
            return null;
        }
        this.palette = new byte[3][256];
        if (lutInfo[2] == 0) {
            for (int i = 0; i < 256; ++i) {
                this.palette[0][i] = pal[i * 3];
                this.palette[1][i] = pal[i * 3 + 1];
                this.palette[2][i] = pal[i * 3 + 2];
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                this.palette[0][i] = pal[i];
                this.palette[1][i] = pal[256 + i];
                this.palette[2][i] = pal[512 + i];
            }
        }
        this.close(id);
        return this.palette;
    }

    public int getComponentCount() {
        return this.ncomp;
    }

    public static H4GRImage create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, int ncomp, int interlace, Object data) throws Exception {
        H4GRImage dataset = null;
        if (name == null || pgroup == null || dims == null || gzip > 0 && chunks == null) {
            return null;
        }
        H4File file = (H4File)pgroup.getFileFormat();
        if (file == null) {
            return null;
        }
        String path = "/";
        if (!pgroup.isRoot()) {
            path = pgroup.getPath() + pgroup.getName() + "/";
        }
        interlace = interlace == 2 ? 2 : 0;
        int rank = 2;
        int[] idims = new int[rank];
        int[] imaxdims = new int[rank];
        int[] start = new int[rank];
        for (int i = 0; i < rank; ++i) {
            idims[i] = (int)dims[i];
            imaxdims[i] = maxdims != null ? (int)maxdims[i] : idims[i];
            start[i] = 0;
        }
        int[] ichunks = null;
        if (chunks != null) {
            ichunks = new int[rank];
            for (int i = 0; i < rank; ++i) {
                ichunks[i] = (int)chunks[i];
            }
        }
        int gid = file.getGRAccessID();
        int tid = type.toNative();
        int grid = HDFLibrary.GRcreate((int)gid, (String)name, (int)ncomp, (int)tid, (int)interlace, (int[])idims);
        if (grid < 0) {
            throw new HDFException("Unable to create the new dataset.");
        }
        if (grid > 0 && data != null) {
            HDFLibrary.GRwriteimage((int)grid, (int[])start, null, (int[])idims, (Object)data);
        }
        if (chunks != null) {
            HDFChunkInfo chunkInfo = new HDFChunkInfo(ichunks);
            HDFLibrary.GRsetchunk((int)grid, (HDFChunkInfo)chunkInfo, (int)1);
        }
        if (gzip > 0) {
            int compType = 4;
            HDFDeflateCompInfo compInfo = new HDFDeflateCompInfo();
            compInfo.level = gzip;
            HDFLibrary.GRsetcompress((int)grid, (int)compType, (HDFCompInfo)compInfo);
        }
        short ref = HDFLibrary.GRidtoref((int)grid);
        if (!pgroup.isRoot()) {
            int vgid = pgroup.open();
            if (vgid < 0) {
                if (grid > 0) {
                    HDFLibrary.GRendaccess((int)grid);
                }
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vaddtagref((int)vgid, (int)302, (int)ref);
            pgroup.close(vgid);
        }
        try {
            if (grid > 0) {
                HDFLibrary.GRendaccess((int)grid);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        long[] oid = new long[]{720L, ref};
        dataset = new H4GRImage(file, name, path, oid);
        if (dataset != null) {
            pgroup.addToMemberList((HObject)dataset);
        }
        return dataset;
    }

    private void copyAttribute(int srcdid, int dstdid, int numberOfAttributes) {
        if (numberOfAttributes <= 0) {
            return;
        }
        try {
            boolean b = false;
            String[] attrName = new String[1];
            int[] attrInfo = new int[]{0, 0};
            for (int i = 0; i < numberOfAttributes; ++i) {
                attrName[0] = "";
                try {
                    b = HDFLibrary.GRattrinfo((int)srcdid, (int)i, (String[])attrName, (int[])attrInfo);
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                byte[] attrBuff = new byte[attrInfo[1] * HDFLibrary.DFKNTsize((int)attrInfo[0])];
                try {
                    HDFLibrary.GRgetattr((int)srcdid, (int)i, (byte[])attrBuff);
                }
                catch (Exception ex) {
                    attrBuff = null;
                }
                if (attrBuff == null) continue;
                HDFLibrary.GRsetattr((int)dstdid, (String)attrName[0], (int)attrInfo[0], (int)attrInfo[1], (byte[])attrBuff);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

