/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.sync;

import jams.JAMS;
import jams.server.client.Controller;
import jams.server.client.sync.DirectorySync;
import jams.server.client.sync.FileSync;
import jams.server.entities.Workspace;
import jams.tools.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SyncTable
extends JTable {
    Component[] tableSyncModeCells;
    Font defaultFont = new Font("Times New Roman", 0, 10);
    File localWorkspace = null;
    Workspace serverWorkspace = null;
    Controller ctrl = null;
    final int COLUMN_COUNT = 5;
    final int[] COLUMN_SIZE = new int[]{25, 365, 75, 90, 50};
    final String[] COLUMN_NAMES = new String[]{"", JAMS.i18n((String)"Path"), JAMS.i18n((String)"Extension"), JAMS.i18n((String)"Operation"), JAMS.i18n((String)"SIZE")};
    final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, String.class, FileSync.SyncMode.class, Long.class};
    final int SYNCMODE_COLUMN = 3;

    public SyncTable(Controller ctrl, Font defaultFont) {
        super(10, 5);
        this.ctrl = ctrl;
        if (defaultFont != null) {
            this.defaultFont = defaultFont;
        }
    }

    public void setLocalWorkspace(File localWorkspace) {
        this.localWorkspace = localWorkspace;
        this.initModel();
    }

    public File getLocalWorkspace() {
        return this.localWorkspace;
    }

    public void setServerWorkspace(Workspace serverWorkspace) {
        this.serverWorkspace = serverWorkspace;
        this.initModel();
    }

    public Workspace getServerWorkspace() {
        return this.serverWorkspace;
    }

    private void initModel() {
        SyncTableModel syncTableModel = new SyncTableModel(this.ctrl, this.localWorkspace, this.serverWorkspace);
        this.setModel(syncTableModel);
        SyncWorkspaceTableRenderer renderer = new SyncWorkspaceTableRenderer(syncTableModel.getSyncList());
        this.setDefaultRenderer(String.class, renderer);
        this.setDefaultRenderer(Long.class, renderer);
        this.getColumnModel().getColumn(3).setCellRenderer(renderer);
        this.getColumnModel().getColumn(3).setCellEditor(new SyncModeEditor());
        this.setShowHorizontalLines(false);
        this.setAutoResizeMode(0);
        for (int i = 0; i < 5; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(this.COLUMN_SIZE[i]);
        }
    }

    @Override
    public SyncTableModel getModel() {
        if (super.getModel() instanceof SyncTableModel) {
            return (SyncTableModel)super.getModel();
        }
        return null;
    }

    private void generateTableCells(List<FileSync> syncList) {
        this.tableSyncModeCells = new Component[syncList.size()];
        for (int i = 0; i < syncList.size(); ++i) {
            FileSync fs = syncList.get(i);
            if (fs.getSyncOptions().length == 1) {
                this.tableSyncModeCells[i] = new JLabel(fs.getSyncOptions()[0].toString(), 0);
                this.tableSyncModeCells[i].setBackground(Color.WHITE);
                this.tableSyncModeCells[i].setForeground(Color.BLACK);
                if (!syncList.get(i).isExisting()) {
                    this.tableSyncModeCells[i].setBackground(Color.green);
                } else if (syncList.get(i).isModified()) {
                    this.tableSyncModeCells[i].setBackground(Color.red);
                }
                if (syncList.get(i) instanceof DirectorySync) {
                    this.tableSyncModeCells[i].setBackground(Color.darkGray);
                    this.tableSyncModeCells[i].setForeground(Color.white);
                }
                ((JLabel)this.tableSyncModeCells[i]).setOpaque(true);
            } else {
                JComboBox<FileSync.SyncMode> box = new JComboBox<FileSync.SyncMode>(fs.getSyncOptions());
                box.putClientProperty("row", new Integer(i));
                box.setSelectedItem((Object)fs.getSyncMode());
                box.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JComboBox src = (JComboBox)e.getSource();
                        int row = (Integer)src.getClientProperty("row");
                        SyncTable.this.getModel().setValueAt(src.getSelectedItem(), row, 3);
                    }
                });
                this.tableSyncModeCells[i] = box;
                this.tableSyncModeCells[i].setBackground(Color.WHITE);
                this.tableSyncModeCells[i].setForeground(Color.BLACK);
            }
            this.tableSyncModeCells[i].setFont(this.defaultFont);
        }
    }

    private class SyncWorkspaceTableRenderer
    extends JLabel
    implements TableCellRenderer {
        List<FileSync> syncList = null;

        public SyncWorkspaceTableRenderer(List<FileSync> syncList) {
            this.syncList = syncList;
            SyncTable.this.generateTableCells(syncList);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 3) {
                return SyncTable.this.tableSyncModeCells[row];
            }
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            if (value instanceof Long) {
                this.setText(StringTools.humanReadableByteCount((long)((Long)value), (boolean)false));
                this.setHorizontalAlignment(4);
            } else if (value instanceof Integer) {
                this.setText(StringTools.humanReadableByteCount((long)((Integer)value).intValue(), (boolean)false));
                this.setHorizontalAlignment(4);
            } else {
                this.setText(value.toString());
                this.setHorizontalAlignment(2);
            }
            FileSync fs = this.syncList.get(row);
            if (!fs.isExisting()) {
                this.setBackground(Color.green);
            } else if (fs.isModified()) {
                this.setBackground(Color.red);
            }
            if (fs instanceof DirectorySync) {
                this.setBackground(Color.darkGray);
                this.setForeground(Color.white);
            }
            this.setFont(SyncTable.this.defaultFont);
            return this;
        }
    }

    private class SyncModeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JComboBox currentBox = null;

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public Object getCellEditorValue() {
            if (this.currentBox != null) {
                return this.currentBox.getSelectedItem();
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (SyncTable.this.tableSyncModeCells[row] instanceof JComboBox) {
                this.currentBox = (JComboBox)SyncTable.this.tableSyncModeCells[row];
                return this.currentBox;
            }
            this.currentBox = null;
            return null;
        }
    }

    public class SyncTableModel
    extends AbstractTableModel {
        ArrayList<FileSync> syncList = null;

        public SyncTableModel(Controller ctrl, File localWsDirectory, Workspace remoteWs) {
            this.syncList = ctrl == null || localWsDirectory == null || remoteWs == null ? new ArrayList() : ctrl.workspaces().getSynchronizationList(localWsDirectory, remoteWs).getList(null);
        }

        public List<FileSync> getSyncList() {
            return this.syncList;
        }

        public FileSync getRoot() {
            if (this.syncList == null || this.syncList.isEmpty()) {
                return null;
            }
            return this.syncList.get(0).getRoot();
        }

        @Override
        public int getRowCount() {
            return this.syncList.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return SyncTable.this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return SyncTable.this.COLUMN_CLASSES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 3 && SyncTable.this.tableSyncModeCells[rowIndex] instanceof JComboBox;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FileSync fs = this.syncList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return fs.isDoSync();
                }
                case 1: {
                    if (fs.getLocalFile() != null) {
                        return fs.getLocalFile().getPath();
                    }
                    return null;
                }
                case 2: {
                    String name = this.syncList.get(rowIndex).getLocalFile().getName();
                    int lastIndex = name.lastIndexOf(".");
                    if (lastIndex == -1) {
                        return "";
                    }
                    return name.substring(lastIndex, name.length());
                }
                case 3: {
                    return this.syncList.get(rowIndex).getSyncMode();
                }
                case 4: {
                    if (fs.getServerFile() != null) {
                        return fs.getServerFile().getFile().getFileSize();
                    }
                    return 0;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.syncList.get(rowIndex).setDoSync((Boolean)aValue, true);
                this.fireTableDataChanged();
            }
            if (columnIndex == 3) {
                this.syncList.get(rowIndex).setSyncMode((FileSync.SyncMode)((Object)aValue));
                SyncTable.this.generateTableCells(this.syncList);
                this.fireTableDataChanged();
            }
        }
    }
}

