/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui.tree;

import jams.server.client.gui.tree.JAMSServerTree;
import jams.server.client.gui.tree.JAMSServerTreeNodes;
import jams.server.entities.User;
import jams.server.entities.Workspace;
import jams.server.entities.WorkspaceFileAssociation;
import jams.server.entities.Workspaces;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WorkspaceTree
extends JAMSServerTree {
    private DefaultMutableTreeNode createWorkspaceNode(Workspace ws) {
        JAMSServerTreeNodes.SortedMutableTreeNode top = JAMSServerTreeNodes.getNode(ws);
        for (WorkspaceFileAssociation wfa : ws.getFiles()) {
            this.attachWFAtoTree(wfa, top);
        }
        return top;
    }

    @Override
    public JAMSServerTreeNodes.SortedMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object o = path.getLastPathComponent();
        if (JAMSServerTreeNodes.SortedMutableTreeNode.class.isAssignableFrom(o.getClass())) {
            return (JAMSServerTreeNodes.SortedMutableTreeNode)o;
        }
        return null;
    }

    public Workspace getSelectedWorkspace() {
        if (!this.isShowing()) {
            return null;
        }
        JAMSServerTreeNodes.SortedMutableTreeNode o = this.getSelectedNode();
        if (o != null && o instanceof JAMSServerTreeNodes.WorkspaceNode) {
            return ((JAMSServerTreeNodes.WorkspaceNode)o).getWorkspace();
        }
        return null;
    }

    public JAMSServerTreeNodes.WorkspaceNode findNode(JAMSServerTreeNodes.SortedMutableTreeNode root, Workspace object) {
        Object o = root.getUserObject();
        if (o.equals(object)) {
            return (JAMSServerTreeNodes.WorkspaceNode)root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            JAMSServerTreeNodes.SortedMutableTreeNode child = (JAMSServerTreeNodes.SortedMutableTreeNode)root.getChildAt(i);
            JAMSServerTreeNodes.WorkspaceNode result = this.findNode(child, object);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void generateModel(User user, Workspaces workspaces) {
        JAMSServerTreeNodes.SortedMutableTreeNode root = JAMSServerTreeNodes.getNode(user);
        for (Workspace ws : workspaces.getWorkspaces()) {
            if (ws.isReadOnly()) continue;
            root.add(this.createWorkspaceNode(ws));
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
    }
}

