/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import jams.ErrorCatchingRunnable;
import jams.JAMS;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.server.client.Controller;
import jams.server.client.WorkspaceController;
import jams.server.client.gui.JAMSCloudGraphicalController;
import jams.server.client.sync.DirectorySync;
import jams.server.client.sync.FileSync;
import jams.server.client.sync.SyncTable;
import jams.server.entities.Job;
import jams.server.entities.Jobs;
import jams.tools.LogTools;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;

public class SynchronizeDlg1
extends JDialog {
    static Logger log = Logger.getLogger(SynchronizeDlg1.class.getName());
    protected Font defaultFont = new Font("Arial", 0, 10);
    protected SyncTable syncTable = null;
    protected JButton okButton = new JButton(JAMS.i18n((String)"Synchronize"));
    protected JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
    protected JCheckBox showAllJobs = new JCheckBox("Show all jobs");
    protected Workspace localWorkspace = null;
    protected jams.server.entities.Workspace remoteWs = null;
    protected Component[] tableSyncModeCells;
    protected JLabel checkLabel = new JLabel("<html>" + JAMS.i18n((String)"check") + "</html>");
    protected JComboBox<Job> jobChooser = new JComboBox();
    protected JButton syncNewOnly = new JButton(JAMS.i18n((String)"only_new"));
    protected JButton syncAll = new JButton(JAMS.i18n((String)"all"));
    protected JButton syncNothing = new JButton(JAMS.i18n((String)"none"));
    protected JButton invertSelection = new JButton(JAMS.i18n((String)"invert_selection"));
    protected ObserverWorkerDlg syncWorkspaceWorker = new ObserverWorkerDlg(new WorkerDlg((Window)this, JAMS.i18n((String)"Synchronizing_Workspace")));
    protected LogTools.ObservableLogHandler observable = new LogTools.ObservableLogHandler(new Logger[]{Logger.getLogger(Controller.class.getName())});
    protected Jobs jobs = null;
    protected Job selectedJob = null;
    protected int localWorkspaceID = -1;
    protected JAMSCloudGraphicalController connector = null;
    protected SystemProperties p;

    public SynchronizeDlg1(Window w, Workspace localWorkspace, SystemProperties p) throws IOException {
        super(w, "Synchronize Workspace");
        this.setDefaultCloseOperation(2);
        this.p = p;
        this.connector = JAMSCloudGraphicalController.createInstance(w, p);
        this.connector.connect();
        this.localWorkspace = localWorkspace;
        GUIHelper.centerOnParent((Window)this, (boolean)this.rootPaneCheckingEnabled);
        this.init();
        GUIHelper.centerOnParent((Window)this, (boolean)this.rootPaneCheckingEnabled);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            try {
                if (!this.connector.isConnected() && this.connector.reconnect() == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Unable to connect", ioe);
                return;
            }
        }
        super.setVisible(flag);
    }

    private void setupSelectionButton(JButton bn) {
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JButton bn = (JButton)e.getSource();
                String text = bn.getClientProperty("text").toString();
                bn.setText("<html><u>" + text + "</u></html>");
                bn.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JButton bn = (JButton)e.getSource();
                String text = bn.getClientProperty("text").toString();
                bn.setText("<html>" + text + "</html>");
            }
        };
        bn.setBorder(null);
        bn.setOpaque(false);
        bn.setContentAreaFilled(false);
        bn.setForeground(Color.blue);
        bn.setFont(this.defaultFont);
        bn.addMouseListener(ma);
        bn.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String text = bn.getText();
        bn.putClientProperty("text", text);
        bn.setText("<html>" + text + "</html>");
        bn.setPreferredSize(new Dimension(bn.getPreferredSize().width + 20, bn.getPreferredSize().height));
    }

    private void init() throws IOException {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add(this.jobChooser, "Center");
        northPanel.add((Component)this.showAllJobs, "East");
        this.localWorkspaceID = this.localWorkspace.getID();
        if (this.localWorkspaceID == -1) {
            this.showAllJobs.setSelected(true);
        }
        this.jobs = this.connector.getClient().jobs().find();
        for (Job job : this.jobs.getJobs()) {
            jams.server.entities.Workspace ancestor = job.getWorkspace().getAncestor();
            if (ancestor == null || !ancestor.getName().equals(this.localWorkspace.getTitle())) continue;
            this.jobChooser.addItem(job);
        }
        this.jobChooser.setBorder(BorderFactory.createTitledBorder("Available Jobs"));
        this.jobChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynchronizeDlg1.this.jobChooser.getSelectedItem() != null) {
                    SynchronizeDlg1.this.selectedJob = (Job)SynchronizeDlg1.this.jobChooser.getSelectedItem();
                    WorkerDlg worker = new WorkerDlg((Window)SynchronizeDlg1.this, "Loading jobs .. ");
                    worker.setTask(new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            try {
                                SynchronizeDlg1.this.syncTable.setServerWorkspace(SynchronizeDlg1.this.selectedJob.getWorkspace());
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            return null;
                        }
                    });
                    worker.execute();
                }
            }
        });
        this.showAllJobs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizeDlg1.this.jobChooser.removeAllItems();
                for (Job job : SynchronizeDlg1.this.jobs.getJobs()) {
                    jams.server.entities.Workspace ancestor = job.getWorkspace().getAncestor();
                    if (!SynchronizeDlg1.this.showAllJobs.isSelected() && (ancestor == null || ancestor.getId() != SynchronizeDlg1.this.localWorkspaceID)) continue;
                    SynchronizeDlg1.this.jobChooser.addItem(job);
                }
            }
        });
        this.syncTable = new SyncTable(this.connector.getClient(), this.defaultFont);
        this.syncTable.setLocalWorkspace(this.localWorkspace.getDirectory());
        if (this.jobChooser.getItemCount() > 0) {
            this.jobChooser.setSelectedItem(this.jobChooser.getItemAt(0));
        }
        JScrollPane tableScroll = new JScrollPane(this.syncTable);
        mainPanel.add((Component)tableScroll, "Center");
        this.setupSelectionButton(this.syncNewOnly);
        this.setupSelectionButton(this.syncAll);
        this.setupSelectionButton(this.syncNothing);
        this.setupSelectionButton(this.invertSelection);
        this.checkLabel.setFont(this.defaultFont);
        JPanel southPanel = new JPanel();
        GridBagLayout buttonLayout = new GridBagLayout();
        southPanel.setLayout(buttonLayout);
        JPanel checkPanel = new JPanel();
        checkPanel.add(this.checkLabel);
        checkPanel.add(this.syncAll);
        checkPanel.add(this.syncNothing);
        checkPanel.add(this.syncNewOnly);
        checkPanel.add(this.invertSelection);
        GUIHelper.addGBComponent((Container)southPanel, (GridBagLayout)buttonLayout, (Component)checkPanel, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0, (int)2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        GUIHelper.addGBComponent((Container)southPanel, (GridBagLayout)buttonLayout, (Component)buttonPanel, (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        mainPanel.add((Component)northPanel, "North");
        mainPanel.add((Component)southPanel, "South");
        this.add(mainPanel);
        this.initActions();
        this.setSize(new Dimension(640, 480));
        this.invalidate();
        this.pack();
    }

    private void initActions() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizeDlg1.this.synchronize();
                SynchronizeDlg1.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizeDlg1.this.setVisible(false);
            }
        });
        this.syncNewOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg1.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return !fs.isExisting();
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return !ds.isExisting();
                    }
                });
                SynchronizeDlg1.this.syncTable.getModel().fireTableDataChanged();
            }
        });
        this.syncAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg1.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return true;
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return true;
                    }
                });
                SynchronizeDlg1.this.syncTable.getModel().fireTableDataChanged();
            }
        });
        this.syncNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg1.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return false;
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return false;
                    }
                });
                SynchronizeDlg1.this.syncTable.getModel().fireTableDataChanged();
            }
        });
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg1.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return !fs.isDoSync();
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return !ds.isDoSync();
                    }
                });
                SynchronizeDlg1.this.syncTable.getModel().fireTableDataChanged();
            }
        });
    }

    private void synchronize() {
        this.syncWorkspaceWorker.getWorkerDlg().setInderminate(true);
        this.syncWorkspaceWorker.getWorkerDlg().setTask((Runnable)new ErrorCatchingRunnable(){

            public void safeRun() {
                FileSync root = SynchronizeDlg1.this.syncTable.getModel().getRoot();
                WorkspaceController wc = SynchronizeDlg1.this.connector.getClient().workspaces();
                SynchronizeDlg1.this.observable.addObserver((Observer)SynchronizeDlg1.this.syncWorkspaceWorker);
                if (root instanceof DirectorySync) {
                    wc.synchronizeWorkspace((DirectorySync)root);
                }
                SynchronizeDlg1.this.observable.deleteObserver((Observer)SynchronizeDlg1.this.syncWorkspaceWorker);
            }
        });
        this.syncWorkspaceWorker.getWorkerDlg().execute();
    }

    public static void main(String[] args) throws IOException {
        JAMSProperties properties = JAMSProperties.createProperties();
        properties.load("d:/jamsapplication/nsk.jap");
        JAMSWorkspace wslocal = new JAMSWorkspace(new File("D:\\temp\\test\\j2k_gehlberg"), (JAMSRuntime)new StandardRuntime((SystemProperties)properties));
        wslocal.loadConfig();
        SynchronizeDlg1 dlg = new SynchronizeDlg1((Window)null, (Workspace)wslocal, (SystemProperties)properties);
        dlg.setSize(new Dimension(640, 480));
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }
}

