/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import jams.ErrorCatchingRunnable;
import jams.JAMS;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.server.client.Controller;
import jams.server.client.WorkspaceController;
import jams.server.client.gui.JAMSCloudGraphicalController;
import jams.server.client.sync.DirectorySync;
import jams.server.client.sync.FileSync;
import jams.server.client.sync.SyncTable;
import jams.server.entities.Job;
import jams.server.entities.Jobs;
import jams.tools.LogTools;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class SynchronizeDlg
extends JDialog {
    static Logger log = Logger.getLogger(SynchronizeDlg.class.getName());
    protected Font defaultFont = new Font("Arial", 0, 10);
    protected SyncTable syncTable = null;
    protected JButton okButton = new JButton(JAMS.i18n((String)"Synchronize"));
    protected JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
    protected JCheckBox showAllJobs = new JCheckBox("Show all jobs");
    protected Workspace localWorkspace = null;
    protected jams.server.entities.Workspace remoteWs = null;
    protected Component[] tableSyncModeCells;
    protected JLabel checkLabel = new JLabel("<html>" + JAMS.i18n((String)"check") + "</html>");
    protected JComboBox<Job> jobChooser = new JComboBox();
    protected JButton syncNewOnly = new JButton(JAMS.i18n((String)"only_new"));
    protected JButton syncAll = new JButton(JAMS.i18n((String)"all"));
    protected JButton syncNothing = new JButton(JAMS.i18n((String)"none"));
    protected JButton invertSelection = new JButton(JAMS.i18n((String)"invert_selection"));
    protected ObserverWorkerDlg syncWorkspaceWorker = new ObserverWorkerDlg(new WorkerDlg((Window)this, JAMS.i18n((String)"Synchronizing_Workspace")));
    protected LogTools.ObservableLogHandler observable = new LogTools.ObservableLogHandler(new Logger[]{Logger.getLogger(Controller.class.getName())});
    protected Jobs jobs = null;
    protected Job selectedJob = null;
    protected int localWorkspaceID = -1;
    protected JAMSCloudGraphicalController connector = null;
    protected SystemProperties p;

    public SynchronizeDlg(Window w, Workspace localWorkspace, SystemProperties p) throws IOException {
        super(w, "Synchronize Workspace");
        this.setDefaultCloseOperation(2);
        this.p = p;
        this.connector = JAMSCloudGraphicalController.createInstance(w, p);
        this.connector.connect();
        this.localWorkspace = localWorkspace;
        GUIHelper.centerOnParent((Window)this, (boolean)this.rootPaneCheckingEnabled);
        this.init();
        GUIHelper.centerOnParent((Window)this, (boolean)this.rootPaneCheckingEnabled);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            try {
                if (!this.connector.isConnected() && this.connector.reconnect() == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Unable to connect", ioe);
                return;
            }
        }
        super.setVisible(flag);
    }

    private void setupSelectionButton(JButton bn) {
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JButton bn = (JButton)e.getSource();
                String text = bn.getClientProperty("text").toString();
                bn.setText("<html><u>" + text + "</u></html>");
                bn.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JButton bn = (JButton)e.getSource();
                String text = bn.getClientProperty("text").toString();
                bn.setText("<html>" + text + "</html>");
            }
        };
        bn.setBorder(null);
        bn.setOpaque(false);
        bn.setContentAreaFilled(false);
        bn.setForeground(Color.blue);
        bn.setFont(this.defaultFont);
        bn.addMouseListener(ma);
        bn.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        bn.putClientProperty("text", bn.getText());
        bn.setText("<html>" + bn.getClientProperty("text").toString() + "</html>");
    }

    private void init() throws IOException {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add(this.jobChooser, "Center");
        northPanel.add((Component)this.showAllJobs, "East");
        this.localWorkspaceID = this.localWorkspace.getID();
        if (this.localWorkspaceID == -1) {
            this.showAllJobs.setSelected(true);
        }
        this.jobs = this.connector.getClient().jobs().find();
        for (Job job : this.jobs.getJobs()) {
            jams.server.entities.Workspace ancestor = job.getWorkspace().getAncestor();
            if (ancestor == null || !ancestor.getName().equals(this.localWorkspace.getTitle())) continue;
            this.jobChooser.addItem(job);
        }
        this.jobChooser.setBorder(BorderFactory.createTitledBorder("Available Jobs"));
        this.jobChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SynchronizeDlg.this.jobChooser.getSelectedItem() != null) {
                    SynchronizeDlg.this.selectedJob = (Job)SynchronizeDlg.this.jobChooser.getSelectedItem();
                    WorkerDlg worker = new WorkerDlg((Window)SynchronizeDlg.this, "Loading jobs .. ");
                    worker.setTask(new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            try {
                                SynchronizeDlg.this.syncTable.setServerWorkspace(SynchronizeDlg.this.selectedJob.getWorkspace());
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            return null;
                        }
                    });
                    worker.execute();
                }
            }
        });
        this.showAllJobs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizeDlg.this.jobChooser.removeAllItems();
                for (Job job : SynchronizeDlg.this.jobs.getJobs()) {
                    jams.server.entities.Workspace ancestor = job.getWorkspace().getAncestor();
                    if (!SynchronizeDlg.this.showAllJobs.isSelected() && (ancestor == null || ancestor.getId() != SynchronizeDlg.this.localWorkspaceID)) continue;
                    SynchronizeDlg.this.jobChooser.addItem(job);
                }
            }
        });
        this.syncTable = new SyncTable(this.connector.getClient(), this.defaultFont);
        this.syncTable.setLocalWorkspace(this.localWorkspace.getDirectory());
        if (this.jobChooser.getItemCount() > 0) {
            this.jobChooser.setSelectedItem(this.jobChooser.getItemAt(this.jobChooser.getItemCount() - 1));
        }
        JScrollPane tableScroll = new JScrollPane(this.syncTable);
        mainPanel.add((Component)tableScroll, "Center");
        this.setupSelectionButton(this.syncNewOnly);
        this.setupSelectionButton(this.syncAll);
        this.setupSelectionButton(this.syncNothing);
        this.setupSelectionButton(this.invertSelection);
        this.checkLabel.setFont(this.defaultFont);
        JPanel buttonPanel = new JPanel();
        GroupLayout layout = new GroupLayout(buttonPanel);
        buttonPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkLabel, -2, -2, -2).addComponent(this.syncAll, -2, -2, -2).addComponent(this.syncNothing, -2, -2, -2).addComponent(this.syncNewOnly, -2, -2, -2).addComponent(this.invertSelection, -2, -2, -2).addGap(0, 1000, 1000)).addGap(25, 25, 25).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.checkLabel).addComponent(this.syncAll).addComponent(this.syncNothing).addComponent(this.syncNewOnly).addComponent(this.invertSelection)).addGroup(layout.createParallelGroup().addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        mainPanel.add((Component)northPanel, "North");
        mainPanel.add((Component)buttonPanel, "South");
        this.add(mainPanel);
        this.initActions();
        this.setSize(new Dimension(640, 480));
        this.invalidate();
        this.pack();
    }

    private void initActions() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizeDlg.this.synchronize();
                SynchronizeDlg.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizeDlg.this.setVisible(false);
            }
        });
        this.syncNewOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return !fs.isExisting();
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return !ds.isExisting();
                    }
                });
                SynchronizeDlg.this.syncTable.getModel().fireTableDataChanged();
            }
        });
        this.syncAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return true;
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return true;
                    }
                });
                SynchronizeDlg.this.syncTable.getModel().fireTableDataChanged();
            }
        });
        this.syncNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return false;
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return false;
                    }
                });
                SynchronizeDlg.this.syncTable.getModel().fireTableDataChanged();
            }
        });
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSync fs = SynchronizeDlg.this.syncTable.getModel().getRoot();
                fs.applySyncFilter(new FileSync.SyncFilter(){

                    @Override
                    public boolean isFiltered(FileSync fs) {
                        return !fs.isDoSync();
                    }

                    @Override
                    public boolean isFiltered(DirectorySync ds) {
                        return !ds.isDoSync();
                    }
                });
                SynchronizeDlg.this.syncTable.getModel().fireTableDataChanged();
            }
        });
    }

    private void synchronize() {
        this.syncWorkspaceWorker.getWorkerDlg().setInderminate(true);
        this.syncWorkspaceWorker.getWorkerDlg().setTask((Runnable)new ErrorCatchingRunnable(){

            public void safeRun() {
                FileSync root = SynchronizeDlg.this.syncTable.getModel().getRoot();
                WorkspaceController wc = SynchronizeDlg.this.connector.getClient().workspaces();
                SynchronizeDlg.this.observable.addObserver((Observer)SynchronizeDlg.this.syncWorkspaceWorker);
                if (root instanceof DirectorySync) {
                    wc.synchronizeWorkspace((DirectorySync)root);
                }
                SynchronizeDlg.this.observable.deleteObserver((Observer)SynchronizeDlg.this.syncWorkspaceWorker);
            }
        });
        this.syncWorkspaceWorker.getWorkerDlg().execute();
    }

    public static void main(String[] args) throws IOException {
        JAMSProperties properties = JAMSProperties.createProperties();
        properties.load("d:/jamsapplication/nsk.jap");
        JAMSWorkspace wslocal = new JAMSWorkspace(new File("D:\\jamsmodeldata\\J2000_Kaidu_ERA_interim_PM"), (JAMSRuntime)new StandardRuntime((SystemProperties)properties));
        wslocal.loadConfig();
        SynchronizeDlg dlg = new SynchronizeDlg((Window)null, (Workspace)wslocal, (SystemProperties)properties);
        dlg.setSize(new Dimension(640, 480));
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }
}

