/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import jams.JAMS;
import jams.server.entities.File;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class FilePropertiesDlg
extends JDialog {
    JLabel fileIconLabel = new JLabel("");
    JLabel fileNameLabel = new JLabel("                 ");
    JLabel fileTypeLabel = new JLabel("                 ");
    JLabel fileLocationLabel = new JLabel("                  ");
    JLabel fileSizeLabel = new JLabel("                 ");
    JLabel fileCreatedLabel = new JLabel("                ");
    JLabel typeLabel = new JLabel(JAMS.i18n((String)"Type:"), 2);
    JLabel locationLabel = new JLabel(JAMS.i18n((String)"Location:"), 2);
    JLabel sizeLabel = new JLabel(JAMS.i18n((String)"Size:"), 2);
    JLabel creationLabel = new JLabel(JAMS.i18n((String)"Created:"), 2);
    JLabel roleLabel = new JLabel(JAMS.i18n((String)"Role:"), 2);
    final String INPUT_FILE = JAMS.i18n((String)"input_file");
    final String OUTPUT_FILE = JAMS.i18n((String)"output_file");
    final String MODEL_FILE = JAMS.i18n((String)"model_file");
    final String CONF_FILE = JAMS.i18n((String)"configuration_file");
    final String OTHER_FILE = JAMS.i18n((String)"other/unknown");
    final String COMP_LIB = JAMS.i18n((String)"component_library");
    final String RUNTIME_LIB = JAMS.i18n((String)"runtime_library");
    final String EXEC_FILE = JAMS.i18n((String)"executable_file");
    final String JAP_FILE = JAMS.i18n((String)"JAP_file");
    JComboBox fileRoleCombo = new JComboBox<String>(new String[]{this.INPUT_FILE, this.OUTPUT_FILE, this.MODEL_FILE, this.CONF_FILE, this.OTHER_FILE, this.COMP_LIB, this.RUNTIME_LIB, this.EXEC_FILE, this.JAP_FILE});
    JButton okButton = new JButton(JAMS.i18n((String)"Ok"));
    JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
    JButton applyButton = new JButton(JAMS.i18n((String)"Apply"));
    WorkspaceFileAssociation wfa;
    SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd, yyyy hh:mm:ss X");

    public FilePropertiesDlg(Window w) {
        super(w);
        this.createGUI();
        this.setupActions();
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public WorkspaceFileAssociation getFile() {
        return this.wfa;
    }

    public void setFile(WorkspaceFileAssociation wfa) {
        this.wfa = wfa;
        this.fileTypeLabel.setText(wfa.getFileExtension());
        this.fileNameLabel.setText(wfa.getFileName());
        this.fileLocationLabel.setText(wfa.getFileDirectory());
        this.fileSizeLabel.setText(StringTools.humanReadableByteCount((long)wfa.getFile().getFileSize(), (boolean)false));
        this.fileCreatedLabel.setText(this.sdf.format(wfa.getFile().getCreationDate()));
        this.applyButton.setEnabled(false);
        this.fileRoleCombo.setSelectedItem(this.roleToString(wfa.getRole()));
        this.setTitle("Properties of " + wfa.getFileName());
        this.invalidate();
        this.pack();
    }

    private String roleToString(int role) {
        switch (role) {
            case 5: {
                return this.COMP_LIB;
            }
            case 3: {
                return this.CONF_FILE;
            }
            case 7: {
                return this.EXEC_FILE;
            }
            case 0: {
                return this.INPUT_FILE;
            }
            case 8: {
                return this.JAP_FILE;
            }
            case 2: {
                return this.MODEL_FILE;
            }
            case 4: {
                return this.OTHER_FILE;
            }
            case 1: {
                return this.OUTPUT_FILE;
            }
            case 6: {
                return this.RUNTIME_LIB;
            }
        }
        return this.OUTPUT_FILE;
    }

    private int stringToRole(String s) {
        if (s.compareTo(this.COMP_LIB) == 0) {
            return 5;
        }
        if (s.compareTo(this.CONF_FILE) == 0) {
            return 3;
        }
        if (s.compareTo(this.EXEC_FILE) == 0) {
            return 7;
        }
        if (s.compareTo(this.INPUT_FILE) == 0) {
            return 0;
        }
        if (s.compareTo(this.JAP_FILE) == 0) {
            return 8;
        }
        if (s.compareTo(this.MODEL_FILE) == 0) {
            return 2;
        }
        if (s.compareTo(this.OTHER_FILE) == 0) {
            return 4;
        }
        if (s.compareTo(this.OUTPUT_FILE) == 0) {
            return 1;
        }
        if (s.compareTo(this.RUNTIME_LIB) == 0) {
            return 6;
        }
        return 4;
    }

    private void setupActions() {
        this.fileRoleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int oldValue = FilePropertiesDlg.this.wfa.getRole();
                    String item = FilePropertiesDlg.this.fileRoleCombo.getSelectedItem().toString();
                    int newValue = FilePropertiesDlg.this.stringToRole(item);
                    if (newValue != oldValue) {
                        FilePropertiesDlg.this.applyButton.setEnabled(true);
                    } else {
                        FilePropertiesDlg.this.applyButton.setEnabled(false);
                    }
                }
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int oldValue = FilePropertiesDlg.this.wfa.getRole();
                String item = FilePropertiesDlg.this.fileRoleCombo.getSelectedItem().toString();
                int newValue = FilePropertiesDlg.this.stringToRole(item);
                if (newValue != oldValue) {
                    PropertyChangeListener[] listeners;
                    for (PropertyChangeListener pcl : listeners = FilePropertiesDlg.this.getPropertyChangeListeners("ROLE")) {
                        pcl.propertyChange(new PropertyChangeEvent(FilePropertiesDlg.this.wfa, "ROLE", oldValue, newValue));
                    }
                }
                FilePropertiesDlg.this.wfa.setRole(newValue);
                FilePropertiesDlg.this.applyButton.setEnabled(false);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int oldValue = FilePropertiesDlg.this.wfa.getRole();
                String item = FilePropertiesDlg.this.fileRoleCombo.getSelectedItem().toString();
                int newValue = FilePropertiesDlg.this.stringToRole(item);
                if (newValue != oldValue) {
                    PropertyChangeListener[] listeners;
                    for (PropertyChangeListener pcl : listeners = FilePropertiesDlg.this.getPropertyChangeListeners("ROLE")) {
                        pcl.propertyChange(new PropertyChangeEvent(FilePropertiesDlg.this.wfa, "ROLE", oldValue, newValue));
                    }
                }
                FilePropertiesDlg.this.wfa.setRole(newValue);
                FilePropertiesDlg.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDlg.this.setVisible(false);
            }
        });
    }

    private GridBagConstraints modifyConstrain(GridBagConstraints c, int gridx, int gridy, double weightx, double weighty) {
        c.gridx = gridx;
        c.gridy = gridy;
        c.weightx = weightx;
        c.weighty = weighty;
        return c;
    }

    private void createGUI() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        mainPanel.add((Component)tabPane, "Center");
        this.add(mainPanel);
        JPanel generalPanel = new JPanel();
        tabPane.addTab(JAMS.i18n((String)"General"), generalPanel);
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        GridBagLayout layout1 = new GridBagLayout();
        GridBagLayout layout2 = new GridBagLayout();
        GridBagLayout layout3 = new GridBagLayout();
        panel1.setLayout(layout1);
        panel2.setLayout(layout2);
        panel3.setLayout(layout3);
        generalPanel.add(panel1);
        generalPanel.add(new JSeparator(0));
        generalPanel.add(panel2);
        generalPanel.add(new JSeparator(0));
        generalPanel.add(panel3);
        this.fileIconLabel.setIcon(UIManager.getIcon("Tree.leafIcon"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 50;
        c.ipady = 10;
        panel1.add((Component)this.fileIconLabel, this.modifyConstrain(c, 0, 0, 1.0, 1.0));
        panel1.add((Component)this.fileNameLabel, this.modifyConstrain(c, 1, 0, 3.0, 1.0));
        panel2.add((Component)this.typeLabel, this.modifyConstrain(c, 0, 0, 1.0, 1.0));
        panel2.add((Component)this.fileTypeLabel, this.modifyConstrain(c, 1, 0, 3.0, 1.0));
        panel2.add((Component)this.locationLabel, this.modifyConstrain(c, 0, 1, 1.0, 1.0));
        panel2.add((Component)this.fileLocationLabel, this.modifyConstrain(c, 1, 1, 5.0, 1.0));
        panel2.add((Component)this.sizeLabel, this.modifyConstrain(c, 0, 2, 1.0, 1.0));
        panel2.add((Component)this.fileSizeLabel, this.modifyConstrain(c, 1, 2, 3.0, 1.0));
        panel2.add((Component)this.creationLabel, this.modifyConstrain(c, 0, 3, 1.0, 1.0));
        panel2.add((Component)this.fileCreatedLabel, this.modifyConstrain(c, 1, 3, 3.0, 1.0));
        panel3.add((Component)this.roleLabel, this.modifyConstrain(c, 0, 0, 1.0, 1.0));
        c.insets = new Insets(10, 0, 10, 25);
        panel3.add((Component)this.fileRoleCombo, this.modifyConstrain(c, 1, 0, 3.0, 1.0));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.applyButton);
        mainPanel.add((Component)buttonPanel, "South");
        this.setResizable(false);
        this.pack();
    }

    public static void main(String[] args) {
        WorkspaceFileAssociation wfa = new WorkspaceFileAssociation();
        File f = new File();
        f.setCreationDate(new Date());
        f.setFileSize(10000434325L);
        f.setId(Integer.valueOf(1));
        f.setLocation("C:/testdrive/test/xxxy.dat");
        wfa.setFile(f);
        wfa.setPath("C:/testdrive/test/xxxy.dat");
        wfa.setRole(7);
        FilePropertiesDlg fpd = new FilePropertiesDlg((Window)null);
        fpd.setFile(wfa);
        fpd.setVisible(true);
    }
}

