/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPoint;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AbstractSurfaceRenderable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceIcon;
import gov.nasa.worldwind.render.SurfaceIcons;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Map;

public class OpenStreetMapShapefileLoader {
    public static boolean isOSMPlacesSource(Object object) {
        if (object == null || WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = WWIO.getSourcePath(object);
        return string != null && WWIO.getFilename(string).equalsIgnoreCase("places.shp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Layer makeLayerFromOSMPlacesSource(Object object) {
        if (object == null || WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Shapefile shapefile = null;
        Layer layer = null;
        try {
            shapefile = new Shapefile(object);
            layer = OpenStreetMapShapefileLoader.makeLayerFromOSMPlacesShapefile(shapefile);
        }
        finally {
            if (shapefile != null) {
                shapefile.close();
            }
        }
        return layer;
    }

    /*
     * WARNING - void declaration
     */
    public static Layer makeLayerFromOSMPlacesShapefile(Shapefile shapefile) {
        Object object;
        Object object2;
        Object object3;
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OSMShapes[] oSMShapesArray = new OSMShapes[]{new OSMShapes(Color.BLACK, 0.3, 30000.0), new OSMShapes(Color.GREEN, 0.5, 100000.0), new OSMShapes(Color.CYAN, 1.0, 500000.0), new OSMShapes(Color.YELLOW, 2.0, 3000000.0)};
        while (shapefile.hasNext()) {
            void var6_10;
            Object object5;
            object3 = shapefile.nextRecord();
            if (object3 == null || !((ShapefileRecord)object3).getShapeType().equals("gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePoint") || (object5 = ((ShapefileRecord)object3).getAttributes().getValue("type")) == null || !(object5 instanceof String)) continue;
            OSMShapes oSMShapes = null;
            String string = (String)object5;
            if (string.equalsIgnoreCase("hamlet")) {
                oSMShapes = oSMShapesArray[0];
            } else if (string.equalsIgnoreCase("village")) {
                oSMShapes = oSMShapesArray[1];
            } else if (string.equalsIgnoreCase("town")) {
                oSMShapes = oSMShapesArray[2];
            } else if (string.equalsIgnoreCase("city")) {
                oSMShapes = oSMShapesArray[3];
            }
            if (oSMShapes == null) continue;
            Object var6_11 = null;
            object2 = ((ShapefileRecord)object3).getAttributes();
            if (object2.getEntries() != null) {
                for (Map.Entry entry : object2.getEntries()) {
                    if (!((String)entry.getKey()).equalsIgnoreCase("name")) continue;
                    String string2 = (String)entry.getValue();
                    break;
                }
            }
            object = ((ShapefileRecordPoint)object3).getPoint();
            LatLon latLon = LatLon.fromDegrees((double)object[1], (double)object[0]);
            if (!WWUtil.isEmpty(var6_10)) {
                Label label = new Label((String)var6_10, new Position(latLon, 0.0));
                label.setFont(oSMShapes.font);
                label.setColor(oSMShapes.foreground);
                label.setBackgroundColor(oSMShapes.background);
                label.setMaxActiveAltitude(oSMShapes.labelMaxAltitude);
                label.setPriority(oSMShapes.labelMaxAltitude);
                oSMShapes.labels.add(label);
            }
            oSMShapes.locations.add(latLon);
        }
        object3 = new TextAndShapesLayer();
        for (OSMShapes oSMShapes : oSMShapesArray) {
            object2 = PatternFactory.createPattern("PatternFactory.PatternCircle", 0.8f, oSMShapes.foreground);
            object = new SurfaceIcons(object2, shapefile.getPointBuffer().getLocations());
            ((SurfaceIcon)object).setMaxSize(4000.0 * oSMShapes.scale);
            ((SurfaceIcon)object).setMinSize(100.0);
            ((SurfaceIcon)object).setScale(oSMShapes.scale);
            ((AbstractSurfaceRenderable)object).setOpacity(0.8);
            ((RenderableLayer)object3).addRenderable((Renderable)object);
            oSMShapes.locations.clear();
            for (Label label : oSMShapes.labels) {
                ((TextAndShapesLayer)object3).addLabel(label);
            }
            oSMShapes.labels.clear();
        }
        return object3;
    }

    protected static class Label
    extends UserFacingText {
        protected double minActiveAltitude = -1.7976931348623157E308;
        protected double maxActiveAltitude = Double.MAX_VALUE;

        public Label(String string, Position position) {
            super(string, position);
        }

        public void setMinActiveAltitude(double d) {
            this.minActiveAltitude = d;
        }

        public void setMaxActiveAltitude(double d) {
            this.maxActiveAltitude = d;
        }

        public boolean isActive(DrawContext drawContext) {
            double d = drawContext.getView().getEyePosition().getElevation();
            return this.minActiveAltitude <= d && d <= this.maxActiveAltitude;
        }
    }

    protected static class TextAndShapesLayer
    extends RenderableLayer {
        protected ArrayList<GeographicText> labels = new ArrayList();
        protected GeographicTextRenderer textRenderer = new GeographicTextRenderer();

        public TextAndShapesLayer() {
            this.textRenderer.setCullTextEnabled(true);
            this.textRenderer.setCullTextMargin(2);
            this.textRenderer.setDistanceMaxScale(2.0);
            this.textRenderer.setDistanceMinScale(0.5);
            this.textRenderer.setDistanceMinOpacity(0.5);
            this.textRenderer.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        }

        public void addLabel(GeographicText geographicText) {
            this.labels.add(geographicText);
        }

        @Override
        public void doRender(DrawContext drawContext) {
            super.doRender(drawContext);
            this.setActiveLabels(drawContext);
            this.textRenderer.render(drawContext, this.labels);
        }

        protected void setActiveLabels(DrawContext drawContext) {
            for (GeographicText geographicText : this.labels) {
                if (!(geographicText instanceof Label)) continue;
                geographicText.setVisible(((Label)geographicText).isActive(drawContext));
            }
        }
    }

    protected static class OSMShapes {
        public ArrayList<LatLon> locations = new ArrayList();
        public ArrayList<Label> labels = new ArrayList();
        public Color foreground;
        public Color background;
        public Font font;
        public double scale;
        public double labelMaxAltitude;

        public OSMShapes(Color color, double d, double d2) {
            this.foreground = color;
            this.background = WWUtil.computeContrastingColor(color);
            this.font = new Font("Arial", 1, 10 + (int)(3.0 * d));
            this.scale = d;
            this.labelMaxAltitude = d2;
        }
    }
}

