/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.AnnotationNullLayout;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.util.ButtonAnnotation;
import gov.nasa.worldwindx.examples.util.ImageAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.opengl.GL2;
import javax.swing.event.EventListenerList;

public abstract class DialogAnnotation
extends GlobeAnnotation
implements ActionListener {
    protected static final String CLOSE_IMAGE_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-cancel.png";
    protected static final String BUSY_IMAGE_PATH = "images/indicator-16.gif";
    protected static final String DEPRESSED_MASK_PATH = "gov/nasa/worldwindx/examples/images/16x16-button-depressed-mask.png";
    protected static final String CLOSE_TOOLTIP_TEXT = "Close window";
    protected boolean busy;
    protected ButtonAnnotation closeButton;
    protected ImageAnnotation busyImage;
    protected EventListenerList listenerList = new EventListenerList();

    protected DialogAnnotation(Position position) {
        super("", position);
        this.initComponents();
        this.layoutComponents();
        this.setBusy(false);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean bl) {
        this.busy = bl;
        this.getBusyImage().getAttributes().setVisible(bl);
    }

    public ButtonAnnotation getCloseButton() {
        return this.closeButton;
    }

    public ImageAnnotation getBusyImage() {
        return this.busyImage;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionPerformed(actionEvent);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected void initComponents() {
        this.closeButton = new ButtonAnnotation((Object)CLOSE_IMAGE_PATH, DEPRESSED_MASK_PATH);
        this.closeButton.setActionCommand("gov.nasa.worldwind.avkey.Close");
        this.closeButton.addActionListener(this);
        this.closeButton.setToolTipText(CLOSE_TOOLTIP_TEXT);
        this.busyImage = new BusyImage(BUSY_IMAGE_PATH);
    }

    protected void layoutComponents() {
        AnnotationNullLayout annotationNullLayout = new AnnotationNullLayout();
        this.setLayout(annotationNullLayout);
        this.addChild(this.busyImage);
        this.addChild(this.closeButton);
        annotationNullLayout.setConstraint(this.busyImage, "gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest");
        annotationNullLayout.setConstraint(this.closeButton, "gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast");
    }

    protected void setupContainer(Annotation annotation) {
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        this.setupDefaultAttributes(annotationAttributes);
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFixed");
        annotationAttributes.setSize(new Dimension(0, 0));
        annotation.setPickEnabled(false);
        annotation.getAttributes().setDefaults(annotationAttributes);
    }

    protected void setupLabel(Annotation annotation) {
        AnnotationAttributes annotationAttributes = new AnnotationAttributes();
        this.setupDefaultAttributes(annotationAttributes);
        annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
        annotation.setPickEnabled(false);
        annotation.getAttributes().setDefaults(annotationAttributes);
    }

    protected void setupDefaultAttributes(AnnotationAttributes annotationAttributes) {
        Color color = new Color(0, 0, 0, 0);
        annotationAttributes.setBackgroundColor(color);
        annotationAttributes.setBorderColor(color);
        annotationAttributes.setBorderWidth(0.0);
        annotationAttributes.setCornerRadius(0);
        annotationAttributes.setDrawOffset(new Point(0, 0));
        annotationAttributes.setHighlightScale(1.0);
        annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
        annotationAttributes.setLeader("gov.nasa.worldwind.avkey.ShapeNone");
    }

    protected static class BusyImage
    extends ImageAnnotation {
        protected Angle angle;
        protected Angle increment;
        protected long lastFrameTime;

        public BusyImage(Object object) {
            super(object);
            this.setUseMipmaps(false);
            this.angle = Angle.ZERO;
            this.increment = Angle.fromDegrees(300.0);
        }

        public Angle getAngle() {
            return this.angle;
        }

        public void setAngle(Angle angle) {
            if (angle == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            double d = angle.degrees % 360.0;
            d = d > 180.0 ? d - 360.0 : (d < -180.0 ? 360.0 + d : d);
            this.angle = Angle.fromDegrees(d);
        }

        public Angle getIncrement() {
            return this.increment;
        }

        public void setIncrement(Angle angle) {
            if (angle == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.increment = angle;
        }

        @Override
        public void drawContent(DrawContext drawContext, int n, int n2, double d, Position position) {
            super.drawContent(drawContext, n, n2, d, position);
            this.updateState(drawContext);
        }

        @Override
        protected void transformBackgroundImageCoordsToAnnotationCoords(DrawContext drawContext, int n, int n2, WWTexture wWTexture) {
            GL2 gL2 = drawContext.getGL().getGL2();
            double d = (double)wWTexture.getWidth(drawContext) / 2.0;
            double d2 = (double)wWTexture.getHeight(drawContext) / 2.0;
            gL2.glTranslated(d, d2, 0.0);
            gL2.glRotated(-this.getAngle().degrees, 0.0, 0.0, 1.0);
            gL2.glTranslated(-d, -d2, 0.0);
            super.transformBackgroundImageCoordsToAnnotationCoords(drawContext, n, n2, wWTexture);
        }

        protected void updateState(DrawContext drawContext) {
            Angle angle = this.getIncrement();
            angle = this.adjustAngleIncrement(drawContext, angle);
            this.setAngle(this.getAngle().add(angle));
            drawContext.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, drawContext.getView());
            this.lastFrameTime = drawContext.getFrameTimeStamp();
        }

        protected Angle adjustAngleIncrement(DrawContext drawContext, Angle angle) {
            long l = drawContext.getFrameTimeStamp() - this.lastFrameTime;
            double d = (double)l / 1000.0;
            double d2 = d * angle.degrees;
            return Angle.fromDegrees(d2);
        }
    }
}

