/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.formats.vpf.VPFCoveragePanel;
import gov.nasa.worldwind.formats.vpf.VPFDatabase;
import gov.nasa.worldwind.formats.vpf.VPFDatabaseFilter;
import gov.nasa.worldwind.formats.vpf.VPFLayer;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class VPFLayerDemo
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        VPFLayerDemo.start("World Wind VPF Shapes", AppFrame.class);
    }

    public static class VPFFileFilter
    extends FileFilter {
        protected VPFDatabaseFilter filter = new VPFDatabaseFilter();

        @Override
        public boolean accept(File file) {
            if (file == null) {
                String string = Logging.getMessage("nullValue.FileIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return file.isDirectory() || this.filter.accept(file);
        }

        @Override
        public String getDescription() {
            return "VPF Databases (dht)";
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.makeControlPanel();
        }

        protected void addVPFLayer(File file) {
            VPFDatabase vPFDatabase = VPFUtils.readDatabase(file);
            VPFLayer vPFLayer = new VPFLayer(vPFDatabase);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), vPFLayer);
            this.getLayerPanel().update(this.getWwd());
            this.openVPFCoveragePanel(vPFDatabase, vPFLayer);
        }

        protected void openVPFCoveragePanel(VPFDatabase vPFDatabase, VPFLayer vPFLayer) {
            VPFCoveragePanel vPFCoveragePanel = new VPFCoveragePanel(this.getWwd(), vPFDatabase);
            vPFCoveragePanel.setLayer(vPFLayer);
            JFrame jFrame = new JFrame(vPFDatabase.getName());
            jFrame.setResizable(true);
            jFrame.setAlwaysOnTop(true);
            jFrame.add(vPFCoveragePanel);
            jFrame.pack();
            WWUtil.alignComponent(this, jFrame, "gov.nasa.worldwind.avkey.Center");
            jFrame.setVisible(true);
        }

        protected void showOpenDialog() {
            JFileChooser jFileChooser = new JFileChooser(Configuration.getUserHomeDirectory());
            jFileChooser.addChoosableFileFilter(new VPFFileFilter());
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            this.addVPFLayer(file);
        }

        protected void makeControlPanel() {
            JButton jButton = new JButton("Open VPF Database");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.showOpenDialog();
                }
            });
            Box box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
            box.add(jButton);
            this.getLayerPanel().add((Component)box, "South");
        }
    }
}

