/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class RotatedSector
extends ApplicationTemplate {
    private static final Sector sector = Sector.fromDegrees(45.0, 47.0, -123.0, -122.0);

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Rotated Sector", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                Globe globe = this.getWwd().getModel().getGlobe();
                double d = globe.getRadiusAt(sector.getCentroid());
                double d2 = sector.getDeltaLonRadians() * d;
                double d3 = sector.getDeltaLatRadians() * d;
                final SurfaceQuad surfaceQuad = new SurfaceQuad(sector.getCentroid(), d2, d3, Angle.ZERO);
                final RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("Rotating Sector");
                renderableLayer.addRenderable(surfaceQuad);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
                this.getLayerPanel().update(this.getWwd());
                Timer timer = new Timer(50, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (renderableLayer.isEnabled()) {
                            surfaceQuad.setHeading(Angle.fromDegrees((surfaceQuad.getHeading().getDegrees() + 1.0) % 360.0));
                            AppFrame.this.getWwd().redraw();
                        }
                    }
                });
                timer.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

