/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class ActiveLayersList
extends JList {
    public ActiveLayersList(ListModel listModel) {
        super(listModel);
        this.setOpaque(false);
        this.setCellRenderer(new LayerCellRenderer());
    }

    public boolean isIncludeInternalLayers() {
        return ((LayerCellRenderer)this.getCellRenderer()).isIncludeInternalLayers();
    }

    public void setIncludeInternalLayers(boolean bl) {
        if (bl == this.isIncludeInternalLayers()) {
            return;
        }
        ((LayerCellRenderer)this.getCellRenderer()).setIncludeInternalLayers(bl);
    }

    private static class LayerCellRenderer
    extends DefaultListCellRenderer {
        private LayerTree.CellPanel renderer = new LayerTree.CellPanel();
        private JPanel zeroSizeComponent;
        private Color selectionForeground = UIManager.getColor("List.selectionForeground");
        private Color selectionBackground = UIManager.getColor("List.selectionBackground");
        private Color textForeground = UIManager.getColor("List.textForeground");
        private Color textBackground = UIManager.getColor("List.textBackground");
        private boolean includeInternalLayers = false;

        public LayerCellRenderer() {
            this.zeroSizeComponent = new JPanel();
            this.zeroSizeComponent.setOpaque(false);
            this.zeroSizeComponent.setPreferredSize(new Dimension(0, 0));
        }

        public boolean isIncludeInternalLayers() {
            return this.includeInternalLayers;
        }

        public void setIncludeInternalLayers(boolean bl) {
            this.includeInternalLayers = bl;
        }

        protected LayerTree.CellPanel getRenderer() {
            return this.renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof Layer)) {
                return this.zeroSizeComponent;
            }
            Layer layer = (Layer)object;
            if (layer.getValue("gov.nasa.worldwindx.applications.worldwindow.InternalLayer") != null && !this.includeInternalLayers && layer.getValue("gov.nasa.worldwindx.applications.worldwindow.ActiveLayer") == null) {
                return this.zeroSizeComponent;
            }
            this.renderer.layerTitle.setText(layer.getName());
            this.renderer.checkBox.setSelected(layer.isEnabled());
            this.renderer.layerTitle.setForeground(bl ? this.selectionForeground : this.textForeground);
            this.renderer.layerTitle.setBackground(bl ? this.selectionBackground : this.textBackground);
            this.renderer.layerTitle.setOpaque(bl);
            this.renderer.layerTitle.setEnabled(true);
            this.renderer.checkBox.setEnabled(true);
            return this.renderer;
        }
    }
}

