/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class Registry {
    private ConcurrentHashMap<String, Object> registeredObjects = new ConcurrentHashMap();

    public Object createObject(String string) {
        if (string == null || string.length() == 0) {
            String string2 = "Class name is null or zero length";
            Util.getLogger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            return Class.forName(string.trim()).newInstance();
        }
        catch (Exception exception) {
            String string3 = "Exception creating object " + string;
            Util.getLogger().log(Level.SEVERE, string3, exception);
            throw new RuntimeException(string3, exception);
        }
        catch (Throwable throwable) {
            String string4 = "Error creating object " + string;
            Util.getLogger().log(Level.SEVERE, string4, throwable);
            throw new RuntimeException(string4, throwable);
        }
    }

    public Object createRegistryObject(Object object) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (object == null) {
            String string = "Class or class name is null";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(object instanceof Class) && !(object instanceof String)) {
            String string = "Class or class name is not Class or String type";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof String && ((String)object).length() == 0) {
            String string = "Class name is null or zero length";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : Class.forName(((String)object).trim());
        String string = clazz.getName();
        try {
            return clazz.getConstructor(this.getClass()).newInstance(this);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.createObject(string);
        }
        catch (InstantiationException instantiationException) {
            return this.createObject(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            return this.createObject(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            return this.createObject(string);
        }
        catch (Exception exception) {
            String string2 = "Exception creating object " + string;
            Util.getLogger().log(Level.SEVERE, string2, string);
            throw new RuntimeException(string2, exception);
        }
        catch (Throwable throwable) {
            String string3 = "Error creating object " + string;
            Util.getLogger().log(Level.SEVERE, string3, string);
            throw new RuntimeException(string3, throwable);
        }
    }

    public Object createAndRegisterObject(String string, Object object) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (WWUtil.isEmpty(string)) {
            String string2 = String.format("Object ID %s is null or zero length", string);
            Util.getLogger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null || object instanceof String && WWUtil.isEmpty(object)) {
            String string3 = String.format("Class name %s for feature %s is zero length", object, string);
            Util.getLogger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.registerObject(string, this.createRegistryObject(object));
        return this.getRegisteredObject(string);
    }

    public synchronized Object getRegisteredObject(String string) {
        return this.registeredObjects.get(string);
    }

    public synchronized Object registerObject(String string, Object object) {
        if (string != null) {
            this.registeredObjects.put(string, object);
        }
        return object;
    }

    public Collection<Object> getObjects() {
        return this.registeredObjects.values();
    }

    public Object[] getObjectsOfType(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Class<?> clazz = Class.forName(string);
            for (Map.Entry<String, Object> entry : this.registeredObjects.entrySet()) {
                if (entry.getValue() == null) continue;
                if (clazz.isInstance(entry.getValue())) {
                    arrayList.add(entry.getValue());
                    continue;
                }
                if (!(entry.getValue() instanceof Class) || !this.implementsInterface(clazz, (Class)entry.getValue())) continue;
                try {
                    arrayList.add(this.createAndRegisterObject(entry.getKey(), entry.getValue()));
                }
                catch (Exception exception) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Util.getLogger().log(Level.SEVERE, "No class found for class name " + (string != null ? string : null), classNotFoundException);
        }
        return arrayList.toArray();
    }

    protected boolean implementsInterface(Class clazz, Class clazz2) {
        Class<?>[] classArray;
        for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
            if (clazz3 != clazz) continue;
            return true;
        }
        return false;
    }
}

