/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.segmentplane;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlane;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneAttributes;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class SegmentPlaneController
implements MouseListener,
MouseMotionListener,
PositionListener {
    private boolean active = false;
    private SegmentPlaneEditor editor;
    private SegmentPlaneAttributes lastAttributes;
    private WorldWindow wwd;
    protected Point mousePoint;
    protected Point lastMousePoint;
    protected PickedObject activePickedObject;

    public SegmentPlaneController(WorldWindow worldWindow) {
        this.setWorldWindow(worldWindow);
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean bl) {
        this.active = bl;
    }

    public SegmentPlaneEditor getEditor() {
        return this.editor;
    }

    public void setEditor(SegmentPlaneEditor segmentPlaneEditor) {
        this.editor = segmentPlaneEditor;
    }

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (this.wwd == worldWindow) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.getInputHandler().removeMouseListener(this);
            this.wwd.getInputHandler().removeMouseMotionListener(this);
            this.wwd.removePositionListener(this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.getInputHandler().addMouseListener(this);
            this.wwd.getInputHandler().addMouseMotionListener(this);
            this.wwd.addPositionListener(this);
        }
    }

    protected PickedObject getTopOwnedControlPoint() {
        if (this.getEditor() == null) {
            return null;
        }
        if (this.getWorldWindow().getSceneController().getPickedObjectList() == null) {
            return null;
        }
        PickedObject pickedObject = this.getWorldWindow().getSceneController().getPickedObjectList().getTopPickedObject();
        if (pickedObject == null || !(pickedObject.getObject() instanceof SegmentPlane.ControlPoint)) {
            return null;
        }
        SegmentPlane.ControlPoint controlPoint = (SegmentPlane.ControlPoint)pickedObject.getObject();
        if (controlPoint.getOwner() != this.getEditor().getSegmentPlane()) {
            return null;
        }
        return pickedObject;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.updateCursor();
        this.updateAttributes();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        PickedObject pickedObject = this.getTopOwnedControlPoint();
        if (mouseEvent.getButton() == 1 && pickedObject != null) {
            this.active = true;
            this.activePickedObject = pickedObject;
            mouseEvent.consume();
        }
        this.updateCursor();
        this.updateAttributes();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        if (mouseEvent.getButton() == 1 && this.active) {
            this.active = false;
            this.activePickedObject = null;
            mouseEvent.consume();
        }
        this.updateCursor();
        this.updateAttributes();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.lastMousePoint = this.mousePoint;
        this.mousePoint = new Point(mouseEvent.getPoint());
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x400) != 0 && this.active) {
            mouseEvent.consume();
        }
        this.updateCursor();
        this.updateAttributes();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.lastMousePoint = this.mousePoint;
        this.mousePoint = new Point(mouseEvent.getPoint());
        this.updateCursor();
        this.updateAttributes();
    }

    @Override
    public void moved(PositionEvent positionEvent) {
        if (positionEvent == null) {
            return;
        }
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return;
        }
        if (this.activePickedObject != null) {
            this.handleObjectMoved(this.activePickedObject, positionEvent.getScreenPoint(), this.lastMousePoint);
        }
        this.updateCursor();
        this.updateAttributes();
    }

    protected void handleObjectMoved(PickedObject pickedObject, Point point, Point point2) {
        this.getEditor().moveControlPoint(this.getWorldWindow(), pickedObject, point, point2);
    }

    protected void updateAttributes() {
        SegmentPlaneAttributes segmentPlaneAttributes;
        if (this.getEditor() == null) {
            return;
        }
        if (this.lastAttributes == null) {
            this.lastAttributes = this.getEditor().getSegmentPlane().getAttributes();
        }
        if ((segmentPlaneAttributes = this.getAttributesFor(this.lastAttributes)) != null) {
            this.getEditor().getSegmentPlane().setAttributes(segmentPlaneAttributes);
        } else {
            this.getEditor().getSegmentPlane().setAttributes(this.lastAttributes);
            this.lastAttributes = null;
        }
    }

    protected void updateCursor() {
        Cursor cursor = this.getCursor();
        if (this.wwd instanceof Component) {
            ((Component)((Object)this.wwd)).setCursor(cursor);
        }
    }

    protected SegmentPlaneAttributes getAttributesFor(SegmentPlaneAttributes segmentPlaneAttributes) {
        Serializable serializable;
        PickedObject pickedObject;
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return null;
        }
        PickedObject pickedObject2 = pickedObject = this.isActive() ? this.activePickedObject : this.getTopOwnedControlPoint();
        if (pickedObject == null) {
            return null;
        }
        SegmentPlane.ControlPoint controlPoint = (SegmentPlane.ControlPoint)pickedObject.getObject();
        SegmentPlaneAttributes segmentPlaneAttributes2 = segmentPlaneAttributes.copy();
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = segmentPlaneAttributes2.getGeometryAttributes(controlPoint.getKey());
        SegmentPlaneAttributes.LabelAttributes labelAttributes = segmentPlaneAttributes2.getLabelAttributes(controlPoint.getKey());
        if (geometryAttributes != null) {
            serializable = SegmentPlaneController.makeBrighter(geometryAttributes.getMaterial().getDiffuse());
            geometryAttributes.setMaterial(new Material((Color)serializable));
            geometryAttributes.setSize(1.2 * geometryAttributes.getSize());
            geometryAttributes.setPickSize(1.2 * geometryAttributes.getPicksize());
        }
        if (labelAttributes != null) {
            serializable = labelAttributes.getFont().deriveFont(1);
            labelAttributes.setFont((Font)serializable);
        }
        return segmentPlaneAttributes2;
    }

    protected Cursor getCursor() {
        if (this.getEditor() == null || !this.getEditor().isArmed()) {
            return null;
        }
        if (this.active ? this.activePickedObject != null : this.getTopOwnedControlPoint() != null) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    private static Color makeBrighter(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        f2 /= 3.0f;
        f3 *= 3.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        int n = Color.HSBtoRGB(f, f2, f3);
        return new Color(n);
    }
}

