/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.render.markers.MarkerRenderer;
import java.awt.Color;
import java.util.ArrayList;

public class ScalebarHint {
    private WorldWindow wwd;
    private RenderableLayer layer = new RenderableLayer();
    private MarkerRenderer markerRenderer = new MarkerRenderer();
    private RenderableMarker marker;
    MarkerAttributes markerAttributes;
    private boolean enabled = true;

    public ScalebarHint() {
        this.layer.setName("Scalebar reference");
        this.layer.setEnabled(false);
        this.markerAttributes = new BasicMarkerAttributes(new Material(Color.YELLOW), "gov.nasa.worldwind.render.markers.Cone", 1.0, 10.0, 5.0);
        this.marker = new RenderableMarker(Position.ZERO, this.markerAttributes);
        this.layer.addRenderable(this.marker);
    }

    public void setWwd(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (!(layer instanceof ScalebarLayer)) continue;
            layer.setPickEnabled(true);
        }
        this.wwd.getModel().getLayers().add(this.layer);
        this.wwd.addSelectListener(new SelectListener(){

            @Override
            public void selected(SelectEvent selectEvent) {
                if (!ScalebarHint.this.enabled || selectEvent.getTopObject() == null || !(selectEvent.getTopObject() instanceof ScalebarLayer)) {
                    ScalebarHint.this.layer.setEnabled(false);
                    return;
                }
                if (!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                    return;
                }
                ScalebarHint.this.marker.setPosition(selectEvent.getTopPickedObject().getPosition());
                ScalebarHint.this.layer.setEnabled(true);
                ScalebarHint.this.wwd.redraw();
            }
        });
    }

    public MarkerAttributes getMarkerAttributes() {
        return this.markerAttributes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private class RenderableMarker
    extends BasicMarker
    implements Renderable {
        private ArrayList<Marker> markerList;

        public RenderableMarker(Position position, MarkerAttributes markerAttributes) {
            super(position, markerAttributes);
        }

        @Override
        public void render(DrawContext drawContext) {
            if (this.markerList == null) {
                this.markerList = new ArrayList();
                this.markerList.add(this);
            }
            ScalebarHint.this.markerRenderer.render(drawContext, this.markerList);
        }
    }
}

