/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.formats.csv.CSVWriter;
import gov.nasa.worldwind.formats.gpx.GpxWriter;
import gov.nasa.worldwind.formats.nmea.NmeaWriter;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.tracks.TrackPointIteratorImpl;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.tracks.CSVTrackReader;
import gov.nasa.worldwindx.applications.sar.tracks.GPXTrackReader;
import gov.nasa.worldwindx.applications.sar.tracks.NMEATrackReader;
import gov.nasa.worldwindx.applications.sar.tracks.TrackReader;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class SARTrack
extends WWObjectImpl
implements Iterable<Position> {
    public static final int FORMAT_GPX = 1;
    public static final int FORMAT_CSV = 2;
    public static final int FORMAT_NMEA = 3;
    private static int nextColor = 0;
    private static Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.PINK, Color.YELLOW};
    private File file = null;
    private String name = null;
    private int format = 0;
    private long lastSaveTime = 0L;
    private long lastModifiedTime = 0L;
    private double offset = 0.0;
    private Color color = SARTrack.nextColor();
    private ArrayList<SARPosition> positions;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    private static Color nextColor() {
        return colors[nextColor++ % colors.length];
    }

    public static SARTrack fromFile(String string) throws IOException {
        int n;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        SARTrack sARTrack = null;
        FormatInfo[] formatInfoArray = new FormatInfo[]{new FormatInfo(new CSVTrackReader(), 2), new FormatInfo(new GPXTrackReader(), 1), new FormatInfo(new NMEATrackReader(), 3)};
        for (n = 0; n < formatInfoArray.length && (sARTrack = SARTrack.readTrack(string, formatInfoArray[n])) == null; ++n) {
        }
        if (sARTrack != null) {
            sARTrack.setFile(file);
            sARTrack.setFormat(n);
            sARTrack.setName(file.getName());
        }
        return sARTrack;
    }

    private static SARTrack readTrack(String string, FormatInfo formatInfo) {
        if (!formatInfo.reader.canRead(string)) {
            return null;
        }
        Track[] trackArray = null;
        try {
            trackArray = formatInfo.reader.read(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToReadFile", string);
            Logging.logger().severe(string2);
        }
        if (trackArray == null) {
            return null;
        }
        TrackPointIteratorImpl trackPointIteratorImpl = new TrackPointIteratorImpl(Arrays.asList(trackArray));
        return SARTrack.makeTrackFromTrackPointIterator(trackPointIteratorImpl);
    }

    public static void toFile(SARTrack sARTrack, String string, int n) throws IOException {
        if (sARTrack == null) {
            throw new IllegalArgumentException("track is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("filePath is null");
        }
        if (n == 1) {
            SARTrack.writeGPX(sARTrack, string);
        } else if (n == 2) {
            SARTrack.writeCSV(sARTrack, string);
        } else if (n == 3) {
            SARTrack.writeNMEA(sARTrack, string);
        }
    }

    private SARTrack() {
    }

    public SARTrack(String string) {
        this.name = string;
        this.positions = new ArrayList();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.firePropertyChange("TrackController.TrackName", null, this);
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public long getLastSaveTime() {
        return this.lastSaveTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isDirty() {
        return this.lastModifiedTime == 0L || this.lastSaveTime == 0L || this.lastModifiedTime > this.lastSaveTime;
    }

    public void markDirty() {
        this.lastModifiedTime = System.currentTimeMillis();
        this.firePropertyChange("TrackController.TrackDirtyBit", null, this);
    }

    public void clearDirtyBit() {
        long l;
        this.lastSaveTime = l = System.currentTimeMillis();
        this.lastModifiedTime = l;
        this.firePropertyChange("TrackController.TrackDirtyBit", null, this);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int size() {
        return this.positions.size();
    }

    public ArrayList<SARPosition> getPositions() {
        return this.positions;
    }

    public SARPosition get(int n) {
        return this.positions.size() > n ? this.positions.get(n) : null;
    }

    public void set(int n, SARPosition sARPosition) {
        if (sARPosition == null) {
            return;
        }
        if (n >= this.positions.size()) {
            this.positions.add(sARPosition);
        } else {
            this.positions.set(n, sARPosition);
        }
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, n);
    }

    public void add(int n, SARPosition sARPosition) {
        if (sARPosition == null) {
            return;
        }
        if (n >= this.positions.size()) {
            this.positions.add(sARPosition);
        } else {
            this.positions.add(n, sARPosition);
        }
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, this);
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        double d2 = this.offset;
        this.offset = d;
        this.firePropertyChange("TrackController.TrackOffset", d2, this.offset);
    }

    @Override
    public Iterator<Position> iterator() {
        return new Iterator<Position>(){
            private Iterator<SARPosition> iter;
            {
                this.iter = SARTrack.this.positions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Position next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operation not supported for SARTrack iterator");
            }
        };
    }

    public void removePosition(int n) {
        if (n < 0 || n >= this.positions.size()) {
            return;
        }
        this.positions.remove(n);
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, this);
    }

    public void removePositions(int[] nArray) {
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] < 0 || nArray[i] >= this.positions.size()) continue;
            this.positions.remove(nArray[i]);
        }
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, this);
    }

    public void appendPosition(SARPosition sARPosition) {
        if (sARPosition == null) {
            return;
        }
        this.positions.add(sARPosition);
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, this);
    }

    public void insertPosition(int n, SARPosition sARPosition) {
        if (sARPosition == null || n < 0) {
            return;
        }
        this.positions.add(n, sARPosition);
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, this);
    }

    public void setPosition(int n, SARPosition sARPosition) {
        if (sARPosition == null || n < 0) {
            return;
        }
        this.positions.set(n, sARPosition);
        this.markDirty();
        this.firePropertyChange("TrackController.TrackModified", null, n);
    }

    private static void writeNMEA(SARTrack sARTrack, String string) throws IOException {
        NmeaWriter nmeaWriter = new NmeaWriter(string);
        Track track = SARTrack.makeTrackFromSARTrack(sARTrack);
        nmeaWriter.writeTrack(track);
        nmeaWriter.close();
    }

    private static void writeGPX(SARTrack sARTrack, String string) throws IOException {
        try {
            GpxWriter gpxWriter = new GpxWriter(string);
            Track track = SARTrack.makeTrackFromSARTrack(sARTrack);
            gpxWriter.writeTrack(track);
            gpxWriter.close();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IllegalArgumentException(transformerException);
        }
    }

    private static void writeCSV(SARTrack sARTrack, String string) throws IOException {
        CSVWriter cSVWriter = new CSVWriter(string);
        Track track = SARTrack.makeTrackFromSARTrack(sARTrack);
        cSVWriter.writeTrack(track);
        cSVWriter.close();
    }

    private static SARTrack makeTrackFromTrackPointIterator(TrackPointIterator trackPointIterator) {
        Object object;
        ArrayList<SARPosition> arrayList = new ArrayList<SARPosition>();
        while (trackPointIterator.hasNext()) {
            object = trackPointIterator.next();
            SARPosition sARPosition = new SARPosition(Angle.fromDegrees(object.getLatitude()), Angle.fromDegrees(object.getLongitude()), object.getElevation());
            arrayList.add(sARPosition);
        }
        object = new SARTrack();
        ((SARTrack)object).positions = arrayList;
        return object;
    }

    private static Track makeTrackFromSARTrack(SARTrack sARTrack) {
        return new TrackWrapper(sARTrack);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.propChangeSupport.firePropertyChange(string, object, object2);
    }

    public String toString() {
        return this.name;
    }

    private static class TrackPointWrapper
    implements TrackPoint {
        private final SARPosition sarPosition;

        public TrackPointWrapper(SARPosition sARPosition) {
            this.sarPosition = sARPosition;
        }

        @Override
        public double getLatitude() {
            return this.sarPosition.getLatitude().degrees;
        }

        @Override
        public void setLatitude(double d) {
        }

        @Override
        public double getLongitude() {
            return this.sarPosition.getLongitude().degrees;
        }

        @Override
        public void setLongitude(double d) {
        }

        @Override
        public double getElevation() {
            return this.sarPosition.getElevation();
        }

        @Override
        public void setElevation(double d) {
        }

        @Override
        public String getTime() {
            return null;
        }

        @Override
        public void setTime(String string) {
        }

        @Override
        public Position getPosition() {
            return this.sarPosition;
        }

        @Override
        public void setPosition(Position position) {
        }
    }

    private static class TrackWrapper
    implements Track,
    TrackSegment {
        private final SARTrack sarTrack;
        private final ArrayList<TrackSegment> segments = new ArrayList();

        public TrackWrapper(SARTrack sARTrack) {
            this.sarTrack = sARTrack;
            this.segments.add(this);
        }

        @Override
        public List<TrackSegment> getSegments() {
            return this.segments;
        }

        @Override
        public String getName() {
            return this.sarTrack.getName();
        }

        @Override
        public int getNumPoints() {
            return this.sarTrack.size();
        }

        @Override
        public List<TrackPoint> getPoints() {
            ArrayList<TrackPoint> arrayList = new ArrayList<TrackPoint>();
            for (SARPosition sARPosition : this.sarTrack.positions) {
                arrayList.add(sARPosition != null ? new TrackPointWrapper(sARPosition) : null);
            }
            return arrayList;
        }
    }

    private static class FormatInfo {
        private TrackReader reader;
        private int format;

        private FormatInfo(TrackReader trackReader, int n) {
            this.reader = trackReader;
            this.format = n;
        }
    }
}

