/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwindx.examples.BulkDownloadPanel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class BulkDownloadFrame
extends JFrame {
    public BulkDownloadFrame(WorldWindow worldWindow) {
        final BulkDownloadPanel bulkDownloadPanel = new BulkDownloadPanel(worldWindow);
        final BulkDownloadFrame bulkDownloadFrame = this;
        this.setTitle("Bulk Download");
        this.add(bulkDownloadPanel);
        this.pack();
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (bulkDownloadPanel.hasActiveDownloads()) {
                    int n = JOptionPane.showConfirmDialog(bulkDownloadFrame, "Cancel all active downloads?", "Active downloads", 2, 3);
                    if (n == 2) {
                        return;
                    }
                    bulkDownloadPanel.cancelActiveDownloads();
                    bulkDownloadPanel.clearInactiveDownloads();
                }
                bulkDownloadPanel.clearSector();
                BulkDownloadFrame.this.setVisible(false);
            }
        });
    }
}

