/*
 * Decompiled with CFR 0.152.
 */
package oms3.nap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import oms3.nap.AnnotationHandler;
import oms3.nap.AnnotationParser;
import oms3.nap.JNAComponentTask;

public abstract class JNAFortran
implements AnnotationHandler {
    String libname;
    String modName;
    String javaExecFunction;
    File srcFile;
    File genFile;
    String packageName;
    Map<String, Map<String, String>> compAnn;
    List<Decl> decl = new ArrayList<Decl>();
    JNAComponentTask task;
    boolean valid = true;

    public JNAFortran(JNAComponentTask task) {
        this.task = task;
    }

    public void setGenFile(File genFile) {
        this.genFile = genFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    void setRelativeFile(String incFile) {
        this.packageName = new File(incFile).getParent().toString();
    }

    public void setLibname(String libname) {
        this.libname = libname;
    }

    List<Decl> getOutArrays(List<Decl> l) {
        ArrayList<Decl> o = new ArrayList<Decl>();
        for (Decl decl : l) {
            if (!decl.isArray() || !decl.isOut() || decl.isIn()) continue;
            o.add(decl);
        }
        return o;
    }

    @Override
    public void handle(Map<String, Map<String, String>> ann, String line) {
        if (ann.containsKey("Execute")) {
            this.javaExecFunction = ann.get("Execute").get("value");
            if (this.javaExecFunction == null) {
                line = line.trim();
                this.javaExecFunction = line.substring(line.indexOf(32), line.indexOf(40));
            } else {
                this.javaExecFunction = AnnotationParser.trimQuotes(this.javaExecFunction);
            }
            this.javaExecFunction = this.javaExecFunction.trim().toLowerCase();
            this.compAnn = ann;
        } else if (ann.containsKey("In") || ann.containsKey("Out")) {
            this.decl.addAll(Decl.parse(line.trim(), ann));
        }
    }

    @Override
    public void start(String src) {
        src = src.toLowerCase();
    }

    static File generateLib(JNAComponentTask task, File dir, List<JNAFortran> cl) throws FileNotFoundException {
        String libclassname = "Lib" + task.dllName;
        File o = new File(dir, "nap" + File.separatorChar + libclassname + ".java");
        o.getParentFile().mkdirs();
        PrintStream w = new PrintStream(o);
        w.println("// Generated at " + new Date());
        w.println("package nap;");
        w.println();
        w.println("import com.sun.jna.ptr.*;");
        w.println("import java.util.logging.Level;");
        w.println("import java.util.logging.Logger;");
        w.println("import oms3.annotations.*;");
        w.println();
        w.println(" @DLL(\"" + task.dllName + "\")");
        w.println(" public interface " + libclassname + " extends com.sun.jna.Library {");
        w.println("   // library mapping reference");
        w.println("   " + libclassname + " lib = oms3.util.NativeLibraries.bind(" + libclassname + ".class);");
        w.println("   " + libclassname + " synclib = (" + libclassname + ") com.sun.jna.Native.synchronizedLibrary(lib);");
        w.println();
        for (JNAFortran jNAFortran : cl) {
            w.println("   // DLL function");
            w.print("   void " + jNAFortran.getNativeName() + "(");
            for (int i = 0; i < jNAFortran.decl.size(); ++i) {
                Decl d = jNAFortran.decl.get(i);
                if (d.isScalar()) {
                    w.print("\n     ByReference " + d.name);
                } else {
                    w.print("\n     " + d.type + " " + d.name);
                    if (d.type.equals("String")) {
                        w.print(", int " + d.name + "_len");
                    }
                }
                if (i >= jNAFortran.decl.size() - 1) continue;
                w.print(",");
            }
            w.println(");");
            w.println();
        }
        w.println(" }");
        w.close();
        return o;
    }

    @Override
    public void done() throws Exception {
        if (this.javaExecFunction == null) {
            this.valid = false;
            return;
        }
        this.genFile.getParentFile().mkdirs();
        String className = this.genFile.getName().substring(0, this.genFile.getName().indexOf(46));
        PrintStream w = new PrintStream(this.genFile);
        List<Decl> outArr = this.getOutArrays(this.decl);
        w.println("// OMS3 Native proxy from '" + this.srcFile.getPath() + "'");
        w.println("// Generated at " + new Date());
        w.println("package " + this.packageName.replace('/', '.') + ";");
        w.println();
        w.println("import com.sun.jna.ptr.*;");
        w.println("import java.util.logging.Level;");
        w.println("import java.util.logging.Logger;");
        w.println("import oms3.annotations.*;");
        w.println();
        this.compAnn.remove("Execute");
        String libclassname = "Lib" + this.task.dllName;
        String lib = "lib";
        if (this.compAnn.containsKey("Synchronized")) {
            lib = "synclib";
            this.compAnn.remove("Synchronized");
        }
        w.print(AnnotationParser.toString(this.compAnn));
        w.println("public class " + className + " {");
        w.println();
        if (this.task.genlogging) {
            w.println("  static final Logger log = Logger.getLogger(\"oms3.model.\" +");
            w.println("           " + className + ".class.getName());");
        }
        if (this.task.gensingleton) {
            w.println("  private static " + className + " instance;");
            w.println("  public static synchronized " + className + " instance() {");
            w.println("    if (instance == null) {");
            w.println("      instance = new " + className + "();");
            w.println("    }");
            w.println("    return instance;");
            w.println("  }");
        }
        w.println();
        if (!outArr.isEmpty()) {
            w.println(" private boolean __shouldInit__ = true;");
        }
        w.println();
        for (Decl d : this.decl) {
            w.print(AnnotationParser.toString(d.ann));
            w.println(" public " + d.type + " " + d.name + ";");
            w.println();
        }
        w.println(" @Execute");
        w.println(" public void exec() throws Exception {");
        if (!outArr.isEmpty()) {
            w.println("  if(__shouldInit__) {");
            for (Decl decl : outArr) {
                w.println("      " + decl.name + " = new " + decl.getBaseType() + "[" + decl.getDimension() + "];");
            }
            w.println("      __shouldInit__ = false;");
            w.println("  }");
        }
        for (Decl d : this.decl) {
            if (!d.isScalar()) continue;
            w.println("  " + d.getReferenceType() + " " + d.name + "__ = new " + d.getReferenceType() + "(" + d.name + ");");
        }
        w.print("  nap." + libclassname + "." + lib + "." + this.getNativeName() + "(");
        for (int i = 0; i < this.decl.size(); ++i) {
            Decl d;
            d = this.decl.get(i);
            w.print("\n     " + d.name);
            if (d.isScalar()) {
                w.print("__");
            }
            if (d.type.equals("String")) {
                w.print(", " + d.name + ".length()");
            }
            if (i >= this.decl.size() - 1) continue;
            w.print(",");
        }
        w.println(");");
        for (Decl d : this.decl) {
            if (!d.isScalar() || !d.isOut()) continue;
            w.println("  " + d.name + " = " + d.name + "__.getValue();");
        }
        if (this.task.genlogging) {
            w.println("  if(log.isLoggable(Level.INFO)) {");
            w.println("   log.info(oms3.ComponentAccess.dump(this));");
            w.println("  }");
        }
        w.println(" }");
        w.println("}");
        w.close();
        this.genFile.setLastModified(this.srcFile.lastModified());
    }

    String getNativeName() {
        return this.modName != null ? "__" + this.modName + "_MOD_" + this.javaExecFunction : this.javaExecFunction + "_";
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Arrays.toString(Decl.getDeclNames("CHARACTER(C_CHAR, len=hyd2er_len)  :: a")));
    }

    private static class Decl {
        Map<String, Map<String, String>> ann;
        String type;
        String name;
        String decl;

        Decl(Map<String, Map<String, String>> ann, String type, String name, String decl) {
            this.ann = ann;
            this.type = type;
            this.name = name;
            this.decl = decl.toLowerCase();
        }

        boolean isOut() {
            return this.ann.containsKey("Out");
        }

        boolean isIn() {
            return this.ann.containsKey("In");
        }

        boolean isScalar() {
            return this.type.equals("float") || this.type.equals("double") || this.type.equals("boolean") || this.type.equals("int");
        }

        boolean isArray() {
            return this.type.endsWith("[]");
        }

        String getBaseType() {
            if (this.isArray()) {
                return this.type.substring(0, this.type.indexOf(91));
            }
            throw new RuntimeException("Not an array declaration: " + this.toString());
        }

        String getReferenceType() {
            if (this.type.equals("float")) {
                return "FloatByReference";
            }
            if (this.type.equals("double")) {
                return "DoubleByReference";
            }
            if (this.type.equals("int")) {
                return "IntByReference";
            }
            throw new IllegalArgumentException(this.type);
        }

        String getDimension() {
            if (this.isArray()) {
                String dim = this.decl.substring(this.decl.indexOf("dimension"));
                dim = dim.substring(dim.indexOf(40) + 1, dim.indexOf(41));
                return dim.trim();
            }
            throw new RuntimeException("Illegal Dimension :" + this.decl);
        }

        static String getJavaType(String fDecl) {
            String d = fDecl.toLowerCase().trim();
            if (d.contains("c_float") && Decl.isArray(fDecl)) {
                return "float[]";
            }
            if (d.contains("c_int") && Decl.isArray(fDecl)) {
                return "int[]";
            }
            if (d.contains("c_double") && Decl.isArray(fDecl)) {
                return "double[]";
            }
            if (d.contains("c_float")) {
                return "float";
            }
            if (d.contains("c_int")) {
                return "int";
            }
            if (d.contains("c_double")) {
                return "double";
            }
            if (d.startsWith("char")) {
                return "String";
            }
            throw new IllegalArgumentException(fDecl);
        }

        static String[] getDeclNames(String fDecl) {
            String d = fDecl.toLowerCase().trim();
            String[] s = d.split("::");
            if (s.length != 2) {
                throw new IllegalArgumentException(fDecl);
            }
            return s[1].trim().split("\\s*,\\s*");
        }

        static List<Decl> parse(String decl, Map<String, Map<String, String>> ann) {
            String[] names;
            ArrayList<Decl> l = new ArrayList<Decl>();
            String jType = Decl.getJavaType(decl);
            for (String name : names = Decl.getDeclNames(decl)) {
                l.add(new Decl(ann, jType, name, decl));
            }
            return l;
        }

        static boolean isArray(String fDecl) {
            String d = fDecl.toLowerCase().trim();
            return d.indexOf("dimension") > -1;
        }
    }
}

