/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.PropertyAccessor;

public class ViewPropertyAccessor {
    public static PropertyAccessor.DoubleAccessor createElevationAccessor(View view) {
        return new ElevationAccessor(view);
    }

    public static PropertyAccessor.AngleAccessor createHeadingAccessor(View view) {
        return new HeadingAccessor(view);
    }

    public static PropertyAccessor.AngleAccessor createPitchAccessor(View view) {
        return new PitchAccessor(view);
    }

    public static PropertyAccessor.AngleAccessor createRollAccessor(View view) {
        return new RollAccessor(view);
    }

    public static PropertyAccessor.PositionAccessor createEyePositionAccessor(View view) {
        return new EyePositionAccessor(view);
    }

    public static class ElevationAccessor
    implements PropertyAccessor.DoubleAccessor {
        protected View view;

        ElevationAccessor(View view) {
            this.view = view;
        }

        @Override
        public Double getDouble() {
            if (this.view == null) {
                return null;
            }
            return this.view.getEyePosition().getElevation();
        }

        @Override
        public boolean setDouble(Double d) {
            if (this.view == null || d == null) {
                return false;
            }
            try {
                this.view.setEyePosition(new Position(this.view.getCurrentEyePosition(), d));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class EyePositionAccessor
    implements PropertyAccessor.PositionAccessor {
        protected View view;

        EyePositionAccessor(View view) {
            this.view = view;
        }

        @Override
        public Position getPosition() {
            if (this.view == null) {
                return null;
            }
            return this.view.getEyePosition();
        }

        @Override
        public boolean setPosition(Position position) {
            if (this.view == null || position == null) {
                return false;
            }
            try {
                this.view.setEyePosition(position);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class RollAccessor
    implements PropertyAccessor.AngleAccessor {
        protected View view;

        RollAccessor(View view) {
            this.view = view;
        }

        @Override
        public final Angle getAngle() {
            if (this.view == null) {
                return null;
            }
            return this.view.getRoll();
        }

        @Override
        public final boolean setAngle(Angle angle) {
            if (this.view == null || angle == null) {
                return false;
            }
            try {
                this.view.setRoll(angle);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class PitchAccessor
    implements PropertyAccessor.AngleAccessor {
        protected View view;

        PitchAccessor(View view) {
            this.view = view;
        }

        @Override
        public final Angle getAngle() {
            if (this.view == null) {
                return null;
            }
            return this.view.getPitch();
        }

        @Override
        public final boolean setAngle(Angle angle) {
            if (this.view == null || angle == null) {
                return false;
            }
            try {
                this.view.setPitch(angle);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class HeadingAccessor
    implements PropertyAccessor.AngleAccessor {
        protected View view;

        HeadingAccessor(View view) {
            this.view = view;
        }

        @Override
        public final Angle getAngle() {
            if (this.view == null) {
                return null;
            }
            return this.view.getHeading();
        }

        @Override
        public final boolean setAngle(Angle angle) {
            if (this.view == null || angle == null) {
                return false;
            }
            try {
                this.view.setHeading(angle);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

