/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.tree.Animation;
import gov.nasa.worldwind.util.tree.ScrollFrame;
import java.awt.Dimension;

public class WindowShadeAnimation
implements Animation {
    public int DEFAULT_DURATION;
    protected ScrollFrame frame;
    protected int startWindowHeight;
    protected int targetWindowHeight;
    protected int duration;
    protected long animationStart;
    protected Size targetWindowSize;
    protected int maximizedWindowHeight;

    public WindowShadeAnimation(ScrollFrame scrollFrame) {
        this.duration = this.DEFAULT_DURATION = 400;
        this.frame = scrollFrame;
    }

    @Override
    public void reset() {
        this.animationStart = System.currentTimeMillis();
        Dimension dimension = this.frame.getCurrentSize();
        if (this.frame.isMinimized()) {
            this.startWindowHeight = dimension.height;
            this.maximizedWindowHeight = dimension.height;
            this.targetWindowHeight = this.frame.getTitleBarHeight() + this.frame.frameBorder * 2;
        } else {
            this.startWindowHeight = dimension.height;
            this.targetWindowHeight = this.maximizedWindowHeight;
        }
    }

    @Override
    public void step() {
        long l = System.currentTimeMillis();
        double d = WWMath.computeInterpolationFactor(l, this.animationStart, this.animationStart + (long)this.duration);
        int n = (int)WWMath.mix(d, this.startWindowHeight, this.targetWindowHeight);
        Dimension dimension = this.frame.getCurrentSize();
        this.frame.setMinimizedSize(Size.fromPixels(dimension.width, n));
    }

    @Override
    public boolean hasNext() {
        return this.frame.getCurrentSize().height != this.targetWindowHeight;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.duration = n;
    }
}

