/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.layertree;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.layertree.LayerTreeNode;
import gov.nasa.worldwind.util.tree.BasicTreeModel;
import gov.nasa.worldwind.util.tree.BasicTreeNode;
import gov.nasa.worldwind.util.tree.TreeNode;

public class LayerTreeModel
extends BasicTreeModel {
    protected static final String DEFAULT_ROOT_NAME = "Layers";
    protected boolean includeHiddenLayers;

    public LayerTreeModel() {
        this.initialize();
    }

    public LayerTreeModel(LayerList layerList) {
        this(layerList, false);
    }

    public LayerTreeModel(LayerList layerList, boolean bl) {
        if (layerList == null) {
            String string = Logging.getMessage("nullValue.LayersListArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initialize();
        this.includeHiddenLayers = bl;
        this.refresh(layerList);
    }

    public boolean isIncludeHiddenLayers() {
        return this.includeHiddenLayers;
    }

    public void setIncludeHiddenLayers(boolean bl) {
        this.includeHiddenLayers = bl;
    }

    protected void initialize() {
        this.setRoot(this.createRootNode());
    }

    protected TreeNode createRootNode() {
        return new BasicTreeNode(DEFAULT_ROOT_NAME);
    }

    public void addLayer(LayerTreeNode layerTreeNode) {
        if (layerTreeNode == null) {
            String string = Logging.getMessage("nullValue.TreeNodeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getRoot().addChild(layerTreeNode);
    }

    public LayerTreeNode addLayer(Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LayerTreeNode layerTreeNode = this.createLayerNode(layer);
        if (layerTreeNode == null) {
            return layerTreeNode;
        }
        this.addLayer(layerTreeNode);
        return layerTreeNode;
    }

    protected LayerTreeNode createLayerNode(Layer layer) {
        return new LayerTreeNode(layer);
    }

    public void removeAllLayers() {
        this.getRoot().removeAllChildren();
    }

    public void refresh(LayerList layerList) {
        if (layerList == null) {
            String string = Logging.getMessage("nullValue.LayersListArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.removeAllLayers();
        for (Layer layer : layerList) {
            if (!this.mustIncludeLayer(layer)) continue;
            this.addLayer(layer);
        }
    }

    protected boolean mustIncludeLayer(Layer layer) {
        return this.isIncludeHiddenLayers() || layer.getValue("gov.nasa.worldwind.avkey.Hidden") != Boolean.TRUE;
    }
}

