/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.Aviation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Airborne
extends Aviation {
    protected TacticalSymbol symbol;
    protected TacticalSymbolAttributes symbolAttributes;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OLAA-------");
    }

    public Airborne(String string) {
        super(string, 1);
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("A".equals(string) && object instanceof String) {
            this.setSymbol((String)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("A".equals(string)) {
            return this.symbol != null ? this.symbol.getIdentifier() : null;
        }
        return super.getModifier(string);
    }

    public String getSymbol() {
        return this.symbol != null ? this.symbol.getIdentifier() : null;
    }

    public void setSymbol(String string) {
        if (string != null) {
            if (this.symbolAttributes == null) {
                this.symbolAttributes = new BasicTacticalSymbolAttributes();
            }
            this.symbol = this.createSymbol(string, this.computeSymbolPosition(), this.symbolAttributes);
        } else {
            this.symbol = null;
            this.symbolAttributes = null;
        }
        this.onModifierChanged();
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        super.setPositions(iterable);
        if (this.symbol != null) {
            this.symbol.setPosition(this.computeSymbolPosition());
        }
    }

    @Override
    public void doRenderGraphicModifiers(DrawContext drawContext) {
        super.doRenderGraphicModifiers(drawContext);
        if (this.symbol != null) {
            this.symbol.render(drawContext);
        }
    }

    protected Position computeSymbolPosition() {
        Iterable<? extends Position> iterable = this.getPositions();
        if (iterable == null) {
            return null;
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        return new Position(LatLon.interpolateGreatCircle(0.1, position2, position), 0.0);
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setScale(this.activeOverrides.getScale());
        }
    }
}

