/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Dummy
extends AbstractMilStd2525TacticalGraphic {
    protected Path path = this.createPath();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-PD---------");
    }

    public Dummy(String string) {
        super(string);
        this.path.setAttributes(this.getActiveShapeAttributes());
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.path.render(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.path.setDelegateOwner(object);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            Position position = iterator.next();
            Position position2 = iterator.next();
            Position position3 = iterator.next();
            this.path.setPositions(Arrays.asList(position2, position, position3));
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.path.getPositions();
    }

    @Override
    public Position getReferencePosition() {
        return this.path.getReferencePosition();
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        shapeAttributes.setOutlineWidth(2.0);
        shapeAttributes.setOutlineStippleFactor(15);
        shapeAttributes.setOutlineStipplePattern((short)-21846);
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        return path;
    }
}

