/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BasicArea
extends AbstractMilStd2525TacticalGraphic
implements PreRenderable {
    protected SurfacePolygon polygon = this.createPolygon();
    protected TacticalGraphicLabel identityLabel1;
    protected TacticalGraphicLabel identityLabel2;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GAG--------", "G-G-GAA--------", "G-G-GAE--------", "G-G-GAX--------", "G-G-GAL--------", "G-G-GAP--------", "G-G-GAD--------", "G-G-DAE--------");
    }

    public BasicArea(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        this.polygon.setLocations(iterable);
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        Iterable<? extends LatLon> iterable = this.polygon.getLocations();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        if (iterable == null) {
            return null;
        }
        for (LatLon latLon : iterable) {
            if (latLon instanceof Position) {
                arrayList.add((Position)latLon);
                continue;
            }
            arrayList.add(new Position(latLon, 0.0));
        }
        return arrayList;
    }

    @Override
    public Position getReferencePosition() {
        return this.polygon.getReferencePosition();
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.makeShapes(drawContext);
        this.determinePerFrameAttributes(drawContext);
        this.polygon.preRender(drawContext);
    }

    protected void makeShapes(DrawContext drawContext) {
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.polygon.render(drawContext);
    }

    protected String createLabelText() {
        String string = this.getGraphicLabel();
        String string2 = this.getText();
        if (string == null && string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(string).append("\n");
        }
        if (!WWUtil.isEmpty(string2)) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    protected String getGraphicLabel() {
        String string = this.maskedSymbolCode;
        if ("G-G-GAG--------".equalsIgnoreCase(string)) {
            return "";
        }
        if ("G-G-GAA--------".equalsIgnoreCase(string)) {
            return "AA";
        }
        if ("G-G-GAD--------".equalsIgnoreCase(string)) {
            return "DZ";
        }
        if ("G-G-GAE--------".equalsIgnoreCase(string) || "G-G-DAE--------".equalsIgnoreCase(string)) {
            return "EA";
        }
        if ("G-G-GAX--------".equalsIgnoreCase(string)) {
            return "EZ";
        }
        if ("G-G-GAL--------".equalsIgnoreCase(string)) {
            return "LZ";
        }
        if ("G-G-GAP--------".equalsIgnoreCase(string)) {
            return "PZ";
        }
        return "";
    }

    protected String getLabelAlignment() {
        return "gov.nasa.worldwind.avkey.Center";
    }

    @Override
    protected void createLabels() {
        String string = this.createLabelText();
        if (!WWUtil.isEmpty(string)) {
            TacticalGraphicLabel tacticalGraphicLabel = this.addLabel(string);
            tacticalGraphicLabel.setTextAlign(this.getLabelAlignment());
            tacticalGraphicLabel.setOffset(this.getDefaultLabelOffset());
        }
        if (this.mustShowHostileIndicator()) {
            this.identityLabel1 = this.addLabel("ENY");
            this.identityLabel2 = this.addLabel("ENY");
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (this.labels == null || this.labels.isEmpty()) {
            return;
        }
        Position position = this.determineMainLabelPosition(drawContext);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(position);
        if (this.mustShowHostileIndicator()) {
            this.determineIdentityLabelPositions();
        }
    }

    protected Position determineMainLabelPosition(DrawContext drawContext) {
        List<Sector> list = this.polygon.getSectors(drawContext);
        if (list != null) {
            Sector sector = list.get(0);
            return new Position(sector.getCentroid(), 0.0);
        }
        return this.getReferencePosition();
    }

    protected void determineIdentityLabelPositions() {
        Iterator<? extends Position> iterator = this.getPositions().iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        LatLon latLon = LatLon.interpolate(0.5, position, position2);
        if (this.identityLabel1 != null) {
            this.identityLabel1.setPosition(new Position(latLon, 0.0));
        }
        int n = this.getPositionCount();
        iterator = this.getPositions().iterator();
        for (int i = 0; i < n / 2 + 1; ++i) {
            position = iterator.next();
        }
        position2 = iterator.next();
        latLon = LatLon.interpolate(0.5, position, position2);
        if (this.identityLabel2 != null) {
            this.identityLabel2.setPosition(new Position(latLon, 0.0));
        }
    }

    protected int getPositionCount() {
        int n = 0;
        for (Position position : this.getPositions()) {
            ++n;
        }
        return n;
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.polygon.setDelegateOwner(object);
    }

    protected SurfacePolygon createPolygon() {
        SurfacePolygon surfacePolygon = new SurfacePolygon();
        surfacePolygon.setDelegateOwner(this.getActiveDelegateOwner());
        surfacePolygon.setAttributes(this.getActiveShapeAttributes());
        return surfacePolygon;
    }
}

