/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.render.markers.MarkerShape;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import javax.media.opengl.glu.gl2.GLUgl2;

public class BasicMarkerShape {
    public static final String SPHERE = "gov.nasa.worldwind.render.markers.Sphere";
    public static final String CUBE = "gov.nasa.worldwind.render.markers.Cube";
    public static final String CONE = "gov.nasa.worldwind.render.markers.Cone";
    public static final String CYLINDER = "gov.nasa.worldwind.render.markers.Cylinder";
    public static final String HEADING_ARROW = "gov.nasa.worldwind.render.markers.HeadingArrow";
    public static final String HEADING_LINE = "gov.nasa.worldwind.render.markers.HeadingLine";
    public static final String ORIENTED_SPHERE = "gov.nasa.worldwind.render.markers.DirectionalSphere";
    public static final String ORIENTED_CUBE = "gov.nasa.worldwind.render.markers.DirectionalCube";
    public static final String ORIENTED_CONE = "gov.nasa.worldwind.render.markers.DirectionalCone";
    public static final String ORIENTED_CYLINDER = "gov.nasa.worldwind.render.markers.DirectionalCylinder";
    public static final String ORIENTED_SPHERE_LINE = "gov.nasa.worldwind.render.markers.DirectionalSphereLine";
    public static final String ORIENTED_CONE_LINE = "gov.nasa.worldwind.render.markers.DirectionalConeLine";
    public static final String ORIENTED_CYLINDER_LINE = "gov.nasa.worldwind.render.markers.DirectionalCylinderLine";

    public static MarkerShape createShapeInstance(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == SPHERE) {
            return new Sphere();
        }
        if (string == CUBE) {
            return new Cube();
        }
        if (string == CONE) {
            return new Cone();
        }
        if (string == CYLINDER) {
            return new Cylinder();
        }
        if (string == HEADING_ARROW) {
            return new HeadingArrow();
        }
        if (string == HEADING_LINE) {
            return new HeadingLine();
        }
        if (string == ORIENTED_SPHERE) {
            return new CompoundShape(ORIENTED_SPHERE, "Oriented Sphere", new Sphere(), new HeadingArrow());
        }
        if (string == ORIENTED_CUBE) {
            Cube cube = new Cube();
            cube.setApplyOrientation(false);
            return new CompoundShape(ORIENTED_CUBE, "Oriented Cube", cube, new HeadingArrow(), 0.6);
        }
        if (string == ORIENTED_CONE) {
            Cone cone = new Cone();
            cone.setApplyOrientation(false);
            return new CompoundShape(ORIENTED_CONE, "Oriented Cone", cone, new HeadingArrow(), 0.6);
        }
        if (string == ORIENTED_CYLINDER) {
            Cylinder cylinder = new Cylinder();
            cylinder.setApplyOrientation(false);
            return new CompoundShape(ORIENTED_CYLINDER, "Oriented Cylinder", cylinder, new HeadingArrow(), 0.6);
        }
        if (string == ORIENTED_SPHERE_LINE) {
            return new CompoundShape(ORIENTED_SPHERE_LINE, "Oriented Sphere Line", new Sphere(), new HeadingLine(), 1.0);
        }
        if (string == ORIENTED_CONE_LINE) {
            Cone cone = new Cone();
            cone.setApplyOrientation(false);
            return new CompoundShape(ORIENTED_CONE_LINE, "Oriented Cone Line", cone, new HeadingLine(), 2.0);
        }
        if (string == ORIENTED_CYLINDER_LINE) {
            Cylinder cylinder = new Cylinder();
            cylinder.setApplyOrientation(false);
            return new CompoundShape(ORIENTED_CYLINDER_LINE, "Oriented Cylinder Line", cylinder, new HeadingLine(), 2.0);
        }
        return new Sphere();
    }

    protected static class HeadingArrow
    extends Shape {
        protected HeadingArrow() {
        }

        @Override
        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Heading Arrow";
            this.shapeType = BasicMarkerShape.HEADING_ARROW;
            this.isInitialized = true;
        }

        @Override
        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d, int[] nArray) {
            GL2 gL2 = drawContext.getGL().getGL2();
            MarkerAttributes markerAttributes = marker.getAttributes();
            if (marker.getHeading() == null) {
                return;
            }
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                if (markerAttributes.getOpacity() < 1.0) {
                    markerAttributes.getHeadingMaterial().apply(gL2, 1028, (float)markerAttributes.getOpacity());
                } else {
                    markerAttributes.getHeadingMaterial().apply(gL2, 1028);
                }
            }
            Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, marker.getHeading(), Angle.fromDegrees(0.1));
            Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), position.getElevation());
            Vec4 vec43 = vec42.subtract3(vec4).normalize3();
            Angle angle = Angle.fromRadians(Math.acos(vec43.z));
            double d2 = -vec43.y;
            double d3 = vec43.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            Vec4 vec44 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4).cross3(vec43);
            Vec4 vec45 = Vec4.UNIT_X.transformBy3(Matrix.fromAxisAngle(angle, d2 / d4, d3 / d4, 0.0));
            Angle angle2 = vec45.angleBetween3(vec44);
            double d5 = Math.signum(-vec44.cross3(vec45).dot3(vec43));
            gL2.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            gL2.glRotated(angle2.degrees, 0.0, 0.0, d5);
            double d6 = markerAttributes.getHeadingScale() * d;
            gL2.glScaled(d6, d6, d6);
            gL2.glCallList(nArray[0]);
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                markerAttributes.apply(drawContext);
            }
        }

        @Override
        protected int drawShape(DrawContext drawContext, double d) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glBegin(9);
            gL2.glNormal3f(0.0f, 1.0f, 0.0f);
            gL2.glVertex3f(-0.5f, 0.0f, 0.0f);
            gL2.glVertex3f(0.0f, 0.0f, 1.0f);
            gL2.glVertex3f(0.5f, 0.0f, 0.0f);
            gL2.glVertex3f(-0.5f, 0.0f, 0.0f);
            gL2.glEnd();
            return 60;
        }
    }

    protected static class HeadingLine
    extends Shape {
        protected HeadingLine() {
        }

        @Override
        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Heading Line";
            this.shapeType = BasicMarkerShape.HEADING_LINE;
            this.isInitialized = true;
        }

        @Override
        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d, int[] nArray) {
            GL2 gL2 = drawContext.getGL().getGL2();
            MarkerAttributes markerAttributes = marker.getAttributes();
            if (marker.getHeading() == null) {
                return;
            }
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                if (markerAttributes.getOpacity() < 1.0) {
                    markerAttributes.getHeadingMaterial().apply(gL2, 1028, (float)markerAttributes.getOpacity());
                } else {
                    markerAttributes.getHeadingMaterial().apply(gL2, 1028);
                }
            }
            Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, marker.getHeading(), Angle.fromDegrees(0.1));
            Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), position.getElevation());
            Vec4 vec43 = vec42.subtract3(vec4).normalize3();
            Angle angle = Angle.fromRadians(Math.acos(vec43.z));
            double d2 = -vec43.y;
            double d3 = vec43.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            gL2.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            double d5 = markerAttributes.getHeadingScale() * d;
            gL2.glScaled(d5, d5, d5);
            gL2.glCallList(nArray[0]);
            if (!drawContext.isPickingMode() && markerAttributes.getHeadingMaterial() != null && !markerAttributes.getHeadingMaterial().equals(markerAttributes.getMaterial())) {
                markerAttributes.apply(drawContext);
            }
        }

        @Override
        protected int drawShape(DrawContext drawContext, double d) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glBegin(3);
            gL2.glNormal3f(0.0f, 1.0f, 0.0f);
            gL2.glVertex3f(0.0f, 0.0f, 0.0f);
            gL2.glVertex3f(0.0f, 0.0f, 1.0f);
            gL2.glEnd();
            return 36;
        }
    }

    protected static class Cylinder
    extends Shape {
        protected Cylinder() {
        }

        @Override
        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cylinder";
            this.shapeType = BasicMarkerShape.CYLINDER;
            this.isInitialized = true;
        }

        @Override
        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d, int[] nArray) {
            Vec4 vec42 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4);
            if (this.isApplyOrientation() && marker.getPitch() != null) {
                vec42 = this.computeOrientationVector(drawContext, vec4, vec42, marker.getHeading() != null ? marker.getHeading() : Angle.ZERO, marker.getPitch());
            }
            Angle angle = Angle.fromRadians(Math.acos(vec42.z));
            double d2 = -vec42.y;
            double d3 = vec42.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            gL2.glScaled(d, d, d);
            gL2.glCallList(nArray[0]);
        }

        @Override
        protected int drawShape(DrawContext drawContext, double d) {
            int n = 20;
            boolean bl = true;
            int n2 = 1;
            GL2 gL2 = drawContext.getGL().getGL2();
            GLU gLU = drawContext.getGLU();
            gLU.gluCylinder(this.quadric, 1.0, 1.0, 2.0, n, (int)(2.0 * Math.sqrt((double)bl) + 1.0));
            gLU.gluDisk(this.quadric, 0.0, 1.0, n, n2);
            gL2.glTranslated(0.0, 0.0, 2.0);
            gLU.gluDisk(this.quadric, 0.0, 1.0, n, n2);
            gL2.glTranslated(0.0, 0.0, -2.0);
            return n * 2 * 6 * 4;
        }
    }

    protected static class Cone
    extends Shape {
        protected Cone() {
        }

        @Override
        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cone";
            this.shapeType = BasicMarkerShape.CONE;
            this.isInitialized = true;
        }

        @Override
        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d, int[] nArray) {
            Vec4 vec42 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4);
            if (this.isApplyOrientation() && marker.getPitch() != null) {
                vec42 = this.computeOrientationVector(drawContext, vec4, vec42, marker.getHeading() != null ? marker.getHeading() : Angle.ZERO, marker.getPitch());
            }
            Angle angle = Angle.fromRadians(Math.acos(vec42.z));
            double d2 = -vec42.y;
            double d3 = vec42.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            gL2.glScaled(d, d, d);
            gL2.glCallList(nArray[0]);
        }

        @Override
        protected int drawShape(DrawContext drawContext, double d) {
            int n = 20;
            int n2 = 20;
            int n3 = 2;
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluCylinder(this.quadric, 1.0, 0.0, 2.0, n, (int)(2.0 * Math.sqrt(n2) + 1.0));
            drawContext.getGLU().gluDisk(this.quadric, 0.0, 1.0, n, n3);
            return (n + n2 + n * n3) * 6 * 4;
        }
    }

    protected static class Cube
    extends Shape {
        protected Cube() {
        }

        @Override
        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Cube";
            this.shapeType = BasicMarkerShape.CUBE;
            this.isInitialized = true;
        }

        @Override
        protected int drawShape(DrawContext drawContext, double d) {
            float[][] fArrayArray = new float[][]{{-1.0f, 1.0f, 0.0f}, {-1.0f, 1.0f, 2.0f}, {1.0f, 1.0f, 2.0f}, {1.0f, 1.0f, 0.0f}, {-1.0f, -1.0f, 2.0f}, {1.0f, -1.0f, 2.0f}, {1.0f, -1.0f, 0.0f}, {-1.0f, -1.0f, 0.0f}};
            int[][] nArrayArray = new int[][]{{0, 1, 2, 3}, {2, 5, 6, 3}, {1, 4, 5, 2}, {0, 7, 4, 1}, {0, 7, 6, 3}, {4, 7, 6, 5}};
            float[][] fArrayArray2 = new float[][]{{0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, -1.0f, 0.0f}};
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glBegin(7);
            for (int i = 0; i < nArrayArray.length; ++i) {
                gL2.glNormal3f(fArrayArray2[i][0], fArrayArray2[i][1], fArrayArray2[i][2]);
                for (int j = 0; j < nArrayArray[0].length; ++j) {
                    gL2.glVertex3f(fArrayArray[nArrayArray[i][j]][0], fArrayArray[nArrayArray[i][j]][1], fArrayArray[nArrayArray[i][j]][2]);
                }
            }
            gL2.glEnd();
            return 144;
        }

        @Override
        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d, int[] nArray) {
            Vec4 vec42 = drawContext.getGlobe().computeSurfaceNormalAtPoint(vec4);
            Angle angle = Angle.fromRadians(Math.acos(vec42.z));
            double d2 = -vec42.y;
            double d3 = vec42.x;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
            Vec4 vec43 = drawContext.getGlobe().computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude());
            Vec4 vec44 = Vec4.UNIT_NEGATIVE_Y.transformBy3(Matrix.fromAxisAngle(angle, d2 / d4, d3 / d4, 0.0));
            Angle angle2 = vec44.angleBetween3(vec43);
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glRotated(angle.degrees, d2 / d4, d3 / d4, 0.0);
            gL2.glRotated(angle2.degrees, 0.0, 0.0, 1.0);
            if (this.isApplyOrientation()) {
                if (marker.getHeading() != null) {
                    gL2.glRotated(-marker.getHeading().degrees, 0.0, 0.0, 1.0);
                }
                if (marker.getPitch() != null) {
                    gL2.glRotated(marker.getPitch().degrees, 1.0, 0.0, 0.0);
                }
                if (marker.getRoll() != null) {
                    gL2.glRotated(marker.getRoll().degrees, 0.0, 0.0, 1.0);
                }
            }
            gL2.glScaled(d, d, d);
            gL2.glCallList(nArray[0]);
        }
    }

    protected static class Sphere
    extends Shape {
        protected Sphere() {
        }

        @Override
        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Sphere";
            this.shapeType = BasicMarkerShape.SPHERE;
            this.isInitialized = true;
        }

        @Override
        protected void doRender(DrawContext drawContext, Marker marker, Vec4 vec4, double d, int[] nArray) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glScaled(d, d, d);
            gL2.glCallList(nArray[0]);
        }

        @Override
        protected int drawShape(DrawContext drawContext, double d) {
            int n = 24;
            int n2 = 12;
            drawContext.getGLU().gluSphere(this.quadric, 1.0, n, n2);
            return n * n2 * 6 * 4;
        }
    }

    protected static abstract class Shape
    implements MarkerShape,
    Disposable {
        protected String name;
        protected String shapeType;
        protected GLUquadric quadric;
        protected boolean isInitialized = false;
        protected Object displayListCacheKey = new Object();
        protected boolean applyOrientation = true;

        protected Shape() {
        }

        protected abstract void doRender(DrawContext var1, Marker var2, Vec4 var3, double var4, int[] var6);

        protected abstract int drawShape(DrawContext var1, double var2);

        protected void initialize(DrawContext drawContext) {
            this.quadric = drawContext.getGLU().gluNewQuadric();
            drawContext.getGLU().gluQuadricDrawStyle(this.quadric, 100012);
            drawContext.getGLU().gluQuadricNormals(this.quadric, 100000);
            drawContext.getGLU().gluQuadricOrientation(this.quadric, 100020);
            drawContext.getGLU().gluQuadricTexture(this.quadric, false);
        }

        @Override
        public void dispose() {
            if (this.isInitialized) {
                GLUgl2 gLUgl2 = new GLUgl2();
                gLUgl2.gluDeleteQuadric(this.quadric);
                this.isInitialized = false;
            }
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getShapeType() {
            return this.shapeType;
        }

        public boolean isApplyOrientation() {
            return this.applyOrientation;
        }

        public void setApplyOrientation(boolean bl) {
            this.applyOrientation = bl;
        }

        @Override
        public void render(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            this.render(drawContext, marker, vec4, d, true);
        }

        @Override
        public void render(DrawContext drawContext, Marker marker, Vec4 vec4, double d, boolean bl) {
            if (!this.isInitialized) {
                this.initialize(drawContext);
            }
            GL2 gL2 = drawContext.getGL().getGL2();
            if (!bl) {
                drawContext.getView().pushReferenceCenter(drawContext, vec4);
            } else {
                gL2.glPushMatrix();
                gL2.glTranslated(vec4.x, vec4.y, vec4.z);
            }
            int[] nArray = (int[])drawContext.getGpuResourceCache().get(this.displayListCacheKey);
            if (nArray == null) {
                nArray = this.createDisplayList(drawContext, d);
            }
            this.doRender(drawContext, marker, vec4, d, nArray);
            if (!bl) {
                drawContext.getView().popReferenceCenter(drawContext);
            } else {
                gL2.glPopMatrix();
            }
        }

        protected Vec4 computeOrientationVector(DrawContext drawContext, Vec4 vec4, Vec4 vec42, Angle angle, Angle angle2) {
            Globe globe = drawContext.getGlobe();
            Position position = globe.computePositionFromPoint(vec4);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle, Angle.fromDegrees(0.1));
            Vec4 vec43 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), position.getElevation());
            Vec4 vec44 = vec43.subtract3(vec4).normalize3();
            Vec4 vec45 = vec42.cross3(vec44);
            return vec42.transformBy3(Matrix.fromAxisAngle(angle2, vec45));
        }

        protected int[] createDisplayList(DrawContext drawContext, double d) {
            int n;
            GL2 gL2 = drawContext.getGL().getGL2();
            int[] nArray = new int[]{gL2.glGenLists(1), 1};
            try {
                gL2.glNewList(nArray[0], 4864);
                n = this.drawShape(drawContext, d);
                gL2.glEndList();
            }
            catch (Exception exception) {
                gL2.glEndList();
                gL2.glDeleteLists(nArray[0], nArray[1]);
                return null;
            }
            drawContext.getGpuResourceCache().put(this.displayListCacheKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.DisplayList", n);
            return nArray;
        }
    }

    protected static class CompoundShape
    implements MarkerShape,
    Disposable {
        protected String name;
        protected String shapeType;
        protected ArrayList<MarkerShape> shapes = new ArrayList(2);
        protected double offset = 0.0;

        public CompoundShape(String string, String string2, MarkerShape markerShape, MarkerShape markerShape2) {
            this.name = string2;
            this.shapeType = string;
            this.shapes.add(markerShape);
            this.shapes.add(markerShape2);
        }

        public CompoundShape(String string, String string2, MarkerShape markerShape, MarkerShape markerShape2, double d) {
            this.name = string2;
            this.shapeType = string;
            this.shapes.add(markerShape);
            this.shapes.add(markerShape2);
            this.offset = d;
        }

        @Override
        public void dispose() {
            for (MarkerShape markerShape : this.shapes) {
                if (!(markerShape instanceof Disposable)) continue;
                ((Disposable)((Object)markerShape)).dispose();
            }
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getShapeType() {
            return this.shapeType;
        }

        @Override
        public void render(DrawContext drawContext, Marker marker, Vec4 vec4, double d) {
            this.shapes.get(0).render(drawContext, marker, vec4, d, false);
            if (this.offset != 0.0) {
                Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
                vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation() + d * this.offset);
            }
            this.shapes.get(1).render(drawContext, marker, vec4, d, false);
        }

        @Override
        public void render(DrawContext drawContext, Marker marker, Vec4 vec4, double d, boolean bl) {
            this.shapes.get(0).render(drawContext, marker, vec4, d, bl);
            if (this.offset != 0.0) {
                Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
                vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation() + d * this.offset);
            }
            this.shapes.get(1).render(drawContext, marker, vec4, d, bl);
        }
    }
}

