/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.Logging;

public class BasicMarker
implements Marker {
    protected Position position;
    protected Angle heading;
    protected Angle pitch;
    protected Angle roll;
    protected MarkerAttributes attributes;

    public BasicMarker(Position position, MarkerAttributes markerAttributes) {
        if (markerAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.attributes = markerAttributes;
    }

    public BasicMarker(Position position, MarkerAttributes markerAttributes, Angle angle) {
        if (markerAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.heading = angle;
        this.attributes = markerAttributes;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public Angle getHeading() {
        return this.heading;
    }

    @Override
    public void setHeading(Angle angle) {
        this.heading = angle;
    }

    @Override
    public Angle getRoll() {
        return this.roll;
    }

    @Override
    public void setRoll(Angle angle) {
        this.roll = angle;
    }

    @Override
    public Angle getPitch() {
        return this.pitch;
    }

    @Override
    public void setPitch(Angle angle) {
        this.pitch = angle;
    }

    @Override
    public MarkerAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(MarkerAttributes markerAttributes) {
        this.attributes = markerAttributes;
    }

    @Override
    public void render(DrawContext drawContext, Vec4 vec4, double d, boolean bl) {
        this.attributes.getShape(drawContext).render(drawContext, this, vec4, d, bl);
    }

    @Override
    public void render(DrawContext drawContext, Vec4 vec4, double d) {
        this.attributes.getShape(drawContext).render(drawContext, this, vec4, d, false);
    }
}

