/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.AbstractAnnotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.GL;

public class GlobeAnnotation
extends AbstractAnnotation
implements Locatable,
Movable {
    protected Position position;
    protected double heightInMeter = 0.0;
    protected Integer altitudeMode;

    public GlobeAnnotation(String string, Position position) {
        this.init(string, position, null, null);
    }

    public GlobeAnnotation(String string, Position position, Font font) {
        this.init(string, position, font, null);
    }

    public GlobeAnnotation(String string, Position position, Font font, Color color) {
        this.init(string, position, font, color);
    }

    public GlobeAnnotation(String string, Position position, AnnotationAttributes annotationAttributes) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (annotationAttributes == null) {
            String string4 = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setText(string);
        this.position = position;
        this.getAttributes().setDefaults(annotationAttributes);
    }

    private void init(String string, Position position, Font font, Color color) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.setText(string);
        this.position = position;
        this.getAttributes().setFont(font);
        this.getAttributes().setTextColor(color);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Integer getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(Integer n) {
        this.altitudeMode = n;
    }

    public double getHeightInMeter() {
        return this.heightInMeter;
    }

    public void setHeightInMeter(double d) {
        this.heightInMeter = d;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = this.position.add(position);
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    @Override
    public Position getReferencePosition() {
        return this.position;
    }

    @Override
    protected Rectangle computeBounds(DrawContext drawContext) {
        Vec4 vec4 = this.getAnnotationDrawPoint(drawContext);
        if (vec4 == null) {
            return null;
        }
        Vec4 vec42 = drawContext.getView().project(vec4);
        if (vec42 == null) {
            return null;
        }
        Dimension dimension = this.getPreferredSize(drawContext);
        double[] dArray = this.computeDistanceScaleAndOpacity(drawContext, vec4, dimension);
        double d = dArray[0] * this.computeScale(drawContext);
        Point point = this.getAttributes().getDrawOffset();
        double d2 = (double)point.x * d;
        double d3 = (double)point.y * d;
        double d4 = (double)dimension.width * d;
        double d5 = (double)dimension.height * d;
        double d6 = vec42.x - d4 / 2.0 + d2;
        double d7 = vec42.y + d3;
        Rectangle rectangle = new Rectangle((int)d6, (int)d7, (int)d4, (int)d5);
        return this.computeBoundingRectangle(rectangle, (int)vec42.x, (int)vec42.y);
    }

    @Override
    protected void doRenderNow(DrawContext drawContext) {
        if (drawContext.isPickingMode() && this.getPickSupport() == null) {
            return;
        }
        Vec4 vec4 = this.getAnnotationDrawPoint(drawContext);
        if (vec4 == null) {
            return;
        }
        if (drawContext.getView().getFrustumInModelCoordinates().getNear().distanceTo(vec4) < 0.0) {
            return;
        }
        Vec4 vec42 = drawContext.getView().project(vec4);
        if (vec42 == null) {
            return;
        }
        Dimension dimension = this.getPreferredSize(drawContext);
        Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
        double[] dArray = this.computeDistanceScaleAndOpacity(drawContext, vec4, dimension);
        this.setDepthFunc(drawContext, vec42);
        this.drawTopLevelAnnotation(drawContext, (int)vec42.x, (int)vec42.y, dimension.width, dimension.height, dArray[0], dArray[1], position);
    }

    protected double[] computeDistanceScaleAndOpacity(DrawContext drawContext, Vec4 vec4, Dimension dimension) {
        double d = 1.0;
        double d2 = 1.0;
        if (this.heightInMeter <= 0.0) {
            Double d3 = this.computeLookAtDistance(drawContext);
            if (d3 != null) {
                double d4 = drawContext.getView().getEyePoint().distanceTo3(vec4);
                double d5 = Math.sqrt(d3 / d4);
                d = WWMath.clamp(d5, this.attributes.getDistanceMinScale(), this.attributes.getDistanceMaxScale());
                d2 = WWMath.clamp(d5, this.attributes.getDistanceMinOpacity(), 1.0);
            }
        } else {
            double d6 = drawContext.getView().getEyePoint().distanceTo3(vec4);
            double d7 = drawContext.getView().computePixelSizeAtDistance(d6);
            double d8 = this.heightInMeter / d7;
            d = d8 / (double)dimension.height;
            d2 = WWMath.clamp(d, this.attributes.getDistanceMinOpacity(), 1.0);
        }
        return new double[]{d, d2};
    }

    protected Double computeLookAtDistance(DrawContext drawContext) {
        View view = drawContext.getView();
        Position position = view.computePositionFromScreenPoint(view.getViewport().getCenterX(), view.getViewport().getCenterY());
        if (position == null) {
            Rectangle rectangle = view.getViewport();
            double d = view.getViewport().getCenterY() + 1.0;
            while (position == null && d < (double)(rectangle.height - 1)) {
                double d2 = d;
                d = d2 + 1.0;
                position = view.computePositionFromScreenPoint(view.getViewport().getCenterX(), d2);
            }
        }
        if (position != null) {
            return view.getEyePoint().distanceTo3(drawContext.getGlobe().computePointFromPosition(position));
        }
        return null;
    }

    protected void setDepthFunc(DrawContext drawContext, Vec4 vec4) {
        GL gL = drawContext.getGL();
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else if (vec4.z >= 1.0) {
            gL.glDepthFunc(514);
            gL.glDepthRange(1.0, 1.0);
        } else {
            gL.glDepthFunc(519);
        }
    }

    public Vec4 getAnnotationDrawPoint(DrawContext drawContext) {
        Vec4 vec4;
        Position position = this.getPosition();
        Integer n = this.getAltitudeMode();
        if (n == null) {
            vec4 = this.getAnnotationDrawPointLegacy(drawContext);
        } else if (n == 1) {
            vec4 = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        } else if (n == 2) {
            vec4 = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), position.getAltitude());
        } else {
            double d = position.getElevation() * drawContext.getVerticalExaggeration();
            vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        }
        return vec4;
    }

    protected Vec4 getAnnotationDrawPointLegacy(DrawContext drawContext) {
        Vec4 vec4 = null;
        Position position = this.getPosition();
        if (position.getElevation() < drawContext.getGlobe().getMaxElevation()) {
            vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getElevation() * drawContext.getVerticalExaggeration());
        }
        if (vec4 == null) {
            vec4 = drawContext.getGlobe().computePointFromPosition(drawContext.getVerticalExaggeration() == 1.0 ? position : new Position(position, position.getElevation() * drawContext.getVerticalExaggeration()));
        }
        return vec4;
    }

    @Override
    public String getRestorableState() {
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport = null;
        String string = super.getRestorableState();
        if (string != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        if (this.position != null && this.position.getLatitude() != null && this.position.getLongitude() != null && (stateObject = restorableSupport.addStateObject("position")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "latitude", this.position.getLatitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject, "longitude", this.position.getLongitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject, "elevation", this.position.getElevation());
        }
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            super.restoreState(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("position");
        if (stateObject != null) {
            Double d = restorableSupport.getStateValueAsDouble(stateObject, "latitude");
            Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "longitude");
            Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "elevation");
            if (d != null && d3 != null) {
                this.setPosition(Position.fromDegrees(d, d2, d3));
            }
        }
    }
}

