/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;

public class BasicBalloonAttributes
extends BasicShapeAttributes
implements BalloonAttributes {
    protected Size size;
    protected Size maxSize;
    protected Offset offset;
    protected Insets insets;
    protected String balloonShape;
    protected String leaderShape;
    protected int leaderWidth;
    protected int cornerRadius;
    protected Font font;
    protected Color textColor;
    protected Point imageOffset;
    protected double imageOpacity;
    protected String imageRepeat;

    public BasicBalloonAttributes() {
        this.setOutlineMaterial(new Material(new Color(171, 171, 171)));
        this.setSize(Size.fromPixels(350, 350));
        this.setOffset(new Offset(0.45, -60.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Pixels"));
        this.setInsets(new Insets(30, 15, 15, 15));
        this.setBalloonShape("gov.nasa.worldwind.avkey.ShapeRectangle");
        this.setLeaderShape("gov.nasa.worldwind.avkey.ShapeTriangle");
        this.setLeaderWidth(40);
        this.setCornerRadius(20);
        this.setFont(Font.decode("Arial-PLAIN-12"));
        this.setTextColor(Color.BLACK);
        this.setImageOffset(new Point(0, 0));
        this.setImageOpacity(1.0);
        this.setImageRepeat("gov.nasa.worldwind.avkey.RepeatXY");
    }

    public BasicBalloonAttributes(BalloonAttributes balloonAttributes) {
        if (balloonAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.copy(balloonAttributes);
    }

    @Override
    public ShapeAttributes copy() {
        return new BasicBalloonAttributes(this);
    }

    @Override
    public void copy(ShapeAttributes shapeAttributes) {
        super.copy(shapeAttributes);
        if (shapeAttributes instanceof BalloonAttributes) {
            BalloonAttributes balloonAttributes = (BalloonAttributes)shapeAttributes;
            this.size = balloonAttributes.getSize();
            this.maxSize = balloonAttributes.getMaximumSize();
            this.offset = balloonAttributes.getOffset();
            this.insets = balloonAttributes.getInsets();
            this.balloonShape = balloonAttributes.getBalloonShape();
            this.leaderShape = balloonAttributes.getLeaderShape();
            this.leaderWidth = balloonAttributes.getLeaderWidth();
            this.cornerRadius = balloonAttributes.getCornerRadius();
            this.font = balloonAttributes.getFont();
            this.textColor = balloonAttributes.getTextColor();
            this.imageOffset = balloonAttributes.getImageOffset();
            this.imageOpacity = balloonAttributes.getImageOpacity();
            this.imageRepeat = balloonAttributes.getImageRepeat();
        }
    }

    @Override
    public String getBalloonShape() {
        return this.balloonShape;
    }

    @Override
    public void setBalloonShape(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.balloonShape = string;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public void setSize(Size size) {
        if (size == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.size = size;
    }

    @Override
    public Size getMaximumSize() {
        return this.maxSize;
    }

    @Override
    public void setMaximumSize(Size size) {
        this.maxSize = size;
    }

    @Override
    public String getLeaderShape() {
        return this.leaderShape;
    }

    @Override
    public void setLeaderShape(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.leaderShape = string;
    }

    @Override
    public int getLeaderWidth() {
        return this.leaderWidth;
    }

    @Override
    public void setLeaderWidth(int n) {
        if (n < 0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.leaderWidth = n;
    }

    @Override
    public int getCornerRadius() {
        return this.cornerRadius;
    }

    @Override
    public void setCornerRadius(int n) {
        if (n < 0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.cornerRadius = n;
    }

    @Override
    public Offset getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(Offset offset) {
        if (offset == null) {
            String string = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.offset = offset;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void setInsets(Insets insets) {
        if (insets == null) {
            String string = Logging.getMessage("nullValue.InsetsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.insets = insets;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.font = font;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textColor = color;
    }

    @Override
    public Point getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public void setImageOffset(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageOffset = point;
    }

    @Override
    public double getImageOpacity() {
        return this.imageOpacity;
    }

    @Override
    public void setImageOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageOpacity = d;
    }

    @Override
    public String getImageRepeat() {
        return this.imageRepeat;
    }

    @Override
    public void setImageRepeat(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.imageRepeat = string;
    }

    @Override
    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        Size size;
        if (restorableSupport == null) {
            String string2 = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        super.getRestorableState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "size");
        if (stateObject2 != null) {
            this.getSize().getRestorableState(restorableSupport, stateObject2);
        }
        if ((size = this.getMaximumSize()) != null && (stateObject2 = restorableSupport.addStateObject(stateObject, "maxSize")) != null) {
            this.getMaximumSize().getRestorableState(restorableSupport, stateObject2);
        }
        if ((stateObject2 = restorableSupport.addStateObject(stateObject, "drawOffset")) != null) {
            this.getOffset().getRestorableState(restorableSupport, stateObject2);
        }
        if ((stateObject2 = restorableSupport.addStateObject(stateObject, "insets")) != null) {
            restorableSupport.addStateValueAsInteger(stateObject2, "top", this.getInsets().top);
            restorableSupport.addStateValueAsInteger(stateObject2, "left", this.getInsets().left);
            restorableSupport.addStateValueAsInteger(stateObject2, "bottom", this.getInsets().bottom);
            restorableSupport.addStateValueAsInteger(stateObject2, "right", this.getInsets().right);
        }
        restorableSupport.addStateValueAsString(stateObject, "balloonShape", this.getBalloonShape());
        restorableSupport.addStateValueAsString(stateObject, "leader", this.getLeaderShape());
        restorableSupport.addStateValueAsInteger(stateObject, "leaderGapWidth", this.getLeaderWidth());
        restorableSupport.addStateValueAsInteger(stateObject, "cornerRadius", this.getCornerRadius());
        stateObject2 = restorableSupport.addStateObject(stateObject, "font");
        if (stateObject2 != null) {
            restorableSupport.addStateValueAsString(stateObject2, "name", this.getFont().getName());
            restorableSupport.addStateValueAsInteger(stateObject2, "style", this.getFont().getStyle());
            restorableSupport.addStateValueAsInteger(stateObject2, "size", this.getFont().getSize());
        }
        if ((string = RestorableSupport.encodeColor(this.getTextColor())) != null) {
            restorableSupport.addStateValueAsString(stateObject, "textColor", string);
        }
        if ((stateObject2 = restorableSupport.addStateObject(stateObject, "imageOffset")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject2, "x", this.getImageOffset().getX());
            restorableSupport.addStateValueAsDouble(stateObject2, "y", this.getImageOffset().getY());
        }
        restorableSupport.addStateValueAsDouble(stateObject, "imageOpacity", this.getImageOpacity());
        restorableSupport.addStateValueAsString(stateObject, "imageRepeat", this.getImageRepeat());
    }

    @Override
    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Number number;
        Object object;
        Object object2;
        Object object3;
        if (restorableSupport == null) {
            String string = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.restoreState(restorableSupport, stateObject);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Render.FrameFactory.ShapeRectangle", "gov.nasa.worldwind.avkey.ShapeRectangle");
        hashMap.put("Render.FrameFactory.ShapeEllipse", "gov.nasa.worldwind.avkey.ShapeEllipse");
        hashMap.put("Render.FrameFactory.ShapeNone", "gov.nasa.worldwind.avkey.ShapeNone");
        hashMap.put("Render.FrameFactory.LeaderTriangle", "gov.nasa.worldwind.avkey.ShapeTriangle");
        hashMap.put("Render.FrameFactory.LeaderNone", "gov.nasa.worldwind.avkey.ShapeNone");
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "size");
        if (stateObject2 != null) {
            this.getSize().restoreState(restorableSupport, stateObject2);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "maxSize")) != null) {
            object3 = new Size();
            ((Size)object3).restoreState(restorableSupport, stateObject2);
            this.setMaximumSize((Size)object3);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "drawOffset")) != null) {
            this.getOffset().restoreState(restorableSupport, stateObject2);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "insets")) != null) {
            object3 = restorableSupport.getStateValueAsInteger(stateObject2, "top");
            object2 = restorableSupport.getStateValueAsInteger(stateObject2, "left");
            object = restorableSupport.getStateValueAsInteger(stateObject2, "bottom");
            number = restorableSupport.getStateValueAsInteger(stateObject2, "right");
            if (object3 != null && object2 != null && object != null && number != null) {
                this.setInsets(new Insets((Integer)object3, (Integer)object2, (Integer)object, (Integer)number));
            }
        }
        if ((object3 = restorableSupport.getStateValueAsString(stateObject, "balloonShape")) != null) {
            object2 = (String)hashMap.get(object3);
            if (object2 != null) {
                object3 = object2;
            }
            this.setBalloonShape((String)object3);
        }
        if ((object3 = restorableSupport.getStateValueAsString(stateObject, "leader")) != null) {
            object2 = (String)hashMap.get(object3);
            if (object2 != null) {
                object3 = object2;
            }
            this.setLeaderShape((String)object3);
        }
        if ((object2 = restorableSupport.getStateValueAsInteger(stateObject, "leaderGapWidth")) != null) {
            this.setLeaderWidth((Integer)object2);
        }
        if ((object2 = restorableSupport.getStateValueAsInteger(stateObject, "cornerRadius")) != null) {
            this.setCornerRadius((Integer)object2);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "font")) != null) {
            object = restorableSupport.getStateValueAsString(stateObject2, "name");
            number = restorableSupport.getStateValueAsInteger(stateObject2, "style");
            Integer n = restorableSupport.getStateValueAsInteger(stateObject2, "size");
            if (object != null && number != null && n != null) {
                this.setFont(new Font((String)object, ((Integer)number).intValue(), n));
            }
        }
        if ((object3 = restorableSupport.getStateValueAsString(stateObject, "textColor")) != null && (object = RestorableSupport.decodeColor((String)object3)) != null) {
            this.setTextColor((Color)object);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "imageOffset")) != null) {
            object = restorableSupport.getStateValueAsDouble(stateObject2, "x");
            number = restorableSupport.getStateValueAsDouble(stateObject2, "y");
            if (object != null && number != null) {
                this.setImageOffset(new Point(((Double)object).intValue(), ((Double)number).intValue()));
            }
        }
        if ((object = restorableSupport.getStateValueAsDouble(stateObject, "imageOpacity")) != null) {
            this.setImageOpacity((Double)object);
        }
        if ((object3 = restorableSupport.getStateValueAsString(stateObject, "imageRepeat")) != null) {
            this.setImageRepeat((String)object3);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BasicBalloonAttributes basicBalloonAttributes = (BasicBalloonAttributes)object;
        if (this.size != null ? !this.size.equals(basicBalloonAttributes.size) : basicBalloonAttributes.size != null) {
            return false;
        }
        if (this.maxSize != null ? !this.maxSize.equals(basicBalloonAttributes.maxSize) : basicBalloonAttributes.maxSize != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(basicBalloonAttributes.offset) : basicBalloonAttributes.offset != null) {
            return false;
        }
        if (this.insets != null ? !this.insets.equals(basicBalloonAttributes.insets) : basicBalloonAttributes.insets != null) {
            return false;
        }
        if (this.balloonShape != null ? !this.balloonShape.equals(basicBalloonAttributes.balloonShape) : basicBalloonAttributes.balloonShape != null) {
            return false;
        }
        if (this.leaderShape != null ? !this.leaderShape.equals(basicBalloonAttributes.leaderShape) : basicBalloonAttributes.leaderShape != null) {
            return false;
        }
        if (this.leaderWidth != basicBalloonAttributes.leaderWidth) {
            return false;
        }
        if (this.cornerRadius != basicBalloonAttributes.cornerRadius) {
            return false;
        }
        if (this.font != null ? !this.font.equals(basicBalloonAttributes.font) : basicBalloonAttributes.font != null) {
            return false;
        }
        if (this.textColor != null ? !this.textColor.equals(basicBalloonAttributes.textColor) : basicBalloonAttributes.textColor != null) {
            return false;
        }
        if (this.imageOffset != null ? !this.imageOffset.equals(basicBalloonAttributes.imageOffset) : basicBalloonAttributes.imageOffset != null) {
            return false;
        }
        if (Double.compare(this.imageOpacity, basicBalloonAttributes.imageOpacity) != 0) {
            return false;
        }
        return !(this.imageRepeat != null ? !this.imageRepeat.equals(basicBalloonAttributes.imageRepeat) : basicBalloonAttributes.imageRepeat != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.size != null ? this.size.hashCode() : 0);
        n = 31 * n + (this.maxSize != null ? this.maxSize.hashCode() : 0);
        n = 31 * n + (this.offset != null ? this.offset.hashCode() : 0);
        n = 31 * n + (this.insets != null ? this.insets.hashCode() : 0);
        n = 31 * n + (this.balloonShape != null ? this.balloonShape.hashCode() : 0);
        n = 31 * n + (this.leaderShape != null ? this.leaderShape.hashCode() : 0);
        n = 31 * n + this.leaderWidth;
        n = 31 * n + this.cornerRadius;
        n = 31 * n + (this.font != null ? this.font.hashCode() : 0);
        n = 31 * n + (this.textColor != null ? this.textColor.hashCode() : 0);
        n = 31 * n + (this.imageOffset != null ? this.imageOffset.hashCode() : 0);
        long l = this.imageOpacity != 0.0 ? Double.doubleToLongBits(this.imageOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.imageRepeat != null ? this.imageRepeat.hashCode() : 0);
        return n;
    }
}

