/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.io;

import gov.nasa.worldwind.ogc.kml.io.KMLDoc;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class KMZFile
implements KMLDoc {
    protected ZipFile zipFile;
    protected Map<String, File> files = new HashMap<String, File>();
    protected File tempDir;

    public KMZFile(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zipFile = new ZipFile(file);
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public synchronized InputStream getKMLStream() throws IOException {
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().toLowerCase().endsWith(".kml")) continue;
            return this.zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    @Override
    public synchronized InputStream getSupportFileStream(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equals(string)) continue;
            return this.zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    @Override
    public synchronized String getSupportFilePath(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = this.files.get(string);
        if (file != null) {
            return file.getPath();
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equals(string)) continue;
            return this.copyEntryToTempDir(zipEntry);
        }
        return null;
    }

    protected String copyEntryToTempDir(ZipEntry zipEntry) throws IOException {
        if (zipEntry.isDirectory()) {
            return null;
        }
        if (this.tempDir == null) {
            this.tempDir = WWIO.makeTempDir();
        }
        if (this.tempDir == null) {
            String string = Logging.getMessage("generic.UnableToCreateTempDir", this.tempDir);
            Logging.logger().warning(string);
            return null;
        }
        String string = this.tempDir + File.separator + zipEntry.getName();
        WWIO.makeParentDirs(string);
        File file = new File(string);
        file.deleteOnExit();
        WWIO.saveBuffer(WWIO.readStreamToBuffer(this.zipFile.getInputStream(zipEntry), true), file);
        this.files.put(zipEntry.getName(), file);
        return file.getPath();
    }
}

