/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLAbstractStyleSelector;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLPair;
import gov.nasa.worldwind.ogc.kml.KMLStyleUrl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLStyleMap
extends KMLAbstractStyleSelector {
    protected List<KMLPair> pairs = new ArrayList<KMLPair>();

    public KMLStyleMap(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLPair) {
            this.addPair((KMLPair)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public List<KMLPair> getPairs() {
        return this.pairs;
    }

    protected void addPair(KMLPair kMLPair) {
        this.pairs.add(kMLPair);
    }

    public KMLAbstractStyleSelector getStyleFromMap(String string) {
        if (string == null) {
            string = "normal";
        }
        for (KMLPair kMLPair : this.pairs) {
            if (!kMLPair.getKey().equals(string)) continue;
            return kMLPair.getStyleSelector();
        }
        return null;
    }

    public KMLStyleUrl getStyleUrlFromMap(String string) {
        if (string == null) {
            string = "normal";
        }
        for (KMLPair kMLPair : this.pairs) {
            if (!kMLPair.getKey().equals(string)) continue;
            return kMLPair.getStyleUrl();
        }
        return null;
    }

    public KMLAbstractSubStyle mergeSubStyles(KMLAbstractSubStyle kMLAbstractSubStyle, String string) {
        KMLStyleUrl kMLStyleUrl = this.getStyleUrlFromMap(string);
        KMLAbstractStyleSelector kMLAbstractStyleSelector = this.getStyleFromMap(string);
        if (kMLAbstractStyleSelector == null && kMLStyleUrl == null) {
            return kMLAbstractSubStyle;
        }
        kMLAbstractSubStyle.setField("styleState", (Object)string);
        return KMLAbstractStyleSelector.mergeSubStyles(kMLStyleUrl, kMLAbstractStyleSelector, string, kMLAbstractSubStyle);
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLStyleMap)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        super.applyChange(kMLAbstractObject);
        KMLStyleMap kMLStyleMap = (KMLStyleMap)kMLAbstractObject;
        if (kMLStyleMap.getPairs() != null && kMLStyleMap.getPairs().size() > 0) {
            this.pairs = kMLStyleMap.getPairs();
        }
        this.onChange(new Message("KMLAbstractObject.StyleChanged", this));
    }

    protected void mergePairs(KMLStyleMap kMLStyleMap) {
        ArrayList arrayList = new ArrayList(this.getPairs().size());
        Collections.copy(arrayList, this.getPairs());
        for (KMLPair kMLPair : kMLStyleMap.getPairs()) {
            String string = kMLPair.getId();
            if (!WWUtil.isEmpty(string)) {
                for (KMLPair kMLPair2 : arrayList) {
                    String string2 = kMLPair2.getId();
                    if (WWUtil.isEmpty(string2) || !string2.equals(string)) continue;
                    this.getPairs().remove(kMLPair2);
                }
            }
            this.getPairs().add(kMLPair);
        }
    }
}

