/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLLineString;
import gov.nasa.worldwind.ogc.kml.KMLLinearRing;
import gov.nasa.worldwind.ogc.kml.KMLModel;
import gov.nasa.worldwind.ogc.kml.KMLMultiGeometry;
import gov.nasa.worldwind.ogc.kml.KMLPoint;
import gov.nasa.worldwind.ogc.kml.KMLPolygon;
import gov.nasa.worldwind.ogc.kml.KMLSimpleData;
import gov.nasa.worldwind.ogc.kml.impl.KMLExtrudedPolygonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLLineStringPlacemarkImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLModelPlacemarkImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLPointPlacemarkImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLPolygonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLSurfacePolygonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLPlacemark
extends KMLAbstractFeature {
    protected KMLAbstractGeometry geometry;
    protected List<KMLRenderable> renderables;

    public KMLPlacemark(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLAbstractGeometry) {
            this.setGeometry((KMLAbstractGeometry)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void setGeometry(KMLAbstractGeometry kMLAbstractGeometry) {
        this.geometry = kMLAbstractGeometry;
    }

    public KMLAbstractGeometry getGeometry() {
        return this.geometry;
    }

    public KMLSimpleData getSimpleData() {
        return (KMLSimpleData)this.getField("SimpleData");
    }

    public List<KMLRenderable> getRenderables() {
        return this.renderables;
    }

    protected void addRenderable(KMLRenderable kMLRenderable) {
        if (kMLRenderable != null) {
            this.getRenderables().add(kMLRenderable);
        }
    }

    @Override
    protected void doPreRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        List<KMLRenderable> list;
        if (this.getRenderables() == null) {
            this.initializeGeometry(kMLTraversalContext, this.getGeometry());
        }
        if ((list = this.getRenderables()) != null) {
            for (KMLRenderable kMLRenderable : list) {
                kMLRenderable.preRender(kMLTraversalContext, drawContext);
            }
        }
    }

    @Override
    protected void doRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        List<KMLRenderable> list = this.getRenderables();
        if (list != null) {
            for (KMLRenderable kMLRenderable : list) {
                kMLRenderable.render(kMLTraversalContext, drawContext);
            }
        }
        this.renderBalloon(kMLTraversalContext, drawContext);
    }

    protected void initializeGeometry(KMLTraversalContext kMLTraversalContext, KMLAbstractGeometry kMLAbstractGeometry) {
        if (kMLAbstractGeometry == null) {
            return;
        }
        if (this.getRenderables() == null) {
            this.renderables = new ArrayList<KMLRenderable>(1);
        }
        if (kMLAbstractGeometry instanceof KMLPoint) {
            this.addRenderable(this.selectPointRenderable(kMLTraversalContext, kMLAbstractGeometry));
        } else if (kMLAbstractGeometry instanceof KMLLinearRing) {
            this.addRenderable(this.selectLinearRingRenderable(kMLTraversalContext, kMLAbstractGeometry));
        } else if (kMLAbstractGeometry instanceof KMLLineString) {
            this.addRenderable(this.selectLineStringRenderable(kMLTraversalContext, kMLAbstractGeometry));
        } else if (kMLAbstractGeometry instanceof KMLPolygon) {
            this.addRenderable(this.selectPolygonRenderable(kMLTraversalContext, kMLAbstractGeometry));
        } else if (kMLAbstractGeometry instanceof KMLMultiGeometry) {
            List<KMLAbstractGeometry> list = ((KMLMultiGeometry)kMLAbstractGeometry).geometries;
            if (list != null) {
                for (KMLAbstractGeometry kMLAbstractGeometry2 : list) {
                    this.initializeGeometry(kMLTraversalContext, kMLAbstractGeometry2);
                }
            }
        } else if (kMLAbstractGeometry instanceof KMLModel) {
            this.addRenderable(this.selectModelRenderable(kMLTraversalContext, kMLAbstractGeometry));
        }
    }

    protected KMLRenderable selectModelRenderable(KMLTraversalContext kMLTraversalContext, KMLAbstractGeometry kMLAbstractGeometry) {
        return new KMLModelPlacemarkImpl(kMLTraversalContext, this, kMLAbstractGeometry);
    }

    protected KMLRenderable selectPointRenderable(KMLTraversalContext kMLTraversalContext, KMLAbstractGeometry kMLAbstractGeometry) {
        KMLPoint kMLPoint = (KMLPoint)kMLAbstractGeometry;
        if (kMLPoint.getCoordinates() == null) {
            return null;
        }
        return new KMLPointPlacemarkImpl(kMLTraversalContext, this, kMLAbstractGeometry);
    }

    protected KMLRenderable selectLineStringRenderable(KMLTraversalContext kMLTraversalContext, KMLAbstractGeometry kMLAbstractGeometry) {
        KMLLineString kMLLineString = (KMLLineString)kMLAbstractGeometry;
        if (kMLLineString.getCoordinates() == null) {
            return null;
        }
        return new KMLLineStringPlacemarkImpl(kMLTraversalContext, this, kMLAbstractGeometry);
    }

    protected KMLRenderable selectLinearRingRenderable(KMLTraversalContext kMLTraversalContext, KMLAbstractGeometry kMLAbstractGeometry) {
        KMLLinearRing kMLLinearRing = (KMLLinearRing)kMLAbstractGeometry;
        if (kMLLinearRing.getCoordinates() == null) {
            return null;
        }
        KMLLineStringPlacemarkImpl kMLLineStringPlacemarkImpl = new KMLLineStringPlacemarkImpl(kMLTraversalContext, this, kMLAbstractGeometry);
        if (kMLLineStringPlacemarkImpl.getAltitudeMode() == 1) {
            kMLLineStringPlacemarkImpl.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        }
        return kMLLineStringPlacemarkImpl;
    }

    protected KMLRenderable selectPolygonRenderable(KMLTraversalContext kMLTraversalContext, KMLAbstractGeometry kMLAbstractGeometry) {
        KMLPolygon kMLPolygon = (KMLPolygon)kMLAbstractGeometry;
        if (kMLPolygon.getOuterBoundary().getCoordinates() == null) {
            return null;
        }
        if ("clampToGround".equals(kMLPolygon.getAltitudeMode()) || !this.isValidAltitudeMode(kMLPolygon.getAltitudeMode())) {
            return new KMLSurfacePolygonImpl(kMLTraversalContext, this, kMLAbstractGeometry);
        }
        if (kMLPolygon.isExtrude()) {
            return new KMLExtrudedPolygonImpl(kMLTraversalContext, this, kMLAbstractGeometry);
        }
        return new KMLPolygonImpl(kMLTraversalContext, this, kMLAbstractGeometry);
    }

    protected boolean isValidAltitudeMode(String string) {
        return "clampToGround".equals(string) || "relativeToGround".equals(string) || "absolute".equals(string);
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLPlacemark)) {
            String string = Logging.getMessage("KML.InvalidElementType", kMLAbstractObject.getClass().getName());
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        super.applyChange(kMLAbstractObject);
        KMLPlacemark kMLPlacemark = (KMLPlacemark)kMLAbstractObject;
        if (kMLPlacemark.getGeometry() != null) {
            this.setGeometry(kMLPlacemark.getGeometry());
            this.renderables = null;
        }
        if (kMLPlacemark.hasStyle()) {
            Message message = new Message("KMLAbstractObject.StyleChanged", kMLPlacemark);
            if (this.renderables != null) {
                for (KMLRenderable kMLRenderable : this.renderables) {
                    kMLRenderable.onMessage(message);
                }
            }
        }
    }

    @Override
    public void onChange(Message message) {
        if ("KMLAbstractObject.GeometryChanged".equals(message.getName())) {
            this.renderables = null;
        } else if ("KMLAbstractObject.StyleChanged".equals(message.getName())) {
            for (KMLRenderable kMLRenderable : this.renderables) {
                kMLRenderable.onMessage(message);
            }
        }
        super.onChange(message);
    }
}

