/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.geom.Position;
import java.util.ArrayList;
import java.util.List;

public class KMLCoordinateTokenizer {
    protected int i;
    protected char[] buffer;
    protected List<String> words = new ArrayList<String>(3);
    protected StringBuilder nextWord = new StringBuilder();
    protected boolean inWord;
    protected boolean afterComma = false;

    public KMLCoordinateTokenizer(String string) {
        this.buffer = string.trim().toCharArray();
    }

    public boolean hasMoreTokens() {
        return this.i < this.buffer.length;
    }

    public Position nextPosition() throws NumberFormatException {
        this.words.clear();
        while (this.i < this.buffer.length) {
            char c;
            if (Character.isWhitespace(c = this.buffer[this.i++])) {
                if (this.inWord) {
                    this.wordBoundary();
                }
                if (this.afterComma || this.words.size() < 2) continue;
                break;
            }
            if (c == ',') {
                if (this.inWord) {
                    this.wordBoundary();
                }
                this.afterComma = true;
                if (this.words.size() < 3) continue;
                break;
            }
            this.inWord = true;
            this.afterComma = false;
            this.nextWord.append(c);
        }
        if (this.inWord) {
            this.wordBoundary();
        }
        return this.makePosition();
    }

    protected Position makePosition() {
        if (this.words.size() > 2) {
            return Position.fromDegrees(Double.valueOf(this.words.get(1)), Double.valueOf(this.words.get(0)), Double.valueOf(this.words.get(2)));
        }
        if (this.words.size() == 2) {
            return Position.fromDegrees(Double.valueOf(this.words.get(1)), Double.valueOf(this.words.get(0)));
        }
        return null;
    }

    protected void wordBoundary() {
        this.inWord = false;
        this.words.add(this.nextWord.toString());
        this.nextWord = new StringBuilder();
    }
}

