/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.ogc.OGCCapabilityInformation;
import gov.nasa.worldwind.ogc.OGCServiceInformation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public abstract class OGCCapabilities
extends AbstractXMLEventParser {
    protected QName SERVICE;
    protected QName CAPABILITY;
    protected QName VERSION;
    protected QName UPDATE_SEQUENCE;
    protected String version;
    protected String updateSequence;
    protected OGCServiceInformation serviceInformation;
    protected OGCCapabilityInformation capabilityInformation;
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;

    public abstract String getDefaultNamespaceURI();

    public abstract boolean isRootElementName(QName var1);

    public OGCCapabilities(String string, Object object) {
        super(string);
        this.eventReader = this.createReader(object);
        this.initialize();
    }

    private void initialize() {
        this.parserContext = this.createParserContext(this.eventReader);
        this.SERVICE = new QName(this.getNamespaceURI(), "Service");
        this.CAPABILITY = new QName(this.getNamespaceURI(), "Capability");
        this.VERSION = new QName(this.getNamespaceURI(), "version");
        this.UPDATE_SEQUENCE = new QName(this.getNamespaceURI(), "updateSequence");
        this.getParserContext().registerParser(this.SERVICE, new OGCServiceInformation(this.getNamespaceURI()));
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        this.parserContext = new BasicXMLEventParserContext(xMLEventReader);
        this.parserContext.setDefaultNamespaceURI(this.getDefaultNamespaceURI());
        return this.parserContext;
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        if (xMLEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OGCServiceInformation oGCServiceInformation = null;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.SERVICE)) {
            oGCServiceInformation = new OGCServiceInformation(this.getNamespaceURI());
        }
        return xMLEventParserContext.allocate(xMLEvent, oGCServiceInformation);
    }

    public OGCCapabilities parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.parserContext;
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEvent.isStartElement() && this.isRootElementName(xMLEvent.asStartElement().getName())) {
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.SERVICE)) {
            Object object2;
            XMLEventParser xMLEventParser2 = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser2 != null && (object2 = xMLEventParser2.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object2 instanceof OGCServiceInformation) {
                this.setServiceInformation((OGCServiceInformation)object2);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CAPABILITY) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OGCCapabilityInformation) {
            this.setCapabilityInformation((OGCCapabilityInformation)object);
        }
    }

    @Override
    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (xMLEventParserContext.isSameAttributeName(attribute.getName(), this.VERSION)) {
                this.setVersion(attribute.getValue());
                continue;
            }
            if (!xMLEventParserContext.isSameAttributeName(attribute.getName(), this.UPDATE_SEQUENCE)) continue;
            this.setUpdateSequence(attribute.getValue());
        }
    }

    protected XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public OGCServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    protected void setServiceInformation(OGCServiceInformation oGCServiceInformation) {
        this.serviceInformation = oGCServiceInformation;
    }

    protected void setCapabilityInformation(OGCCapabilityInformation oGCCapabilityInformation) {
        this.capabilityInformation = oGCCapabilityInformation;
    }

    public OGCCapabilityInformation getCapabilityInformation() {
        return this.capabilityInformation;
    }

    public String getVersion() {
        return this.version;
    }

    protected void setVersion(String string) {
        this.version = string;
    }

    public String getUpdateSequence() {
        return this.updateSequence;
    }

    protected void setUpdateSequence(String string) {
        this.updateSequence = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Version: ").append(this.getVersion() != null ? this.getVersion() : "none").append("\n");
        stringBuilder.append("UpdateSequence: ").append(this.getUpdateSequence() != null ? this.getUpdateSequence() : "none");
        stringBuilder.append("\n");
        stringBuilder.append(this.getServiceInformation() != null ? this.getServiceInformation() : "Service Information: none");
        stringBuilder.append("\n");
        stringBuilder.append(this.getCapabilityInformation() != null ? this.getCapabilityInformation() : "Capability Information: none");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

