/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.layers.rpf.RPFGenerator;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

class RPFRetriever
extends WWObjectImpl
implements Retriever {
    private volatile ByteBuffer byteBuffer;
    private volatile int contentLength = 0;
    private AtomicInteger contentLengthRead = new AtomicInteger(0);
    private volatile String state = "gov.nasa.worldwind.RetrieverStatusNotStarted";
    private volatile String contentType;
    private long submitTime;
    private long beginTime;
    private long endTime;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private int staleRequestLimit = -1;
    private final RPFGenerator.RPFServiceInstance service;
    private final URL url;
    private final RetrievalPostProcessor postProcessor;
    private int responseCode;
    public static final int RESPONSE_CODE_OK = 1;
    public static final int RESPONSE_CODE_NO_CONTENT = 2;

    public RPFRetriever(RPFGenerator.RPFServiceInstance rPFServiceInstance, URL uRL, RetrievalPostProcessor retrievalPostProcessor) {
        if (rPFServiceInstance == null) {
            String string = "Service is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (retrievalPostProcessor == null) {
            String string = Logging.getMessage("nullValue.PostProcessorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.service = rPFServiceInstance;
        this.url = uRL;
        this.postProcessor = retrievalPostProcessor;
    }

    @Override
    public final ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    @Override
    public final int getContentLength() {
        return this.contentLength;
    }

    @Override
    public final int getContentLengthRead() {
        return this.contentLengthRead.get();
    }

    protected void setContentLengthRead(int n) {
        this.contentLengthRead.set(n);
    }

    @Override
    public final String getName() {
        return this.url.toString();
    }

    @Override
    public final String getState() {
        return this.state;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public long getExpirationTime() {
        return 0L;
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public void setSubmitTime(long l) {
        this.submitTime = l;
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void setBeginTime(long l) {
        this.beginTime = l;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long l) {
        this.endTime = l;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    @Override
    public int getStaleRequestLimit() {
        return this.staleRequestLimit;
    }

    @Override
    public void setStaleRequestLimit(int n) {
        this.staleRequestLimit = n;
    }

    public final RPFGenerator.RPFServiceInstance getService() {
        return this.service;
    }

    public final URL getURL() {
        return this.url;
    }

    public final RetrievalPostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Retriever call() throws Exception {
        if (this.interrupted()) {
            return this;
        }
        try {
            this.setState("gov.nasa.worldwind.RetrieverStatusStarted");
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusConnecting");
            }
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusReading");
                this.byteBuffer = this.read();
            }
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
            }
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorAttemptingToRetrieve", this.url.toString()), exception);
        }
        finally {
            this.end();
        }
        return this;
    }

    private void setState(String string) {
        String string2 = this.state;
        this.state = string;
        this.firePropertyChange("gov.nasa.worldwind.avkey.RetrieverState", string2, this.state);
    }

    private boolean interrupted() {
        if (Thread.currentThread().isInterrupted()) {
            this.setState("gov.nasa.worldwind.RetrieverStatusInterrupted");
            String string = Logging.getMessage("URLRetriever.RetrievalInterruptedFor", this.url.toString());
            Logging.logger().fine(string);
            return true;
        }
        return false;
    }

    private void end() throws Exception {
        try {
            if (this.postProcessor != null) {
                this.byteBuffer = this.postProcessor.run(this);
            }
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            Logging.logger().log(Level.SEVERE, Logging.getMessage("Retriever.ErrorPostProcessing", this.url.toString()), exception);
            throw exception;
        }
    }

    private ByteBuffer read() throws Exception {
        ByteBuffer byteBuffer = this.doRead(this.service, this.url);
        if (byteBuffer == null) {
            this.contentLength = 0;
        }
        return byteBuffer;
    }

    protected ByteBuffer doRead(RPFGenerator.RPFServiceInstance rPFServiceInstance, URL uRL) throws Exception {
        ByteBuffer byteBuffer = null;
        BufferedImage bufferedImage = rPFServiceInstance.serviceRequest(uRL);
        if (bufferedImage != null && (byteBuffer = DDSCompressor.compressImage(bufferedImage)) != null) {
            int n = byteBuffer.limit();
            this.contentType = "image/dds";
            this.contentLength = n;
            this.setContentLengthRead(n);
        }
        this.responseCode = byteBuffer != null ? 1 : 2;
        return byteBuffer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RPFRetriever rPFRetriever = (RPFRetriever)object;
        return !(this.url == null ? rPFRetriever.url != null : !this.url.toString().contentEquals(rPFRetriever.url.toString()));
    }

    public int hashCode() {
        int n = this.url != null ? this.url.hashCode() : 0;
        return n;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }
}

