/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Color;
import javax.media.opengl.GL2;

public class SkyGradientLayer
extends AbstractLayer {
    protected static final int STACKS = 12;
    protected static final int SLICES = 64;
    protected double thickness = 100000.0;
    protected float[] horizonColor = new float[]{0.76f, 0.76f, 0.8f, 1.0f};
    protected float[] zenithColor = new float[]{0.26f, 0.47f, 0.83f, 1.0f};

    public SkyGradientLayer() {
        this.setPickEnabled(false);
    }

    public double getAtmosphereThickness() {
        return this.thickness;
    }

    public void setAtmosphereThickness(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.thickness = d;
    }

    public Color getHorizonColor() {
        return new Color(this.horizonColor[0], this.horizonColor[1], this.horizonColor[2], this.horizonColor[3]);
    }

    public void setHorizonColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        color.getColorComponents(this.horizonColor);
    }

    public Color getZenithColor() {
        return new Color(this.zenithColor[0], this.zenithColor[1], this.zenithColor[2], this.zenithColor[3]);
    }

    public void setZenithColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        color.getColorComponents(this.zenithColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRender(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 4096);
            gL2.glDisable(2929);
            gL2.glDepthMask(false);
            gL2.glBlendFunc(770, 771);
            gL2.glEnable(3042);
            this.applyDrawProjection(drawContext, oGLStackHandler);
            this.applyDrawTransform(drawContext, oGLStackHandler);
            this.updateSkyDome(drawContext);
        }
        finally {
            drawContext.restoreDefaultDepthTesting();
            drawContext.restoreDefaultBlending();
            drawContext.restoreDefaultCurrentColor();
            oGLStackHandler.pop(gL2);
        }
    }

    protected void applyDrawTransform(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        View view = drawContext.getView();
        oGLStackHandler.pushModelview(gL2);
        Vec4 vec4 = view.getEyePoint();
        Vec4 vec42 = SkyGradientLayer.CartesianToSpherical(vec4.x, vec4.y, vec4.z);
        gL2.glRotatef((float)Angle.fromRadians((double)vec42.z).degrees, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef((float)(-Angle.fromRadians((double)vec42.y).degrees + 90.0), 1.0f, 0.0f, 0.0f);
        gL2.glTranslatef(0.0f, (float)view.getEyePoint().getLength3(), 0.0f);
    }

    protected void applyDrawProjection(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        View view = drawContext.getView();
        double d = view.getViewport().getWidth();
        double d2 = view.getViewport().getHeight();
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        Matrix matrix = Matrix.fromPerspective(view.getFieldOfView(), d, d2, 100.0, view.getHorizonDistance() + 10000.0);
        double[] dArray = new double[16];
        matrix.toArray(dArray, 0, false);
        oGLStackHandler.pushProjection(gL2);
        gL2.glLoadMatrixd(dArray, 0);
    }

    protected void updateSkyDome(DrawContext drawContext) {
        double d;
        View view = drawContext.getView();
        double d2 = view.getHorizonDistance();
        double d3 = view.getEyePoint().getLength3();
        Position position = drawContext.getGlobe().computePositionFromPoint(view.getEyePoint());
        double d4 = drawContext.getGlobe().getRadiusAt(position);
        double d5 = position.getElevation();
        double d6 = (-1.5707963267948966 + Math.acos(d2 / d3)) * 180.0 / Math.PI;
        double d7 = 90.0;
        float f = 1.0f;
        float f2 = 2.0f;
        if (d5 >= this.thickness) {
            d = Math.sqrt(d3 * d3 - (d4 + this.thickness) * (d4 + this.thickness));
            d7 = (-1.5707963267948966 + Math.acos(d / d3)) * 180.0 / Math.PI;
            f = 0.0f;
            f2 = 1.0f;
        }
        if (d5 < this.thickness && d5 > this.thickness * 0.7) {
            d = (this.thickness - d5) / (this.thickness - this.thickness * 0.7);
            d7 = d * 90.0;
            f = (float)d;
            f2 = 1.0f + (float)d;
        }
        this.drawSkyDome(drawContext, (float)d2, d6, d7, 64, 12, f, f2);
    }

    protected void drawSkyDome(DrawContext drawContext, float f, double d, double d2, int n, int n2, float f2, float f3) {
        double d3;
        int n3;
        double d4 = d2;
        GL2 gL2 = drawContext.getGL().getGL2();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d - Math.max((d2 - d) / 4.0, 3.0);
        gL2.glBegin(8);
        for (n3 = 0; n3 <= n; ++n3) {
            d3 = 180.0f - (float)n3 / (float)n * 360.0f;
            Vec4 vec4 = SkyGradientLayer.SphericalToCartesian(d8, d3, f);
            gL2.glColor4d(this.zenithColor[0], this.zenithColor[1], this.zenithColor[2], 0.0);
            gL2.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            vec4 = SkyGradientLayer.SphericalToCartesian(d, d3, f);
            gL2.glColor4d(this.horizonColor[0], this.horizonColor[1], this.horizonColor[2], this.horizonColor[3]);
            gL2.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
        }
        gL2.glEnd();
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            double d9 = (float)(n3 - 1) / ((float)n2 - 1.0f);
            double d10 = 1.0 - Math.cos(d9 * Math.PI / 2.0);
            d8 = d + d10 * (d2 - d);
            double d11 = Math.min(1.0, d9 * (double)f3);
            double d12 = 1.0 - d11;
            double d13 = 1.0 - Math.pow(d9, 4.0) * (double)(1.0f - f2);
            double d14 = (float)n3 / ((float)n2 - 1.0f);
            double d15 = 1.0 - Math.cos(d14 * Math.PI / 2.0);
            d4 = d + d15 * (d2 - d);
            d5 = Math.min(1.0, d14 * (double)f3);
            d6 = 1.0 - d5;
            d7 = 1.0 - Math.pow(d14, 4.0) * (double)(1.0f - f2);
            gL2.glBegin(8);
            for (int i = 0; i <= n; ++i) {
                d3 = 180.0f - (float)i / (float)n * 360.0f;
                Vec4 vec4 = SkyGradientLayer.SphericalToCartesian(d8, d3, f);
                gL2.glColor4d((double)this.horizonColor[0] * d12 + (double)this.zenithColor[0] * d11, (double)this.horizonColor[1] * d12 + (double)this.zenithColor[1] * d11, (double)this.horizonColor[2] * d12 + (double)this.zenithColor[2] * d11, ((double)this.horizonColor[3] * d12 + (double)this.zenithColor[3] * d11) * d13);
                gL2.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                vec4 = SkyGradientLayer.SphericalToCartesian(d4, d3, f);
                gL2.glColor4d((double)this.horizonColor[0] * d6 + (double)this.zenithColor[0] * d5, (double)this.horizonColor[1] * d6 + (double)this.zenithColor[1] * d5, (double)this.horizonColor[2] * d6 + (double)this.zenithColor[2] * d5, ((double)this.horizonColor[3] * d6 + (double)this.zenithColor[3] * d5) * d7);
                gL2.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            }
            gL2.glEnd();
        }
        gL2.glBegin(8);
        for (n3 = 0; n3 <= n; ++n3) {
            d3 = 180.0f - (float)n3 / (float)n * 360.0f;
            Vec4 vec4 = SkyGradientLayer.SphericalToCartesian(d4, d3, f);
            gL2.glColor4d((double)this.horizonColor[0] * d6 + (double)this.zenithColor[0] * d5, (double)this.horizonColor[1] * d6 + (double)this.zenithColor[1] * d5, (double)this.horizonColor[2] * d6 + (double)this.zenithColor[2] * d5, ((double)this.horizonColor[3] * d6 + (double)this.zenithColor[3] * d5) * d7);
            gL2.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            vec4 = SkyGradientLayer.SphericalToCartesian(d2, d3, f);
            gL2.glColor4d(this.zenithColor[0], this.zenithColor[1], this.zenithColor[2], f2 < 1.0f ? 0.0 : (double)this.zenithColor[3]);
            gL2.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
        }
        gL2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gL2.glEnd();
    }

    protected static Vec4 SphericalToCartesian(double d, double d2, double d3) {
        double d4 = d3 * Math.cos(d *= Math.PI / 180);
        return new Vec4(d4 * Math.sin(d2 *= Math.PI / 180), d3 * Math.sin(d), d4 * Math.cos(d2));
    }

    protected static Vec4 CartesianToSpherical(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = Math.atan2(d, d3);
        double d6 = Math.asin(d2 / d4);
        return new Vec4(d4, d6, d5);
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.Earth.SkyGradientLayer.Name");
    }
}

