/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.worldfile;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorldFile {
    public static final String WORLD_FILE_X_PIXEL_SIZE = "gov.nasa.worldwind.worldFile.XPixelSize";
    public static final String WORLD_FILE_Y_PIXEL_SIZE = "gov.nasa.worldwind.worldFile.YPixelSize";
    public static final String WORLD_FILE_X_COEFFICIENT = "gov.nasa.worldwind.worldFile.XCoefficient";
    public static final String WORLD_FILE_Y_COEFFICIENT = "gov.nasa.worldwind.worldFile.YCoefficient";
    public static final String WORLD_FILE_X_LOCATION = "gov.nasa.worldwind.worldFile.XLocation";
    public static final String WORLD_FILE_Y_LOCATION = "gov.nasa.worldwind.worldFile.YLocation";
    public static final String WORLD_FILE_IMAGE_SIZE = "gov.nasa.worldwind.worldFile.ImageSize";
    protected static final Pattern GEOGCS_WKT_PATTERN = Pattern.compile("\\{*GEOGCS[\\[\\(](.*)[\\]\\)]\\}*");
    protected static final Pattern PROJCS_WKT_PATTERN = Pattern.compile("\\{*PROJCS[\\[\\(](.*)[\\]\\)]\\}*");
    protected static final Pattern UTM_NAME_WKT_PATTERN = Pattern.compile(".*UTM.*ZONE.*?(\\d+).*?([\\w\\s]+).*?");

    public static File[] getWorldFiles(File file) throws FileNotFoundException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        File file2 = file.getParentFile();
        final String string = WWIO.getSuffix(file.getPath());
        final String string2 = WWIO.replaceSuffix(file.getName(), "").trim();
        return file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string3) {
                int n = string2.length() + 4;
                if (!(string3 = string3.trim()).startsWith(string2) || string3.length() != n) {
                    return false;
                }
                if (string3.toLowerCase().endsWith("w")) {
                    String string22 = WWIO.getSuffix(string3);
                    if (string != null && string22 != null && string22.substring(0, 1).equalsIgnoreCase(string.substring(0, 1)) && string.toLowerCase().endsWith(string22.substring(1, 2))) {
                        return true;
                    }
                }
                return string3.toLowerCase().endsWith(".hdr") || string3.toLowerCase().endsWith(".prj");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static AVList decodeWorldFiles(File[] fileArray, AVList aVList) throws FileNotFoundException {
        if (fileArray == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        for (File file : fileArray) {
            if (file.exists()) continue;
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        for (File file : fileArray) {
            if (file.getName().toLowerCase().endsWith("w")) {
                WorldFile.scanWorldFile(file, aVList);
                continue;
            }
            if (file.getName().toLowerCase().endsWith(".hdr")) {
                WorldFile.scanHdrFile(file, aVList);
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".prj")) continue;
            String string = WWIO.readTextFile(file);
            WorldFile.decodeOGCCoordinateSystemWKT(string, aVList);
        }
        Object object = aVList.getValue(WORLD_FILE_IMAGE_SIZE);
        if (object != null && object instanceof int[]) {
            int[] nArray = (int[])object;
        } else {
            int[] nArray = WorldFile.parseSize(aVList);
            if (nArray != null) {
                aVList.setValue(WORLD_FILE_IMAGE_SIZE, nArray);
            }
        }
        object = WorldFile.parseByteOrder(aVList);
        if (object != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", object);
        }
        if ((object = WorldFile.parsePixelFormat(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", object);
        }
        if ((object = WorldFile.parseDataType(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", object);
        }
        if ((object = WorldFile.parseMissingDataValue(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataValue", object);
        }
        Sector sector = null;
        if (WorldFile.worldFileValuesAppearGeographic(aVList)) {
            void var2_7;
            if (var2_7 != null) {
                sector = WorldFile.parseDegrees(aVList, (int)var2_7[0], (int)var2_7[1]);
            } else {
                BufferedImage bufferedImage = (BufferedImage)aVList.getValue("gov.nasa.worldwind.avkey.Image");
                if (bufferedImage != null) {
                    sector = WorldFile.parseDegrees(aVList, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
            }
            if (sector != null) {
                aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
            }
        }
        if (null == sector && (sector = WorldFile.extractSectorFromHeader(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        return aVList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void scanWorldFile(File file, AVList aVList) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        try {
            for (int i = 0; i < 6; ++i) {
                if (scanner.hasNextDouble()) {
                    switch (i) {
                        case 0: {
                            aVList.setValue(WORLD_FILE_X_PIXEL_SIZE, scanner.nextDouble());
                            break;
                        }
                        case 1: {
                            aVList.setValue(WORLD_FILE_Y_COEFFICIENT, scanner.nextDouble());
                            break;
                        }
                        case 2: {
                            aVList.setValue(WORLD_FILE_X_COEFFICIENT, scanner.nextDouble());
                            break;
                        }
                        case 3: {
                            aVList.setValue(WORLD_FILE_Y_PIXEL_SIZE, scanner.nextDouble());
                            break;
                        }
                        case 4: {
                            aVList.setValue(WORLD_FILE_X_LOCATION, scanner.nextDouble());
                            break;
                        }
                        case 5: {
                            aVList.setValue(WORLD_FILE_Y_LOCATION, scanner.nextDouble());
                        }
                    }
                    continue;
                }
                String string = Logging.getMessage("SurfaceImage.WorldFileLineMissing", i + 1);
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void scanHdrFile(File file, AVList aVList) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        try {
            Object object;
            while (scanner.hasNext()) {
                double d;
                object = scanner.next().toUpperCase();
                if (!scanner.hasNext()) {
                    return;
                }
                if (((String)object).equalsIgnoreCase("NROWS")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("NCOLS")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("NBANDS")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("NBITS")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("BANDROWBYTES")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("TOTALROWBYTES")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("SKIPBYTES")) {
                    aVList.setValue((String)object, scanner.nextInt());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("NODATA") || ((String)object).equalsIgnoreCase("NODATA_VALUE")) {
                    d = scanner.nextDouble();
                    aVList.setValue((String)object, d);
                    aVList.setValue("NODATA", d);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("ULXMAP")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("ULYMAP")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("XLLCORNER")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("YLLCORNER")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("XLLCENTER")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("YLLCCENTER")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("XDIM")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("YDIM")) {
                    aVList.setValue((String)object, scanner.nextDouble());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("CELLSIZE")) {
                    d = scanner.nextDouble();
                    aVList.setValue((String)object, d);
                    aVList.setValue("XDIM", d);
                    aVList.setValue("YDIM", d);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("PIXELTYPE")) {
                    aVList.setValue((String)object, scanner.next());
                    continue;
                }
                if (((String)object).equalsIgnoreCase("BYTEORDER")) {
                    aVList.setValue((String)object, scanner.next());
                    continue;
                }
                aVList.setValue((String)object, scanner.next());
            }
            if ((!aVList.hasKey("NBANDS") || !aVList.hasKey("NBITS")) && aVList.hasKey("gov.nasa.worldwind.avkey.FileSize") && aVList.hasKey("NCOLS") && aVList.hasKey("NROWS")) {
                object = (Integer)aVList.getValue("NCOLS");
                Integer n = (Integer)aVList.getValue("NROWS");
                Integer n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.FileSize");
                double d = (double)n2.intValue() / (double)((Integer)object).intValue() / (double)n.intValue() * 8.0;
                if (d == 8.0 || d == 16.0 || d == 32.0) {
                    aVList.setValue("NBANDS", 1);
                    aVList.setValue("NBITS", (int)d);
                }
                if (d == 24.0) {
                    aVList.setValue("NBANDS", 3);
                    aVList.setValue("NBITS", 8);
                }
            }
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] decodeWorldFile(File file) throws FileNotFoundException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        double[] dArray = new double[6];
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        try {
            for (int i = 0; i < 6; ++i) {
                if (!scanner.hasNextDouble()) {
                    String string = Logging.getMessage("SurfaceImage.WorldFileLineMissing", i + 1);
                    Logging.logger().severe(string);
                    throw new IllegalStateException(string);
                }
                dArray[i] = scanner.nextDouble();
            }
        }
        finally {
            scanner.close();
        }
        return dArray;
    }

    public static boolean worldFileValuesAppearGeographic(AVList aVList) {
        Object object = aVList.getValue(WORLD_FILE_X_LOCATION);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d = (Double)object;
        object = aVList.getValue(WORLD_FILE_Y_LOCATION);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d2 = (Double)object;
        object = aVList.getValue(WORLD_FILE_X_PIXEL_SIZE);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d3 = (Double)object;
        object = aVList.getValue(WORLD_FILE_Y_PIXEL_SIZE);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d4 = (Double)object;
        return Angle.isValidLongitude(d3) && Angle.isValidLatitude(d4) && Angle.isValidLongitude(d) && Angle.isValidLatitude(d2);
    }

    public static Sector extractSectorFromHeader(AVList aVList) {
        if (null != aVList && aVList.hasKey("NROWS") && aVList.hasKey("NCOLS") && aVList.hasKey("XDIM") && aVList.hasKey("YDIM")) {
            Integer n = (Integer)aVList.getValue("NCOLS");
            Integer n2 = (Integer)aVList.getValue("NROWS");
            double d = Math.abs((Double)aVList.getValue("XDIM"));
            double d2 = Math.abs((Double)aVList.getValue("YDIM"));
            if (aVList.hasKey("XLLCORNER") && aVList.hasKey("YLLCORNER") && Angle.isValidLongitude((Double)aVList.getValue("XLLCORNER")) && Angle.isValidLatitude((Double)aVList.getValue("YLLCORNER"))) {
                double d3 = Angle.fromDegreesLongitude((double)((Double)aVList.getValue((String)"XLLCORNER")).doubleValue()).degrees;
                double d4 = Angle.fromDegreesLatitude((double)((Double)aVList.getValue((String)"YLLCORNER")).doubleValue()).degrees;
                double d5 = Angle.fromDegreesLongitude((double)(d3 + (double)n.intValue() * d)).degrees;
                double d6 = Angle.fromDegreesLatitude((double)(d4 + (double)n2.intValue() * d2)).degrees;
                return Sector.fromDegrees(d4, d6, d3, d5);
            }
            if (aVList.hasKey("XLLCENTER") && aVList.hasKey("YLLCCENTER") && Angle.isValidLongitude((Double)aVList.getValue("XLLCENTER")) && Angle.isValidLatitude((Double)aVList.getValue("YLLCCENTER"))) {
                double d7 = Angle.fromDegreesLongitude((double)(((Double)aVList.getValue((String)"XLLCENTER")).doubleValue() - d / 2.0)).degrees;
                double d8 = Angle.fromDegreesLatitude((double)(((Double)aVList.getValue((String)"YLLCENTER")).doubleValue() - d2 / 2.0)).degrees;
                double d9 = Angle.fromDegreesLongitude((double)(d7 + (double)n.intValue() * d)).degrees;
                double d10 = Angle.fromDegreesLatitude((double)(d8 + (double)n2.intValue() * d2)).degrees;
                return Sector.fromDegrees(d8, d10, d7, d9);
            }
            if (aVList.hasKey("ULXMAP") && aVList.hasKey("ULYMAP") && Angle.isValidLongitude((Double)aVList.getValue("ULXMAP")) && Angle.isValidLatitude((Double)aVList.getValue("ULYMAP"))) {
                double d11 = Angle.fromDegreesLongitude((double)(((Double)aVList.getValue((String)"ULXMAP")).doubleValue() - d / 2.0)).degrees;
                double d12 = Angle.fromDegreesLatitude((double)(((Double)aVList.getValue((String)"ULYMAP")).doubleValue() + d2 / 2.0)).degrees;
                double d13 = Angle.fromDegreesLongitude((double)(d11 + (double)n.intValue() * d)).degrees;
                double d14 = Angle.fromDegreesLatitude((double)(d12 - (double)n2.intValue() * d2)).degrees;
                return Sector.fromDegrees(d14, d12, d11, d13);
            }
        }
        return null;
    }

    public static int[] parseSize(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("NROWS") && !aVList.hasKey("NCOLS")) {
            return null;
        }
        return new int[]{(Integer)aVList.getValue("NCOLS"), (Integer)aVList.getValue("NROWS")};
    }

    public static Object parseByteOrder(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("BYTEORDER")) {
            return null;
        }
        String string = aVList.getValue("BYTEORDER").toString();
        return string.equalsIgnoreCase("I") || string.equalsIgnoreCase("LSBFIRST") ? "gov.nasa.worldwind.avkey.LittleEndian" : "gov.nasa.worldwind.avkey.BigEndian";
    }

    public static Object parsePixelFormat(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (aVList.hasKey("NBANDS") && aVList.hasKey("NBITS")) {
            Integer n = (Integer)aVList.getValue("NBANDS");
            Integer n2 = (Integer)aVList.getValue("NBITS");
            if (n == 1 && (n2 == 16 || n2 == 32)) {
                return "gov.nasa.worldwind.avkey.Elevation";
            }
            if (n == 1 && n2 == 8) {
                return "gov.nasa.worldwind.avkey.Image";
            }
            if (n == 3 && n2 == 8) {
                return "gov.nasa.worldwind.avkey.Image";
            }
        }
        return null;
    }

    public static Object parseDataType(AVList aVList) {
        String string;
        if (aVList == null) {
            return null;
        }
        if (aVList.hasKey("NBITS")) {
            Integer n = (Integer)aVList.getValue("NBITS");
            switch (n) {
                case 8: {
                    return "gov.nasa.worldwind.avkey.Int8";
                }
                case 16: {
                    return "gov.nasa.worldwind.avkey.Int16";
                }
                case 32: {
                    return "gov.nasa.worldwind.avkey.Float32";
                }
            }
        } else if (aVList.hasKey("PIXELTYPE") && "FLOAT".equalsIgnoreCase(string = (String)aVList.getValue("PIXELTYPE"))) {
            return "gov.nasa.worldwind.avkey.Float32";
        }
        return null;
    }

    public static Object parseMissingDataValue(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("NODATA")) {
            return null;
        }
        return aVList.getValue("NODATA");
    }

    public static Sector parseDegrees(AVList aVList, int n, int n2) {
        Angle angle;
        Angle angle2;
        Angle angle3;
        Angle angle4;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0 || n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidImageSize");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle5 = Angle.fromDegrees((Double)aVList.getValue(WORLD_FILE_Y_LOCATION));
        double d = (Double)aVList.getValue(WORLD_FILE_Y_PIXEL_SIZE);
        Angle angle6 = angle5.addDegrees((d <= 0.0 ? d : -d) * (double)n2);
        Angle angle7 = Angle.fromDegrees((Double)aVList.getValue(WORLD_FILE_X_LOCATION));
        Angle angle8 = angle7.addDegrees((Double)aVList.getValue(WORLD_FILE_X_PIXEL_SIZE) * (double)n);
        if (angle7.degrees < angle8.degrees) {
            angle4 = angle7;
            angle3 = angle8;
        } else {
            angle4 = angle8;
            angle3 = angle7;
        }
        if (angle5.degrees < angle6.degrees) {
            angle2 = angle5;
            angle = angle6;
        } else {
            angle2 = angle6;
            angle = angle5;
        }
        Sector sector = new Sector(angle2, angle, angle4, angle3);
        if (!sector.isWithinLatLonLimits()) {
            String string = Logging.getMessage("generic.SectorNotGeographic");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return sector;
    }

    public static Sector parseUTM(double[] dArray, int n, int n2, int n3, String string) {
        if (dArray.length < 6) {
            String string2 = Logging.getMessage("WorldFile.TooFewWorldFileValues");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n <= 0 || n2 <= 0) {
            String string3 = Logging.getMessage("generic.InvalidImageSize");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (n3 < 1 || n3 > 60) {
            String string4 = Logging.getMessage("generic.ZoneIsInvalid", n3);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (!"gov.nasa.worldwind.avkey.North".equals(string) && !"gov.nasa.worldwdind.avkey.South".equals(string)) {
            String string5 = Logging.getMessage("generic.HemisphereIsInvalid", string);
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double d7 = d5;
        double d8 = d6;
        double d9 = d * (double)(n - 1) + d3 * (double)(n2 - 1) + d7;
        double d10 = d2 * (double)(n - 1) + d4 * (double)(n2 - 1) + d8;
        UTMCoord uTMCoord = UTMCoord.fromUTM(n3, string, d7, d8);
        UTMCoord uTMCoord2 = UTMCoord.fromUTM(n3, string, d9, d10);
        Sector sector = new Sector(uTMCoord2.getLatitude(), uTMCoord.getLatitude(), uTMCoord.getLongitude(), uTMCoord2.getLongitude());
        if (!sector.isWithinLatLonLimits()) {
            String string6 = Logging.getMessage("generic.SectorNotGeographic");
            Logging.logger().severe(string6);
            throw new IllegalStateException(string6);
        }
        return sector;
    }

    public static AVList decodeOGCCoordinateSystemWKT(String string, AVList aVList) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        string = string.trim().toUpperCase();
        try {
            Matcher matcher = GEOGCS_WKT_PATTERN.matcher(string);
            if (matcher.matches()) {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
            } else {
                matcher = PROJCS_WKT_PATTERN.matcher(string);
                if (matcher.matches()) {
                    aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Projected");
                    String string3 = matcher.group(1);
                    Matcher matcher2 = UTM_NAME_WKT_PATTERN.matcher(string3);
                    if (matcher2.matches()) {
                        Integer n;
                        aVList.setValue("gov.nasa.worldwind.avkey.Projection.Name", "gov.nasa.worldwind.avkey.Projection.UTM");
                        String string4 = matcher2.group(1);
                        if (string4 != null && (n = WWUtil.makeInteger(string4.trim())) != null && n >= 1 && n <= 60) {
                            aVList.setValue("gov.nasa.worldwind.avkey.Projection.Zone", n);
                        }
                        if (aVList.getValue("gov.nasa.worldwind.avkey.Projection.Zone") == null) {
                            Logging.logger().warning(Logging.getMessage("generic.ZoneIsInvalid", string4));
                        }
                        if ((string4 = matcher2.group(2)) != null) {
                            if ((string4 = string4.trim()).startsWith("N") || string4.startsWith("n")) {
                                aVList.setValue("gov.nasa.worldwind.avkey.Projection.Hemisphere", "gov.nasa.worldwind.avkey.North");
                            } else if (string4.startsWith("S") || string4.startsWith("s")) {
                                aVList.setValue("gov.nasa.worldwind.avkey.Projection.Hemisphere", "gov.nasa.worldwdind.avkey.South");
                            }
                        }
                        if (aVList.getValue("gov.nasa.worldwind.avkey.Projection.Hemisphere") == null) {
                            Logging.logger().warning(Logging.getMessage("generic.HemisphereIsInvalid", string4));
                        }
                    } else {
                        aVList.setValue("gov.nasa.worldwind.avkey.Projection.Name", "gov.nasa.worldwind.Projection.Unknown");
                    }
                } else {
                    aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Unknown");
                }
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionParsingCoordinateSystem", string), exception);
        }
        return aVList;
    }

    public static boolean hasWorldFiles(Object object) {
        try {
            File file = WWIO.getFileForLocalAddress(object);
            if (null == file) {
                return false;
            }
            File[] fileArray = WorldFile.getWorldFiles(file);
            if (fileArray == null || fileArray.length == 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void readWorldFiles(Object object, AVList aVList) throws IOException {
        File file = WWIO.getFileForLocalAddress(object);
        if (null == file) {
            String string = Logging.getMessage("generic.UnrecognizedSourceType", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File[] fileArray = WorldFile.getWorldFiles(file);
        WorldFile.decodeWorldFiles(fileArray, aVList);
        Object object2 = aVList.getValue(WORLD_FILE_IMAGE_SIZE);
        if (object2 != null && object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            if (!aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
                aVList.setValue("gov.nasa.worldwind.avkey.Width", nArray[0]);
            }
            if (!aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
                aVList.setValue("gov.nasa.worldwind.avkey.Height", nArray[1]);
            }
        }
    }
}

