/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.json;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.json.BasicJSONEventParser;
import gov.nasa.worldwind.formats.json.BasicJSONEventParserContext;
import gov.nasa.worldwind.formats.json.JSONEventParser;
import gov.nasa.worldwind.formats.json.JSONEventParserContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;

public class JSONDoc
implements Closeable {
    protected JsonParser jsonParser;
    protected Object rootObject;
    protected String displayName;

    public JSONDoc(Object object) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            this.displayName = WWIO.getSourcePath(object);
            this.initialize(object);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileReading", this.displayName);
            Logging.logger().log(Level.SEVERE, string, exception);
            throw new WWRuntimeException(string, exception);
        }
    }

    protected void initialize(Object object) throws Exception {
        JsonFactory jsonFactory = new JsonFactory();
        this.jsonParser = jsonFactory.createJsonParser(WWIO.openStream(object));
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    public void parse() throws IOException {
        if (this.jsonParser == null) {
            Logging.logger().warning(Logging.getMessage("generic.ParserUninitialized", this.displayName));
            return;
        }
        JSONEventParserContext jSONEventParserContext = this.createEventParserContext(this.jsonParser);
        if (jSONEventParserContext == null) {
            Logging.logger().warning(Logging.getMessage("generic.CannotParse", this.displayName));
            return;
        }
        if (!jSONEventParserContext.hasNext()) {
            return;
        }
        JSONEventParser jSONEventParser = this.createRootObjectParser();
        if (jSONEventParser == null) {
            Logging.logger().warning(Logging.getMessage("generic.CannotParse", this.displayName));
            return;
        }
        this.rootObject = jSONEventParser.parse(jSONEventParserContext, jSONEventParserContext.nextEvent());
    }

    @Override
    public void close() {
        if (this.jsonParser != null) {
            WWIO.closeStream(this.jsonParser, this.displayName);
            this.jsonParser = null;
        }
    }

    protected JSONEventParserContext createEventParserContext(JsonParser jsonParser) throws IOException {
        return new BasicJSONEventParserContext(jsonParser);
    }

    protected JSONEventParser createRootObjectParser() throws IOException {
        return new BasicJSONEventParser();
    }
}

