/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.MipMappedBufferedImageRaster;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.dds.DDSConstants;
import gov.nasa.worldwind.formats.dds.DDSHeader;
import gov.nasa.worldwind.formats.dds.DDSPixelFormat;
import gov.nasa.worldwind.formats.dds.DXT1Decompressor;
import gov.nasa.worldwind.formats.dds.DXT3Decompressor;
import gov.nasa.worldwind.formats.dds.DXTDecompressor;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class DDSDecompressor {
    public DataRaster decompress(Object object, AVList aVList) throws Exception {
        return this.doDecompress(object, aVList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataRaster doDecompress(Object object, AVList aVList) throws Exception {
        String string;
        Object object2;
        if (null == aVList || !aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            String string2 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        File file = WWIO.getFileForLocalAddress(object);
        if (null == file) {
            String string3 = Logging.getMessage("generic.UnrecognizedSourceType", object.getClass().getName());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (!file.exists()) {
            String string4 = Logging.getMessage("generic.FileNotFound", file.getAbsolutePath());
            Logging.logger().severe(string4);
            throw new FileNotFoundException(string4);
        }
        if (!file.canRead()) {
            String string5 = Logging.getMessage("generic.FileNoReadPermission", file.getAbsolutePath());
            Logging.logger().severe(string5);
            throw new IOException(string5);
        }
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        Object object3 = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            fileChannel = randomAccessFile.getChannel();
            MappedByteBuffer mappedByteBuffer = this.mapFile(fileChannel, 0L, fileChannel.size());
            mappedByteBuffer.position(0);
            DDSHeader dDSHeader = DDSHeader.readFrom(object);
            int n = dDSHeader.getWidth();
            int n2 = dDSHeader.getHeight();
            if (!WWMath.isPowerOfTwo(n) || !WWMath.isPowerOfTwo(n2)) {
                String string6 = Logging.getMessage("generic.InvalidImageSize", n, n2);
                Logging.logger().severe(string6);
                throw new WWRuntimeException(string6);
            }
            int n3 = dDSHeader.getMipMapCount();
            DDSPixelFormat dDSPixelFormat = dDSHeader.getPixelFormat();
            if (null == dDSPixelFormat) {
                String string7 = Logging.getMessage("generic.MissingRequiredParameter", "DDSD_PIXELFORMAT");
                String string8 = Logging.getMessage("generic.InvalidImageFormat", string7);
                Logging.logger().severe(string8);
                throw new WWRuntimeException(string8);
            }
            DXTDecompressor dXTDecompressor = null;
            int n4 = dDSPixelFormat.getFourCC();
            if (n4 == DDSConstants.D3DFMT_DXT3) {
                dXTDecompressor = new DXT3Decompressor();
            } else if (n4 == DDSConstants.D3DFMT_DXT1) {
                dXTDecompressor = new DXT1Decompressor();
            }
            if (null == dXTDecompressor) {
                String string9 = Logging.getMessage("generic.UnsupportedCodec", n4);
                Logging.logger().severe(string9);
                throw new WWRuntimeException(string9);
            }
            Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
            if (n3 == 0) {
                mappedByteBuffer.position(128);
                object2 = dXTDecompressor.decompress(mappedByteBuffer, dDSHeader.getWidth(), dDSHeader.getHeight());
                object3 = new BufferedImageRaster(sector, (BufferedImage)object2, aVList);
            } else if (n3 > 0) {
                object2 = new ArrayList();
                int n5 = dDSHeader.getLinearSize();
                int n6 = 128;
                for (int i = 0; i < n3; ++i) {
                    int n7 = (int)Math.pow(2.0, i);
                    int n8 = dDSHeader.getWidth() / n7;
                    int n9 = dDSHeader.getHeight() / n7;
                    if (n8 < 4 || n9 < 4) break;
                    mappedByteBuffer.position(n6);
                    BufferedImage bufferedImage = dXTDecompressor.decompress(mappedByteBuffer, n8, n9);
                    ((ArrayList)object2).add(bufferedImage);
                    n6 += n5;
                    n5 /= 4;
                }
                BufferedImage[] bufferedImageArray = new BufferedImage[((ArrayList)object2).size()];
                bufferedImageArray = ((ArrayList)object2).toArray(bufferedImageArray);
                object3 = new MipMappedBufferedImageRaster(sector, bufferedImageArray);
            }
            object2 = object3;
            string = null != file ? file.getAbsolutePath() : (null != object ? object.toString() : "unknown");
        }
        catch (Throwable throwable) {
            String string10 = null != file ? file.getAbsolutePath() : (null != object ? object.toString() : "unknown");
            WWIO.closeStream(fileChannel, string10);
            WWIO.closeStream(randomAccessFile, string10);
            throw throwable;
        }
        WWIO.closeStream(fileChannel, string);
        WWIO.closeStream(randomAccessFile, string);
        return object2;
    }

    protected MappedByteBuffer mapFile(FileChannel fileChannel, long l, long l2) throws Exception {
        if (null == fileChannel || !fileChannel.isOpen()) {
            String string = Logging.getMessage("nullValue.ChannelIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (fileChannel.size() < l + l2) {
            String string = fileChannel.size() + " < " + (l + l2);
            String string2 = Logging.getMessage("generic.LengthIsInvalid", string);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, l, l2);
    }
}

