/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.AlphaBlockDXT3;
import gov.nasa.worldwind.formats.dds.BlockDXT1Compressor;
import gov.nasa.worldwind.formats.dds.BlockDXT3;
import gov.nasa.worldwind.formats.dds.ColorBlock4x4;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.util.Logging;

public class BlockDXT3Compressor {
    protected BlockDXT1Compressor dxt1Compressor = new BlockDXT1Compressor();

    public void compressBlockDXT3(ColorBlock4x4 colorBlock4x4, DXTCompressionAttributes dXTCompressionAttributes, BlockDXT3 blockDXT3) {
        if (colorBlock4x4 == null) {
            String string = Logging.getMessage("nullValue.ColorBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (blockDXT3 == null) {
            String string = Logging.getMessage("nullValue.DXTBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dxt1Compressor.compressBlockDXT1(colorBlock4x4, dXTCompressionAttributes, blockDXT3.colorBlock);
        this.compressBlockDXT3a(colorBlock4x4, blockDXT3.alphaBlock);
    }

    protected void compressBlockDXT3a(ColorBlock4x4 colorBlock4x4, AlphaBlockDXT3 alphaBlockDXT3) {
        alphaBlockDXT3.alphaValueMask = BlockDXT3Compressor.computeAlphaValueMask(colorBlock4x4);
    }

    protected static long computeAlphaValueMask(ColorBlock4x4 colorBlock4x4) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = 0xF & BlockDXT3Compressor.alpha4FromAlpha8(colorBlock4x4.color[2 * i].a);
            int n2 = 0xF & BlockDXT3Compressor.alpha4FromAlpha8(colorBlock4x4.color[2 * i + 1].a);
            long l2 = n2 << 4 | n;
            l |= l2 << 8 * i;
        }
        return l;
    }

    protected static int alpha4FromAlpha8(int n) {
        int n2 = Math.max((n >> 4) - 1, 0);
        int n3 = n >> 4;
        int n4 = Math.min((n >> 4) + 1, 15);
        n2 = n2 << 4 | n2;
        n3 = n3 << 4 | n3;
        n4 = n4 << 4 | n4;
        int n5 = BlockDXT3Compressor.alphaDistanceSquared(n2, n);
        int n6 = BlockDXT3Compressor.alphaDistanceSquared(n3, n);
        int n7 = BlockDXT3Compressor.alphaDistanceSquared(n4, n);
        if (n5 < n6 && n5 < n7) {
            return n2 >> 4;
        }
        if (n6 < n7) {
            return n3 >> 4;
        }
        return n4 >> 4;
    }

    protected static int alphaDistanceSquared(int n, int n2) {
        return (n - n2) * (n - n2);
    }
}

