/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.dds.DDSDecompressor;
import gov.nasa.worldwind.formats.dds.DDSHeader;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.util.logging.Level;

public class DDSRasterReader
extends AbstractDataRasterReader {
    protected static final String[] ddsMimeTypes = new String[]{"image/dds"};
    protected static final String[] ddsSuffixes = new String[]{"dds"};

    public DDSRasterReader() {
        super(ddsMimeTypes, ddsSuffixes);
    }

    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        try {
            DDSHeader dDSHeader = DDSHeader.readFrom(object);
            if (null != dDSHeader && dDSHeader.getWidth() > 0 && dDSHeader.getHeight() > 0) {
                if (null != aVList && !aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
                    aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                }
                return true;
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            string = null == string && null != exception.getCause() ? exception.getCause().getMessage() : string;
            Logging.logger().log(Level.FINEST, string, exception);
        }
        return false;
    }

    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        DataRaster[] dataRasterArray;
        if (null == aVList || !aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        DataRaster dataRaster = null;
        try {
            DDSDecompressor dDSDecompressor = new DDSDecompressor();
            dataRaster = dDSDecompressor.decompress(object, aVList);
            if (null != dataRaster) {
                dataRaster.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
            }
        }
        catch (WWRuntimeException wWRuntimeException) {
            throw new IOException(wWRuntimeException.getMessage());
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            string = WWUtil.isEmpty(string) && null != throwable.getCause() ? throwable.getCause().getMessage() : string;
            Logging.logger().log(Level.FINEST, string, throwable);
            throw new IOException(string);
        }
        if (null != dataRaster) {
            DataRaster[] dataRasterArray2 = new DataRaster[1];
            dataRasterArray = dataRasterArray2;
            dataRasterArray2[0] = dataRaster;
        } else {
            dataRasterArray = null;
        }
        return dataRasterArray;
    }

    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        try {
            DDSHeader dDSHeader = DDSHeader.readFrom(object);
            if (null != dDSHeader && null != aVList) {
                aVList.setValue("gov.nasa.worldwind.avkey.Width", dDSHeader.getWidth());
                aVList.setValue("gov.nasa.worldwind.avkey.Height", dDSHeader.getHeight());
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            string = WWUtil.isEmpty(string) && null != exception.getCause() ? exception.getCause().getMessage() : string;
            Logging.logger().log(Level.FINEST, string, exception);
            throw new IOException(string);
        }
    }
}

