/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.animation.Interpolator;

public class BasicAnimator
implements Animator {
    private boolean stopOnInvalidState = false;
    private boolean lastStateValid = true;
    private boolean hasNext = true;
    protected Interpolator interpolator;

    public BasicAnimator() {
        this.interpolator = null;
    }

    public BasicAnimator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public void next() {
        this.set(this.interpolator.nextInterpolant());
    }

    @Override
    public void set(double d) {
        this.setImpl(d);
        if (this.isStopOnInvalidState() && !this.isLastStateValid()) {
            this.stop();
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void start() {
        this.hasNext = true;
    }

    @Override
    public void stop() {
        this.hasNext = false;
    }

    protected void setImpl(double d) {
    }

    public void setStopOnInvalidState(boolean bl) {
        this.stopOnInvalidState = bl;
    }

    public boolean isStopOnInvalidState() {
        return this.stopOnInvalidState;
    }

    protected void flagLastStateInvalid() {
        this.lastStateValid = false;
    }

    protected boolean isLastStateValid() {
        return this.lastStateValid;
    }
}

