/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.lang.reflect.Field;
import java.util.Collection;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGReference;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.persist.persistors.generic.ObjectTagger;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2XML {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String REFF_ID = "idx";
    private WriteXML out;
    private final ObjectTagger tagger = new ObjectTagger();

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        this.out = writeXML;
        try {
            PersistorUtil.beginEncogObject(encogPersistedObject.getClass().getSimpleName(), writeXML, encogPersistedObject, true);
            this.tagger.analyze(encogPersistedObject);
            for (Field field : ReflectionUtil.getAllFields(encogPersistedObject.getClass())) {
                if (!ReflectionUtil.shouldAccessField(field, true)) continue;
                field.setAccessible(true);
                Object object = field.get(encogPersistedObject);
                writeXML.beginTag(field.getName());
                this.saveField(object);
                writeXML.endTag();
            }
            writeXML.endTag();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistError(illegalAccessException);
        }
    }

    private void saveCollection(Collection<?> collection) throws IllegalAccessException {
        for (Object obj : collection) {
            this.saveObject(obj);
        }
    }

    private void saveField(Object object) throws IllegalAccessException {
        if (object != null) {
            if (object instanceof Collection) {
                this.saveCollection((Collection)object);
            } else if (object.getClass().isEnum()) {
                this.out.addText(object.toString());
            } else if (ReflectionUtil.isPrimitive(object) || ReflectionUtil.isSimple(object)) {
                this.out.addText(object.toString());
            } else if (object instanceof String) {
                this.out.addText(object.toString());
            } else {
                this.saveObject(object);
            }
        }
    }

    private void saveFieldReference(Object object) {
        if (this.tagger.hasReference(object)) {
            this.out.addAttribute("ref", "" + this.tagger.getReference(object));
        } else {
            this.out.addAttribute("ref", "");
        }
        this.out.beginTag(object.getClass().getSimpleName());
        this.out.endTag();
    }

    private void saveObject(Object object) throws IllegalAccessException {
        Object object2;
        if (object.getClass().isArray()) {
            return;
        }
        if (this.tagger.hasReference(object)) {
            int n = this.tagger.getReference(object);
            this.out.addAttribute(REFF_ID, "" + n);
        }
        Collection<Field> collection = ReflectionUtil.getAllFields(object.getClass());
        for (Field field : collection) {
            field.setAccessible(true);
            if (!ReflectionUtil.shouldAccessField(field, false) || field.getAnnotation(EGAttribute.class) == null) continue;
            object2 = field.get(object);
            this.out.addAttribute(field.getName(), object2.toString());
        }
        this.out.beginTag(object.getClass().getSimpleName());
        for (Field field : collection) {
            field.setAccessible(true);
            if (!ReflectionUtil.shouldAccessField(field, false) || field.getAnnotation(EGAttribute.class) != null) continue;
            object2 = field.get(object);
            this.out.beginTag(field.getName());
            if (field.getAnnotation(EGReference.class) != null) {
                this.saveFieldReference(object2);
            } else {
                this.saveField(object2);
            }
            this.out.endTag();
        }
        this.out.endTag();
    }
}

