/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class TrainingContinuationPersistor
implements Persistor {
    public static final String TAG_ITEMS = "items";
    public static final String TAG_ITEM = "Item";
    public static final String ATTRIBUTE_NAME = "name";
    private TrainingContinuation current;

    public void handleItem(ReadXML readXML) {
        String string = readXML.getTag().getAttributeValue(ATTRIBUTE_NAME);
        String string2 = readXML.readTextToTag();
        double[] dArray = NumberList.fromList(CSVFormat.EG_FORMAT, string2);
        this.current.put(string, dArray);
    }

    public void handleItems(ReadXML readXML) {
        while (readXML.readToTag()) {
            if (readXML.is(TAG_ITEM, true)) {
                this.handleItem(readXML);
                continue;
            }
            if (!readXML.is(TAG_ITEMS, false)) continue;
            break;
        }
    }

    public EncogPersistedObject load(ReadXML readXML) {
        this.current = new TrainingContinuation();
        String string = readXML.getTag().getAttributes().get(ATTRIBUTE_NAME);
        String string2 = readXML.getTag().getAttributes().get("description");
        this.current.setName(string);
        this.current.setDescription(string2);
        while (readXML.readToTag()) {
            if (readXML.is(TAG_ITEMS, true)) {
                this.handleItems(readXML);
                continue;
            }
            if (!readXML.is("TrainingContinuation", false)) continue;
            break;
        }
        return this.current;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("TrainingContinuation", writeXML, encogPersistedObject, true);
        this.current = (TrainingContinuation)encogPersistedObject;
        writeXML.beginTag(TAG_ITEMS);
        this.saveItems(writeXML);
        writeXML.endTag();
        writeXML.endTag();
    }

    public void saveItems(WriteXML writeXML) {
        for (String string : this.current.getContents().keySet()) {
            writeXML.addAttribute(ATTRIBUTE_NAME, string);
            writeXML.beginTag(TAG_ITEM);
            double[] dArray = (double[])this.current.get(string);
            StringBuilder stringBuilder = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, dArray);
            writeXML.addText(stringBuilder.toString());
            writeXML.endTag();
        }
    }
}

