/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicLayerPersistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextLayerPersistor
implements Persistor {
    public final String PROPERTY_CONTEXT = "context";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EncogPersistedObject load(ReadXML readXML) {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        String string2 = null;
        ActivationFunction activationFunction = null;
        String string3 = readXML.getTag().getName();
        double d = 1.0;
        while (readXML.readToTag()) {
            if (readXML.is("activation", true)) {
                readXML.readToTag();
                object = readXML.getTag().getName();
                activationFunction = BasicLayerPersistor.loadActivation((String)object, readXML);
                continue;
            }
            if (readXML.is("neurons", true)) {
                n = readXML.readIntToTag();
                continue;
            }
            if (readXML.is("x", true)) {
                n2 = readXML.readIntToTag();
                continue;
            }
            if (readXML.is("y", true)) {
                n3 = readXML.readIntToTag();
                continue;
            }
            if (readXML.is("threshold", true)) {
                string = readXML.readTextToTag();
                continue;
            }
            if (readXML.is("context", true)) {
                string2 = readXML.readTextToTag();
                continue;
            }
            if (readXML.is("biasActivation", true)) {
                d = Double.parseDouble(readXML.readTextToTag());
                continue;
            }
            if (!readXML.is(string3, false)) continue;
        }
        if (n > 0) {
            object = new ContextLayer(activationFunction, n);
            if (string2 != null) {
                double[] dArray = NumberList.fromList(CSVFormat.EG_FORMAT, string2);
                for (int i = 0; i < dArray.length; ++i) {
                    ((ContextLayer)object).getContext().setData(i, dArray[i]);
                }
            }
            ((BasicLayer)object).setX(n2);
            ((BasicLayer)object).setY(n3);
            return object;
        }
        return null;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        StringBuilder stringBuilder;
        PersistorUtil.beginEncogObject("ContextLayer", writeXML, encogPersistedObject, false);
        ContextLayer contextLayer = (ContextLayer)encogPersistedObject;
        writeXML.addProperty("neurons", contextLayer.getNeuronCount());
        writeXML.addProperty("x", contextLayer.getX());
        writeXML.addProperty("y", contextLayer.getY());
        if (contextLayer.hasBias()) {
            stringBuilder = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, contextLayer.getBiasWeights());
            writeXML.addProperty("threshold", stringBuilder.toString());
        }
        stringBuilder = new StringBuilder();
        NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, contextLayer.getContext().getData());
        writeXML.addProperty("context", stringBuilder.toString());
        writeXML.addProperty("biasActivation", contextLayer.getBiasActivation());
        BasicLayerPersistor.saveActivationFunction(contextLayer.getActivationFunction(), writeXML);
        writeXML.endTag();
    }
}

