/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags.write;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.encog.EncogError;
import org.encog.neural.NeuralNetworkError;
import org.encog.parse.ParseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteTags {
    private final OutputStream output;
    private final Stack<String> tagStack;
    private final Map<String, String> attributes;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public WriteTags(OutputStream outputStream) {
        this.output = outputStream;
        this.tagStack = new Stack();
        this.attributes = new HashMap<String, String>();
    }

    public void addAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public void addCDATA(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        stringBuilder.append("![CDATA[");
        stringBuilder.append(string);
        stringBuilder.append("]]");
        stringBuilder.append('>');
        try {
            this.output.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            throw new ParseError(iOException);
        }
    }

    public void addProperty(String string, double d) {
        this.beginTag(string);
        this.addText("" + d);
        this.endTag();
    }

    public void addProperty(String string, int n) {
        this.addProperty(string, "" + n);
    }

    public void addProperty(String string, String string2) {
        this.beginTag(string);
        this.addText(string2);
        this.endTag();
    }

    public void addProperty(String string, double[] dArray, int n) {
        if (dArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(dArray[i]);
            }
            this.addProperty(string, stringBuilder.toString());
        }
    }

    public void addProperty(String string, int[] nArray, int n) {
        if (nArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(nArray[i]);
            }
            this.addProperty(string, stringBuilder.toString());
        }
    }

    public void addText(String string) {
        try {
            this.output.write(string.getBytes());
        }
        catch (IOException iOException) {
            throw new ParseError(iOException);
        }
    }

    public void beginDocument() {
    }

    public void beginTag(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(string);
        if (this.attributes.size() > 0) {
            for (String string2 : this.attributes.keySet()) {
                String string3 = this.attributes.get(string2);
                stringBuilder.append(' ');
                stringBuilder.append(string2);
                stringBuilder.append('=');
                stringBuilder.append("\"");
                stringBuilder.append(string3);
                stringBuilder.append("\"");
            }
        }
        stringBuilder.append(">");
        try {
            this.output.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            throw new ParseError(iOException);
        }
        this.attributes.clear();
        this.tagStack.push(string);
    }

    public void close() {
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            throw new EncogError(iOException);
        }
    }

    public void endDocument() {
    }

    public void endTag() {
        if (this.tagStack.isEmpty()) {
            throw new NeuralNetworkError("Can't create end tag, no beginning tag.");
        }
        String string = this.tagStack.pop();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("</");
        stringBuilder.append(string);
        stringBuilder.append(">");
        try {
            this.output.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            throw new ParseError(iOException);
        }
    }

    public void endTag(String string) {
        if (!this.tagStack.peek().equals(string)) {
            String string2 = "End tag mismatch, should be ending: " + this.tagStack.peek() + ", but trying to end: " + string + ".";
            if (this.logger.isErrorEnabled()) {
                this.logger.error(string2);
            }
            throw new ParseError(string2);
        }
        this.endTag();
    }
}

