/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.segregate;

import java.util.ArrayList;
import java.util.Collection;
import org.encog.normalize.DataNormalization;
import org.encog.normalize.input.InputField;
import org.encog.normalize.segregate.SegregationRange;
import org.encog.normalize.segregate.Segregator;
import org.encog.persist.annotations.EGReference;

public class RangeSegregator
implements Segregator {
    @EGReference
    private InputField sourceField;
    private boolean include;
    private final Collection<SegregationRange> ranges = new ArrayList<SegregationRange>();
    @EGReference
    private DataNormalization normalization;

    public RangeSegregator() {
    }

    public RangeSegregator(InputField inputField, boolean bl) {
        this.sourceField = inputField;
        this.include = bl;
    }

    public void addRange(double d, double d2, boolean bl) {
        SegregationRange segregationRange = new SegregationRange(d, d2, bl);
        this.addRange(segregationRange);
    }

    public void addRange(SegregationRange segregationRange) {
        this.ranges.add(segregationRange);
    }

    public DataNormalization getNormalization() {
        return this.normalization;
    }

    public InputField getSourceField() {
        return this.sourceField;
    }

    public void init(DataNormalization dataNormalization) {
        this.normalization = dataNormalization;
    }

    public boolean shouldInclude() {
        double d = this.sourceField.getCurrentValue();
        for (SegregationRange segregationRange : this.ranges) {
            if (!segregationRange.inRange(d)) continue;
            return segregationRange.isIncluded();
        }
        return this.include;
    }

    public void passInit() {
    }
}

