/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetStrategy
implements Strategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final double required;
    private final int cycles;
    private Train train;
    private int badCycleCount;

    public ResetStrategy(double d, int n) {
        this.required = d;
        this.cycles = n;
        this.badCycleCount = 0;
    }

    public void init(Train train) {
        this.train = train;
    }

    public void postIteration() {
    }

    public void preIteration() {
        if (this.train.getError() > this.required) {
            ++this.badCycleCount;
            if (this.badCycleCount > this.cycles) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to imrove network, resetting.");
                }
                this.train.getNetwork().reset();
                this.badCycleCount = 0;
            }
        } else {
            this.badCycleCount = 0;
        }
    }
}

