/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.cross;

import org.encog.engine.network.flat.FlatNetwork;
import org.encog.neural.data.folded.FoldedDataSet;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.cross.CrossTraining;
import org.encog.neural.networks.training.cross.NetworkFold;

public class CrossValidationKFold
extends CrossTraining {
    private final Train train;
    private final NetworkFold[] networks;
    private final FlatNetwork flatNetwork;

    public CrossValidationKFold(Train train, int n) {
        super(train.getNetwork(), (FoldedDataSet)train.getTraining());
        this.train = train;
        this.getFolded().fold(n);
        this.flatNetwork = train.getNetwork().getStructure().getFlat();
        this.networks = new NetworkFold[n];
        for (int i = 0; i < this.networks.length; ++i) {
            this.networks[i] = new NetworkFold(this.flatNetwork);
        }
    }

    public void iteration() {
        double d = 0.0;
        for (int i = 0; i < this.getFolded().getNumFolds(); ++i) {
            this.networks[i].copyToNetwork(this.flatNetwork);
            for (int j = 0; j < this.getFolded().getNumFolds(); ++j) {
                if (j == i) continue;
                this.getFolded().setCurrentFold(j);
                this.train.iteration();
            }
            this.getFolded().setCurrentFold(i);
            double d2 = this.flatNetwork.calculateError(this.getFolded());
            d += d2;
            this.networks[i].copyFromNetwork(this.flatNetwork);
        }
        this.setError(d / (double)this.getFolded().getNumFolds());
    }
}

